/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.xml.sax.InputSource;

public abstract class ParserContext
extends RubyObject {
    private static final long serialVersionUID = 1L;
    protected InputSource source = null;
    protected IRubyObject detected_encoding = null;
    protected int stringDataSize = -1;
    protected String java_encoding;

    public ParserContext(Ruby ruby) {
        super(ruby, ruby.getObject());
    }

    public ParserContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected InputSource getInputSource() {
        return this.source;
    }

    public void setIOInputSource(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.source = new InputSource();
        ParserContext.setUrl(threadContext, this.source, iRubyObject2);
        Ruby ruby = threadContext.getRuntime();
        if (!iRubyObject.respondsTo("read")) {
            throw ruby.newTypeError("must respond to :read");
        }
        this.source.setByteStream((InputStream)new IOInputStream(iRubyObject));
        if (this.java_encoding != null) {
            this.source.setEncoding(this.java_encoding);
        }
    }

    public void setStringInputSource(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList;
        Object object;
        this.source = new InputSource();
        ParserContext.setUrl(threadContext, this.source, iRubyObject2);
        Ruby ruby = threadContext.getRuntime();
        if (!(iRubyObject instanceof RubyString)) {
            throw ruby.newTypeError("must be kind_of String");
        }
        RubyString rubyString = (RubyString)iRubyObject;
        if (rubyString.encoding(threadContext) != null && (object = NokogiriHelpers.getValidEncodingOrNull((IRubyObject)(byteList = rubyString.encoding(threadContext).asString()))) != null) {
            this.java_encoding = object;
        }
        byteList = rubyString.getByteList();
        this.stringDataSize = byteList.length() - byteList.begin();
        object = new ByteArrayInputStream(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        this.source.setByteStream((InputStream)object);
        this.source.setEncoding(this.java_encoding);
    }

    public static void setUrl(ThreadContext threadContext, InputSource inputSource, IRubyObject iRubyObject) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        if (string != null) {
            try {
                URI uRI = URI.create(string);
                inputSource.setSystemId(uRI.toURL().toString());
            }
            catch (Exception exception) {
                String string2;
                File file = new File(string);
                if (file.isAbsolute()) {
                    inputSource.setSystemId(string);
                }
                String string3 = threadContext.getRuntime().getCurrentDirectory();
                try {
                    string2 = new File(string3, string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = new File(string3, string).getAbsolutePath();
                }
                inputSource.setSystemId(string2);
            }
        }
    }

    protected void setEncoding(String string) {
        this.source.setEncoding(string);
    }

    public void setInputSourceFile(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.source = new InputSource();
        ParserContext.setUrl(threadContext, this.source, iRubyObject);
    }

    public void setInputSource(InputStream inputStream) {
        this.source = new InputSource(inputStream);
    }

    public static abstract class ParserTask<T extends ParserContext>
    implements Callable<T> {
        protected final ThreadContext context;
        protected final IRubyObject handler;
        protected final T parser;

        protected ParserTask(ThreadContext threadContext, IRubyObject iRubyObject, T t) {
            this.context = threadContext;
            this.handler = iRubyObject;
            this.parser = t;
        }
    }

    public static class Options {
        protected static final long STRICT = 0L;
        protected static final long RECOVER = 1L;
        protected static final long NOENT = 2L;
        protected static final long DTDLOAD = 4L;
        protected static final long DTDATTR = 8L;
        protected static final long DTDVALID = 16L;
        protected static final long NOERROR = 32L;
        protected static final long NOWARNING = 64L;
        protected static final long PEDANTIC = 128L;
        protected static final long NOBLANKS = 256L;
        protected static final long SAX1 = 512L;
        protected static final long XINCLUDE = 1024L;
        protected static final long NONET = 2048L;
        protected static final long NODICT = 4096L;
        protected static final long NSCLEAN = 8192L;
        protected static final long NOCDATA = 16384L;
        protected static final long NOXINCNODE = 32768L;
        public final boolean strict;
        public final boolean recover;
        public final boolean noEnt;
        public final boolean dtdLoad;
        public final boolean dtdAttr;
        public final boolean dtdValid;
        public final boolean noError;
        public final boolean noWarning;
        public final boolean pedantic;
        public final boolean noBlanks;
        public final boolean sax1;
        public final boolean xInclude;
        public final boolean noNet;
        public final boolean noDict;
        public final boolean nsClean;
        public final boolean noCdata;
        public final boolean noXIncNode;

        protected static boolean test(long l, long l2) {
            return (l & l2) == l2;
        }

        public Options(long l) {
            this.strict = (l & 1L) == 0L;
            this.recover = Options.test(l, 1L);
            this.noEnt = Options.test(l, 2L);
            this.dtdLoad = Options.test(l, 4L);
            this.dtdAttr = Options.test(l, 8L);
            this.dtdValid = Options.test(l, 16L);
            this.noError = Options.test(l, 32L);
            this.noWarning = Options.test(l, 64L);
            this.pedantic = Options.test(l, 128L);
            this.noBlanks = Options.test(l, 256L);
            this.sax1 = Options.test(l, 512L);
            this.xInclude = Options.test(l, 1024L);
            this.noNet = Options.test(l, 2048L);
            this.noDict = Options.test(l, 4096L);
            this.nsClean = Options.test(l, 8192L);
            this.noCdata = Options.test(l, 16384L);
            this.noXIncNode = Options.test(l, 32768L);
        }
    }
}

