/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.logstash.config.ir.compiler.Closure;
import org.logstash.config.ir.compiler.FieldDeclarationGroup;
import org.logstash.config.ir.compiler.FieldDefinition;
import org.logstash.config.ir.compiler.ValueSyntaxElement;

final class ClassFields {
    private final Collection<FieldDefinition> definitions = new ArrayList<FieldDefinition>();
    private final Collection<Closure> afterInit = new ArrayList<Closure>();

    ClassFields() {
    }

    public ValueSyntaxElement add(Object obj) {
        return this.addField(FieldDefinition.fromValue(this.definitions.size(), obj));
    }

    public ValueSyntaxElement add(Class<?> type) {
        return this.addField(FieldDefinition.mutableUnassigned(this.definitions.size(), type));
    }

    public void addAfterInit(Closure closure) {
        this.afterInit.add(closure);
    }

    public Closure afterInit() {
        return Closure.wrap(this.afterInit.toArray(new Closure[0]));
    }

    public FieldDeclarationGroup ctorAssigned() {
        return new FieldDeclarationGroup(this.definitions.stream().filter(field -> field.getCtorArgument() != null).collect(Collectors.toList()));
    }

    public FieldDeclarationGroup inlineAssigned() {
        return new FieldDeclarationGroup(this.definitions.stream().filter(field -> field.getCtorArgument() == null).collect(Collectors.toList()));
    }

    private ValueSyntaxElement addField(FieldDefinition field) {
        this.definitions.add(field);
        return field.asVariable().access();
    }
}

