/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.ql.util.StringUtils;

public interface DateTimeField {
    public static <D extends DateTimeField> Map<String, D> initializeResolutionMap(D[] values) {
        HashMap<String, D> nameToPart = new HashMap<String, D>();
        for (D datePart : values) {
            String lowerCaseName = datePart.name().toLowerCase(Locale.ROOT);
            nameToPart.put(lowerCaseName, datePart);
            for (String alias : datePart.aliases()) {
                nameToPart.put(alias, datePart);
            }
        }
        return Collections.unmodifiableMap(nameToPart);
    }

    public static <D extends DateTimeField> List<String> initializeValidValues(D[] values) {
        return Arrays.stream(values).map(DateTimeField::name).collect(Collectors.toList());
    }

    public static <D extends DateTimeField> D resolveMatch(Map<String, D> resolutionMap, String possibleMatch) {
        return (D)((DateTimeField)resolutionMap.get(possibleMatch.toLowerCase(Locale.ROOT)));
    }

    public static List<String> findSimilar(Iterable<String> similars, String match) {
        return StringUtils.findSimilar((String)match, similars);
    }

    public String name();

    public Iterable<String> aliases();
}

