/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class BinaryDateTimeFunction
extends BinaryScalarFunction {
    private final ZoneId zoneId;

    public BinaryDateTimeFunction(Source source, Expression datePart, Expression timestamp, ZoneId zoneId) {
        super(source, datePart, timestamp);
        this.zoneId = zoneId;
    }

    protected abstract Expression.TypeResolution resolveType();

    public ZoneId zoneId() {
        return this.zoneId;
    }

    protected Pipe makePipe() {
        return this.createPipe(Expressions.pipe((Expression)this.left()), Expressions.pipe((Expression)this.right()), this.zoneId);
    }

    protected abstract Pipe createPipe(Pipe var1, Pipe var2, ZoneId var3);

    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return new ScriptTemplate(this.formatTemplate("{sql}." + this.scriptMethodName() + "(" + leftScript.template() + "," + rightScript.template() + ",{})"), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).variable((Object)this.zoneId.getId()).build(), this.dataType());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.zoneId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryDateTimeFunction that = (BinaryDateTimeFunction)((Object)o);
        return this.zoneId.equals(that.zoneId);
    }
}

