/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.shutdown.DeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.GetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.NodeSeenService;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.RestDeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.RestGetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.RestPutShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.TransportDeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.TransportGetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.TransportPutShutdownNodeAction;

public class ShutdownPlugin
extends Plugin
implements ActionPlugin {
    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, Tracer tracer, AllocationService allocationService, IndicesService indicesService) {
        NodeSeenService nodeSeenService = new NodeSeenService(clusterService);
        return Collections.singletonList(nodeSeenService);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler putShutdown = new ActionPlugin.ActionHandler((ActionType)PutShutdownNodeAction.INSTANCE, TransportPutShutdownNodeAction.class);
        ActionPlugin.ActionHandler deleteShutdown = new ActionPlugin.ActionHandler((ActionType)DeleteShutdownNodeAction.INSTANCE, TransportDeleteShutdownNodeAction.class);
        ActionPlugin.ActionHandler getStatus = new ActionPlugin.ActionHandler((ActionType)GetShutdownStatusAction.INSTANCE, TransportGetShutdownStatusAction.class);
        return Arrays.asList(putShutdown, deleteShutdown, getStatus);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestPutShutdownNodeAction(), new RestDeleteShutdownNodeAction(), new RestGetShutdownStatusAction()});
    }
}

