/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.service;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeleteServiceAccountTokenAction
extends SecurityBaseRestHandler {
    public RestDeleteServiceAccountTokenAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_security/service/{namespace}/{service}/credential/token/{name}"));
    }

    public String getName() {
        return "xpack_security_delete_service_account_token";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteServiceAccountTokenRequest deleteServiceAccountTokenRequest = new DeleteServiceAccountTokenRequest(request.param("namespace"), request.param("service"), request.param("name"));
        String refreshPolicy = request.param("refresh");
        if (refreshPolicy != null) {
            deleteServiceAccountTokenRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)refreshPolicy));
        }
        return channel -> client.execute((ActionType)DeleteServiceAccountTokenAction.INSTANCE, (ActionRequest)deleteServiceAccountTokenRequest, (ActionListener)new RestToXContentListener<DeleteServiceAccountTokenResponse>(channel){

            protected RestStatus getStatus(DeleteServiceAccountTokenResponse response) {
                return response.found() ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }
}

