/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyResponse;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public final class RestGetApiKeyAction
extends ApiKeyBaseRestHandler {
    public RestGetApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/api_key"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String apiKeyId = request.param("id");
        String apiKeyName = request.param("name");
        String userName = request.param("username");
        String realmName = request.param("realm_name");
        boolean myApiKeysOnly = request.paramAsBoolean("owner", false);
        boolean withLimitedBy = request.paramAsBoolean("with_limited_by", false);
        boolean activeOnly = request.paramAsBoolean("active_only", false);
        GetApiKeyRequest getApiKeyRequest = GetApiKeyRequest.builder().realmName(realmName).userName(userName).apiKeyId(apiKeyId).apiKeyName(apiKeyName).ownedByAuthenticatedUser(myApiKeysOnly).withLimitedBy(withLimitedBy).activeOnly(activeOnly).build();
        return channel -> client.execute((ActionType)GetApiKeyAction.INSTANCE, (ActionRequest)getApiKeyRequest, (ActionListener)new RestBuilderListener<GetApiKeyResponse>(channel){

            public RestResponse buildResponse(GetApiKeyResponse getApiKeyResponse, XContentBuilder builder) throws Exception {
                getApiKeyResponse.toXContent(builder, (ToXContent.Params)this.channel.request());
                if (Strings.hasText((String)apiKeyId) && getApiKeyResponse.getApiKeyInfos().length == 0) {
                    return new RestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    public String getName() {
        return "xpack_security_get_api_key";
    }
}

