/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.profile;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.ResultsAndErrors;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesRequest;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesResponse;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.DomainConfig;
import org.elasticsearch.xpack.core.security.authc.RealmDomain;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.profile.ProfileDocument;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecuritySystemIndices;

public class ProfileService {
    private static final Logger logger = LogManager.getLogger(ProfileService.class);
    private static final String DOC_ID_PREFIX = "profile_";
    private static final BackoffPolicy DEFAULT_BACKOFF = BackoffPolicy.exponentialBackoff();
    private static final int DIFFERENTIATOR_UPPER_LIMIT = 9;
    private static final long ACTIVATE_INTERVAL_IN_MS = TimeValue.timeValueSeconds((long)30L).millis();
    private final Settings settings;
    private final Clock clock;
    private final Client client;
    private final SecurityIndexManager profileIndex;
    private final ClusterService clusterService;
    private final Function<String, DomainConfig> domainConfigLookup;
    private final ThreadPool threadPool;
    private static final Pattern VALID_LITERAL_USERNAME = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]{0,255}$");
    private static final String INVALID_USERNAME_MESSAGE = "Security domain [%s] is configured to use literal username. As a result, creating new user profile requires the username to be at least 1 and no more than 256 characters. The username must begin with an alphanumeric character (a-z, A-Z, 0-9) and followed by any alphanumeric or dash (-) characters.";

    public ProfileService(Settings settings, Clock clock, Client client, SecurityIndexManager profileIndex, ClusterService clusterService, Function<String, DomainConfig> domainConfigLookup, ThreadPool threadPool) {
        this.settings = settings;
        this.clock = clock;
        this.client = client;
        this.profileIndex = profileIndex;
        this.clusterService = clusterService;
        this.domainConfigLookup = domainConfigLookup;
        this.threadPool = threadPool;
    }

    public void getProfiles(List<String> uids, Set<String> dataKeys, ActionListener<ResultsAndErrors<Profile>> listener) {
        this.getVersionedDocuments(uids, (ActionListener<ResultsAndErrors<VersionedDocument>>)listener.map(resultsAndErrors -> {
            if (resultsAndErrors != null) {
                return new ResultsAndErrors(resultsAndErrors.results().stream().map(versionedDocument -> versionedDocument.toProfile(dataKeys)).toList(), resultsAndErrors.errors());
            }
            return new ResultsAndErrors(List.of(), uids.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), uid -> new ElasticsearchException("profile index does not exist", new Object[0]))));
        }));
    }

    public void getProfileSubjects(Collection<String> uids, ActionListener<ResultsAndErrors<Map.Entry<String, Subject>>> listener) {
        this.getVersionedDocuments(uids, (ActionListener<ResultsAndErrors<VersionedDocument>>)listener.map(resultsAndErrors -> {
            if (resultsAndErrors != null) {
                return new ResultsAndErrors(resultsAndErrors.results().stream().map(VersionedDocument::doc).filter(ProfileDocument::enabled).map(doc -> Map.entry(doc.uid(), doc.user().toSubject())).toList(), resultsAndErrors.errors());
            }
            return new ResultsAndErrors(List.of(), Map.of());
        }));
    }

    public void activateProfile(Authentication authentication, ActionListener<Profile> listener) {
        Subject subject = authentication.getEffectiveSubject();
        if (Subject.Type.USER != subject.getType()) {
            listener.onFailure((Exception)new IllegalArgumentException("profile is supported for user only, but subject is a [" + subject.getType().name().toLowerCase(Locale.ROOT) + "]"));
            return;
        }
        if (subject.getUser() instanceof InternalUser) {
            listener.onFailure((Exception)new IllegalStateException("profile should not be created for internal user [" + subject.getUser().principal() + "]"));
            return;
        }
        this.searchVersionedDocumentForSubject(subject, (ActionListener<VersionedDocument>)ActionListener.wrap(versionedDocument -> {
            if (versionedDocument == null) {
                DomainConfig domainConfig = this.getDomainConfigForSubject(subject);
                if (domainConfig == null || !domainConfig.literalUsername()) {
                    assert (domainConfig == null || domainConfig.suffix() == null);
                    this.createNewProfile(subject, ProfileDocument.computeBaseUidForSubject(subject) + "_0", listener);
                } else {
                    assert (domainConfig.suffix() != null);
                    this.validateUsername(subject);
                    this.createNewProfile(subject, "u_" + subject.getUser().principal() + "_" + domainConfig.suffix(), listener);
                }
            } else {
                this.updateProfileForActivate(subject, (VersionedDocument)versionedDocument, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void updateProfileData(UpdateProfileDataRequest request, ActionListener<AcknowledgedResponse> listener) {
        XContentBuilder builder;
        try {
            builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.field("user_profile");
            builder.startObject();
            if (!request.getLabels().isEmpty()) {
                builder.field("labels", request.getLabels());
            }
            if (!request.getData().isEmpty()) {
                builder.field("application_data", request.getData());
            }
            builder.endObject();
            builder.endObject();
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        this.doUpdate(this.buildUpdateRequest(request.getUid(), builder, request.getRefreshPolicy(), request.getIfPrimaryTerm(), request.getIfSeqNo()), (ActionListener<UpdateResponse>)listener.map(updateResponse -> AcknowledgedResponse.TRUE));
    }

    public void suggestProfile(SuggestProfilesRequest request, TaskId parentTaskId, ActionListener<SuggestProfilesResponse> listener) {
        this.tryFreezeAndCheckIndex(listener.map(response -> {
            assert (response == null) : "only null response can reach here";
            return new SuggestProfilesResponse(new SuggestProfilesResponse.ProfileHit[0], 0L, new TotalHits(0L, TotalHits.Relation.EQUAL_TO));
        })).ifPresent(frozenProfileIndex -> {
            SearchRequest searchRequest = this.buildSearchRequestForSuggest(request, parentTaskId);
            frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)this.getActionOrigin(), (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
                SuggestProfilesResponse.ProfileHit[] profileHits;
                SearchHits searchHits = searchResponse.getHits();
                SearchHit[] hits = searchHits.getHits();
                if (hits.length == 0) {
                    profileHits = new SuggestProfilesResponse.ProfileHit[]{};
                } else {
                    profileHits = new SuggestProfilesResponse.ProfileHit[hits.length];
                    for (int i = 0; i < hits.length; ++i) {
                        SearchHit hit = hits[i];
                        VersionedDocument versionedDocument = new VersionedDocument(ProfileService.buildProfileDocument(hit.getSourceRef()), hit.getPrimaryTerm(), hit.getSeqNo());
                        profileHits[i] = new SuggestProfilesResponse.ProfileHit(versionedDocument.toProfile(request.getDataKeys()), hit.getScore());
                    }
                }
                listener.onResponse((Object)new SuggestProfilesResponse(profileHits, searchResponse.getTook().millis(), searchHits.getTotalHits()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        });
    }

    public void setEnabled(String uid, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<AcknowledgedResponse> listener) {
        XContentBuilder builder;
        try {
            builder = XContentFactory.jsonBuilder();
            builder.startObject().field("user_profile", Map.of("enabled", enabled)).endObject();
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        this.doUpdate(this.buildUpdateRequest(uid, builder, refreshPolicy), (ActionListener<UpdateResponse>)listener.map(updateResponse -> AcknowledgedResponse.TRUE));
    }

    public void searchProfilesForSubjects(List<Subject> subjects, ActionListener<SubjectSearchResultsAndErrors<Profile>> listener) {
        this.searchVersionedDocumentsForSubjects(subjects, (ActionListener<SubjectSearchResultsAndErrors<VersionedDocument>>)ActionListener.wrap(resultsAndErrors -> {
            if (resultsAndErrors == null) {
                listener.onResponse(null);
                return;
            }
            listener.onResponse(new SubjectSearchResultsAndErrors(resultsAndErrors.results().stream().map(t -> {
                if (t.v2() != null) {
                    return new Tuple((Object)((Subject)t.v1()), (Object)((VersionedDocument)t.v2()).toProfile(Set.of()));
                }
                return new Tuple((Object)((Subject)t.v1()), (Object)null);
            }).toList(), resultsAndErrors.errors()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        this.tryFreezeAndCheckIndex(listener.map(response -> {
            assert (response == null) : "only null response can reach here";
            return Map.of("total", 0L, "enabled", 0L, "recent", 0L);
        })).ifPresent(frozenProfileIndex -> {
            MultiSearchRequest multiSearchRequest = (MultiSearchRequest)this.client.prepareMultiSearch().add((SearchRequest)this.client.prepareSearch(new String[]{".security-profile"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)"user_profile.uid"))).setSize(0).setTrackTotalHits(true).request()).add((SearchRequest)this.client.prepareSearch(new String[]{".security-profile"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.enabled", (boolean)true))).setSize(0).setTrackTotalHits(true).request()).add((SearchRequest)this.client.prepareSearch(new String[]{".security-profile"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.enabled", (boolean)true)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"user_profile.last_synchronized").gt((Object)Instant.now().minus(30L, ChronoUnit.DAYS).toEpochMilli()))).setSize(0).setTrackTotalHits(true).request()).request();
            frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)this.getActionOrigin(), (ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)ActionListener.wrap(multiSearchResponse -> {
                MultiSearchResponse.Item[] items = multiSearchResponse.getResponses();
                assert (items.length == 3);
                HashMap<String, Long> usage = new HashMap<String, Long>();
                if (items[0].isFailure()) {
                    logger.debug("error on counting total profiles", (Throwable)items[0].getFailure());
                    usage.put("total", 0L);
                } else {
                    usage.put("total", items[0].getResponse().getHits().getTotalHits().value);
                }
                if (items[1].isFailure()) {
                    logger.debug("error on counting enabled profiles", (Throwable)items[0].getFailure());
                    usage.put("enabled", 0L);
                } else {
                    usage.put("enabled", items[1].getResponse().getHits().getTotalHits().value);
                }
                if (items[2].isFailure()) {
                    logger.debug("error on counting recent profiles", (Throwable)items[0].getFailure());
                    usage.put("recent", 0L);
                } else {
                    usage.put("recent", items[2].getResponse().getHits().getTotalHits().value);
                }
                listener.onResponse(usage);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        });
    }

    SearchRequest buildSearchRequestForSuggest(SuggestProfilesRequest request, TaskId parentTaskId) {
        SuggestProfilesRequest.Hint hint;
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.enabled", (boolean)true));
        if (org.elasticsearch.common.Strings.hasText((String)request.getName())) {
            query.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)request.getName(), (String[])new String[]{"user_profile.user.username", "user_profile.user.username._2gram", "user_profile.user.username._3gram", "user_profile.user.full_name", "user_profile.user.full_name._2gram", "user_profile.user.full_name._3gram", "user_profile.user.email"}).type(MultiMatchQueryBuilder.Type.BOOL_PREFIX).fuzziness(Fuzziness.AUTO));
        }
        if ((hint = request.getHint()) != null) {
            Tuple label;
            List hintedUids = hint.getUids();
            if (hintedUids != null) {
                assert (!hintedUids.isEmpty()) : "uids hint cannot be empty";
                query.should((QueryBuilder)QueryBuilders.termsQuery((String)"user_profile.uid", (Collection)hintedUids));
            }
            if ((label = hint.getSingleLabel()) != null) {
                List labelValues = (List)label.v2();
                query.should((QueryBuilder)QueryBuilders.termsQuery((String)("user_profile.labels." + (String)label.v1()), (Collection)labelValues));
            }
            query.minimumShouldMatch(0);
        }
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".security-profile"}).setQuery((QueryBuilder)query).setSize(request.getSize()).addSort("_score", SortOrder.DESC).addSort("user_profile.last_synchronized", SortOrder.DESC).request();
        searchRequest.setParentTask(parentTaskId);
        return searchRequest;
    }

    private void getVersionedDocument(String uid, ActionListener<VersionedDocument> listener) {
        this.tryFreezeAndCheckIndex(listener).ifPresent(frozenProfileIndex -> {
            GetRequest getRequest = new GetRequest(".security-profile", ProfileService.uidToDocId(uid));
            frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)this.getActionOrigin(), (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(response -> {
                if (!response.isExists()) {
                    logger.debug("profile with uid [{}] does not exist", (Object)uid);
                    listener.onResponse(null);
                    return;
                }
                listener.onResponse((Object)new VersionedDocument(ProfileService.buildProfileDocument(response.getSourceAsBytesRef()), response.getPrimaryTerm(), response.getSeqNo()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        });
    }

    private void getVersionedDocuments(Collection<String> uids, ActionListener<ResultsAndErrors<VersionedDocument>> listener) {
        if (uids.isEmpty()) {
            listener.onResponse((Object)ResultsAndErrors.empty());
            return;
        }
        this.tryFreezeAndCheckIndex(listener).ifPresent(frozenProfileIndex -> frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> new OriginSettingClient(this.client, this.getActionOrigin()).prepareMultiGet().addIds(frozenProfileIndex.aliasName(), (String[])uids.stream().map(ProfileService::uidToDocId).toArray(String[]::new)).execute(ActionListener.wrap(multiGetResponse -> {
            ArrayList<VersionedDocument> retrievedDocs = new ArrayList<VersionedDocument>(multiGetResponse.getResponses().length);
            TreeMap<String, Exception> errors = new TreeMap<String, Exception>();
            for (MultiGetItemResponse itemResponse : multiGetResponse.getResponses()) {
                String profileUid = ProfileService.docIdToUid(itemResponse.getId());
                if (itemResponse.isFailed()) {
                    logger.debug("Failed to retrieve profile [{}]", (Object)profileUid);
                    errors.put(profileUid, itemResponse.getFailure().getFailure());
                    continue;
                }
                if (itemResponse.getResponse() != null) {
                    if (itemResponse.getResponse().isExists()) {
                        retrievedDocs.add(new VersionedDocument(ProfileService.buildProfileDocument(itemResponse.getResponse().getSourceAsBytesRef()), itemResponse.getResponse().getPrimaryTerm(), itemResponse.getResponse().getSeqNo()));
                        continue;
                    }
                    logger.debug("Profile [{}] not found", (Object)profileUid);
                    errors.put(profileUid, (Exception)new ResourceNotFoundException("profile document not found", new Object[0]));
                    continue;
                }
                assert (false) : "Inconsistent mget item response [" + itemResponse.getIndex() + "] [" + itemResponse.getId() + "]";
                logger.error("Inconsistent mget item response [{}] [{}]", (Object)itemResponse.getIndex(), (Object)itemResponse.getId());
            }
            listener.onResponse((Object)new ResultsAndErrors(retrievedDocs, errors));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)))));
    }

    void searchVersionedDocumentForSubject(Subject subject, ActionListener<VersionedDocument> listener) {
        this.searchVersionedDocumentsForSubjects(List.of(subject), (ActionListener<SubjectSearchResultsAndErrors<VersionedDocument>>)ActionListener.wrap(resultsAndErrors -> {
            if (resultsAndErrors == null) {
                listener.onResponse(null);
                return;
            }
            assert (resultsAndErrors.results().size() + resultsAndErrors.errors().size() == 1) : "a single subject must have either a single result or error";
            if (resultsAndErrors.results().size() == 1) {
                listener.onResponse((Object)((VersionedDocument)resultsAndErrors.results().iterator().next().v2()));
            } else if (resultsAndErrors.errors().size() == 1) {
                Exception exception = resultsAndErrors.errors().values().iterator().next();
                logger.error(exception.getMessage());
                listener.onFailure(exception);
            } else {
                assert (false) : "a single subject must have either a single result or error";
                listener.onFailure((Exception)new ElasticsearchException("a single subject must have either a single result or error", new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void searchVersionedDocumentsForSubjects(List<Subject> subjects, ActionListener<SubjectSearchResultsAndErrors<VersionedDocument>> listener) {
        if (subjects.isEmpty()) {
            listener.onResponse(new SubjectSearchResultsAndErrors(List.of(), Map.of()));
            return;
        }
        this.tryFreezeAndCheckIndex(listener).ifPresent(frozenProfileIndex -> frozenProfileIndex.checkIndexVersionThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> {
            MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
            subjects.forEach(subject -> multiSearchRequest.add(this.buildSearchRequestForSubject((Subject)subject)));
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)this.getActionOrigin(), (ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)ActionListener.wrap(multiSearchResponse -> listener.onResponse(ProfileService.convertSubjectMultiSearchResponse(multiSearchResponse, subjects)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }));
    }

    private static SubjectSearchResultsAndErrors<VersionedDocument> convertSubjectMultiSearchResponse(MultiSearchResponse multiSearchResponse, List<Subject> subjects) throws IOException {
        MultiSearchResponse.Item[] items = multiSearchResponse.getResponses();
        assert (items.length == subjects.size()) : "size of responses does not match size of subjects";
        ArrayList versionedDocs = new ArrayList(items.length);
        HashMap<Subject, Exception> errors = new HashMap<Subject, Exception>();
        for (int i = 0; i < items.length; ++i) {
            MultiSearchResponse.Item item = items[i];
            Subject subject = subjects.get(i);
            if (item.isFailure()) {
                errors.put(subject, item.getFailure());
                continue;
            }
            SearchHits searchHits = item.getResponse().getHits();
            SearchHit[] hits = searchHits.getHits();
            if (hits.length < 1) {
                logger.debug("profile does not exist for username [{}] and realm name [{}]", (Object)subject.getUser().principal(), (Object)subject.getRealm().getName());
                versionedDocs.add(new Tuple((Object)subject, null));
                continue;
            }
            if (hits.length == 1) {
                SearchHit hit = hits[0];
                ProfileDocument profileDocument = ProfileService.buildProfileDocument(hit.getSourceRef());
                if (subject.canAccessResourcesOf(profileDocument.user().toSubject())) {
                    versionedDocs.add(new Tuple((Object)subject, (Object)new VersionedDocument(profileDocument, hit.getPrimaryTerm(), hit.getSeqNo())));
                    continue;
                }
                assert (false) : "this should not happen";
                errors.put(subject, (Exception)new ElasticsearchException(Strings.format((String)"profile [%s] matches search criteria but is not accessible to the current subject with username [%s] and realm name [%s]", (Object[])new Object[]{profileDocument.uid(), subject.getUser().principal(), subject.getRealm().getName()}), new Object[0]));
                continue;
            }
            errors.put(subject, (Exception)new ElasticsearchException(Strings.format((String)"multiple [%s] profiles [%s] found for user [%s] from realm [%s]%s", (Object[])new Object[]{hits.length, Arrays.stream(hits).map(SearchHit::getId).map(ProfileService::docIdToUid).sorted().collect(Collectors.joining(",")), subject.getUser().principal(), subject.getRealm().getName(), subject.getRealm().getDomain() == null ? "" : " under domain [" + subject.getRealm().getDomain().name() + "]"}), new Object[0]));
        }
        return new SubjectSearchResultsAndErrors<VersionedDocument>(versionedDocs, errors);
    }

    private SearchRequest buildSearchRequestForSubject(Subject subject) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.username.keyword", (String)subject.getUser().principal()));
        if (subject.getRealm().getDomain() == null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.realm.type", (String)subject.getRealm().getType()));
            if (!Authentication.isFileOrNativeRealm((String)subject.getRealm().getType())) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.realm.name", (String)subject.getRealm().getName()));
            }
        } else {
            logger.debug(() -> Strings.format((String)"searching existing profile document for user [%s] from any of the realms [%s] under domain [%s]", (Object[])new Object[]{subject.getUser().principal(), org.elasticsearch.common.Strings.collectionToCommaDelimitedString((Iterable)subject.getRealm().getDomain().realms()), subject.getRealm().getDomain().name()}));
            subject.getRealm().getDomain().realms().forEach(realmIdentifier -> {
                BoolQueryBuilder perRealmQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.realm.type", (String)realmIdentifier.getType()));
                if (!Authentication.isFileOrNativeRealm((String)realmIdentifier.getType())) {
                    perRealmQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"user_profile.user.realm.name", (String)realmIdentifier.getName()));
                }
                boolQuery.should((QueryBuilder)perRealmQuery);
            });
            boolQuery.minimumShouldMatch(1);
        }
        return (SearchRequest)this.client.prepareSearch(new String[]{".security-profile"}).setQuery((QueryBuilder)boolQuery).seqNoAndPrimaryTerm(true).request();
    }

    private void validateUsername(Subject subject) {
        RealmDomain realmDomain = subject.getRealm().getDomain();
        assert (realmDomain != null);
        assert (this.domainConfigLookup.apply(realmDomain.name()) != null);
        assert (this.domainConfigLookup.apply(realmDomain.name()).literalUsername());
        String username = subject.getUser().principal();
        assert (username != null);
        if (!VALID_LITERAL_USERNAME.matcher(username).matches()) {
            throw new ElasticsearchException(String.format(Locale.ROOT, INVALID_USERNAME_MESSAGE, realmDomain.name()), new Object[0]);
        }
    }

    void createNewProfile(Subject subject, String uid, ActionListener<Profile> listener) throws IOException {
        ProfileDocument profileDocument = ProfileDocument.fromSubjectWithUid(subject, uid);
        String docId = ProfileService.uidToDocId(profileDocument.uid());
        BulkRequest bulkRequest = TransportSingleItemBulkWriteAction.toSingleItemBulkRequest((ReplicatedWriteRequest)((ReplicatedWriteRequest)((IndexRequestBuilder)this.client.prepareIndex(".security-profile").setId(docId).setSource(ProfileService.wrapProfileDocument(profileDocument)).setOpType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request()));
        this.profileIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)this.getActionOrigin(), (ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, (ActionListener)TransportBulkAction.unwrappingSingleItemBulkResponse((ActionListener)ActionListener.wrap(indexResponse -> {
            assert (docId.equals(indexResponse.getId()));
            VersionedDocument versionedDocument = new VersionedDocument(profileDocument, indexResponse.getPrimaryTerm(), indexResponse.getSeqNo());
            listener.onResponse((Object)versionedDocument.toProfile(Set.of()));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                this.getOrCreateProfileWithBackoff(subject, profileDocument, DEFAULT_BACKOFF.iterator(), listener);
            } else {
                listener.onFailure(e);
            }
        }))));
    }

    void getOrCreateProfileWithBackoff(Subject subject, ProfileDocument profileDocument, Iterator<TimeValue> backoff, ActionListener<Profile> listener) {
        this.getVersionedDocument(profileDocument.uid(), (ActionListener<VersionedDocument>)ActionListener.wrap(versionedDocument -> {
            if (versionedDocument == null) {
                if (backoff.hasNext()) {
                    TimeValue backoffTimeValue = (TimeValue)backoff.next();
                    logger.debug("retrying get profile document [{}] after [{}] backoff", (Object)profileDocument.uid(), (Object)backoffTimeValue);
                    this.client.threadPool().schedule(() -> this.getOrCreateProfileWithBackoff(subject, profileDocument, backoff, listener), backoffTimeValue, "generic");
                } else {
                    listener.onFailure((Exception)new ElasticsearchException("failed to retrieving profile [{}] after all retries", new Object[]{profileDocument.uid()}));
                }
                return;
            }
            if (subject.canAccessResourcesOf(versionedDocument.doc.user().toSubject())) {
                logger.debug("found existing profile document [{}] accessible to the current subject with username [{}] and realm name [{}]", (Object)versionedDocument.doc.uid(), (Object)subject.getUser().principal(), (Object)subject.getRealm().getName());
                this.updateProfileForActivate(subject, (VersionedDocument)versionedDocument, listener);
            } else {
                this.maybeIncrementDifferentiatorAndCreateNewProfile(subject, profileDocument, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    void maybeIncrementDifferentiatorAndCreateNewProfile(Subject subject, ProfileDocument profileDocument, ActionListener<Profile> listener) throws IOException {
        int differentiator;
        String uid = profileDocument.uid();
        int index = uid.lastIndexOf("_");
        if (index == -1) {
            listener.onFailure((Exception)new ElasticsearchException("profile uid [{}] does not contain any underscore character", new Object[]{uid}));
            return;
        }
        String baseUid = uid.substring(0, index);
        String differentiatorString = uid.substring(index + 1);
        if (differentiatorString.isBlank()) {
            listener.onFailure((Exception)new ElasticsearchException("profile uid [{}] does not contain a differentiator", new Object[]{uid}));
            return;
        }
        DomainConfig domainConfig = this.getDomainConfigForSubject(subject);
        if (domainConfig != null && domainConfig.suffix() != null) {
            assert (differentiatorString.equals(domainConfig.suffix()));
            listener.onFailure((Exception)new ElasticsearchException("cannot create new profile for [" + subject.getUser().principal() + "]. A profile with uid [" + profileDocument.uid() + "] already exists and suffix setting of domain [" + domainConfig.name() + "] does not support auto-increment.", new Object[0]));
            return;
        }
        try {
            differentiator = Integer.parseInt(differentiatorString);
        }
        catch (NumberFormatException e) {
            listener.onFailure((Exception)new ElasticsearchException("profile uid [{}] differentiator is not a number", (Throwable)e, new Object[]{uid}));
            return;
        }
        if (differentiator >= 9) {
            listener.onFailure((Exception)new ElasticsearchException("profile differentiator value is too high for base Uid [{}]", new Object[]{uid.substring(0, index)}));
            return;
        }
        String newUid = baseUid + "_" + (differentiator + 1);
        this.createNewProfile(subject, newUid, listener);
    }

    private DomainConfig getDomainConfigForSubject(Subject subject) {
        RealmDomain realmDomain = subject.getRealm().getDomain();
        if (realmDomain != null) {
            DomainConfig domainConfig = this.domainConfigLookup.apply(realmDomain.name());
            if (domainConfig == null) {
                throw new ElasticsearchException("subject realm is under a domain [" + realmDomain.name() + "], but no associated domain config is found", new Object[0]);
            }
            return domainConfig;
        }
        return null;
    }

    void updateProfileForActivate(Subject subject, VersionedDocument currentVersionedDocumentBySearch, ActionListener<Profile> listener) throws IOException {
        ProfileDocument newProfileDocument = ProfileService.updateWithSubject(currentVersionedDocumentBySearch.doc, subject);
        if (this.shouldSkipUpdateForActivate(currentVersionedDocumentBySearch.doc, newProfileDocument)) {
            logger.debug("skip user profile activate update because last_synchronized [{}] is within grace period", (Object)currentVersionedDocumentBySearch.doc.lastSynchronized());
            listener.onResponse((Object)currentVersionedDocumentBySearch.toProfile(Set.of()));
            return;
        }
        this.doUpdate(this.buildUpdateRequest(newProfileDocument.uid(), ProfileService.wrapProfileDocumentWithoutApplicationData(newProfileDocument), WriteRequest.RefreshPolicy.WAIT_UNTIL), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> listener.onResponse((Object)new VersionedDocument(newProfileDocument, updateResponse.getPrimaryTerm(), updateResponse.getSeqNo()).toProfile(Set.of())), updateException -> {
            if (ExceptionsHelper.unwrapCause((Throwable)updateException) instanceof VersionConflictEngineException) {
                this.getVersionedDocument(currentVersionedDocumentBySearch.doc.uid(), (ActionListener<VersionedDocument>)ActionListener.wrap(versionedDocumentByGet -> {
                    if (this.shouldSkipUpdateForActivate(versionedDocumentByGet.doc, newProfileDocument)) {
                        logger.debug("suppress version conflict for activate update because last_synchronized [{}] is within grace period", (Object)versionedDocumentByGet.doc.lastSynchronized());
                        listener.onResponse((Object)versionedDocumentByGet.toProfile(Set.of()));
                    } else {
                        listener.onFailure(updateException);
                    }
                }, getException -> {
                    getException.addSuppressed((Throwable)updateException);
                    listener.onFailure(getException);
                }));
            } else {
                listener.onFailure(updateException);
            }
        }));
    }

    boolean shouldSkipUpdateForActivate(ProfileDocument currentProfileDocument, ProfileDocument newProfileDocument) {
        assert (newProfileDocument.enabled()) : "new profile document must be enabled";
        return newProfileDocument.user().equals(currentProfileDocument.user()) && newProfileDocument.enabled() == currentProfileDocument.enabled() && newProfileDocument.lastSynchronized() - currentProfileDocument.lastSynchronized() < ACTIVATE_INTERVAL_IN_MS;
    }

    private UpdateRequest buildUpdateRequest(String uid, XContentBuilder builder, WriteRequest.RefreshPolicy refreshPolicy) {
        return this.buildUpdateRequest(uid, builder, refreshPolicy, -1L, -1L);
    }

    private UpdateRequest buildUpdateRequest(String uid, XContentBuilder builder, WriteRequest.RefreshPolicy refreshPolicy, long ifPrimaryTerm, long ifSeqNo) {
        String docId = ProfileService.uidToDocId(uid);
        UpdateRequestBuilder updateRequestBuilder = (UpdateRequestBuilder)this.client.prepareUpdate(".security-profile", docId).setDoc(builder).setRefreshPolicy(refreshPolicy);
        if (ifPrimaryTerm >= 0L) {
            updateRequestBuilder.setIfPrimaryTerm(ifPrimaryTerm);
        }
        if (ifSeqNo >= 0L) {
            updateRequestBuilder.setIfSeqNo(ifSeqNo);
        }
        return (UpdateRequest)updateRequestBuilder.request();
    }

    void doUpdate(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        this.profileIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)this.getActionOrigin(), (ActionType)UpdateAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> {
            assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED || updateResponse.getResult() == DocWriteResponse.Result.NOOP);
            listener.onResponse(updateResponse);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
    }

    private String getActionOrigin() {
        if (this.clusterService.state().nodes().getMinNodeVersion().onOrAfter((VersionId)SecuritySystemIndices.VERSION_SECURITY_PROFILE_ORIGIN)) {
            return "security_profile";
        }
        return "security";
    }

    private static String uidToDocId(String uid) {
        return DOC_ID_PREFIX + uid;
    }

    private static String docIdToUid(String docId) {
        if (docId == null || !docId.startsWith(DOC_ID_PREFIX)) {
            throw new IllegalStateException("profile document ID [" + docId + "] has unexpected value");
        }
        return docId.substring(DOC_ID_PREFIX.length());
    }

    static ProfileDocument buildProfileDocument(BytesReference source) throws IOException {
        if (source == null) {
            throw new IllegalStateException("profile document did not have source but source should have been fetched");
        }
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)XContentType.JSON);){
            ProfileDocument profileDocument = ProfileDocument.fromXContent(parser);
            return profileDocument;
        }
    }

    private static XContentBuilder wrapProfileDocument(ProfileDocument profileDocument) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("user_profile", (ToXContent)profileDocument);
        builder.endObject();
        return builder;
    }

    private static XContentBuilder wrapProfileDocumentWithoutApplicationData(ProfileDocument profileDocument) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field("user_profile", (ToXContent)profileDocument, (ToXContent.Params)new ToXContent.MapParams(Map.of("include_labels", Boolean.FALSE.toString(), "include_data", Boolean.FALSE.toString())));
        builder.endObject();
        return builder;
    }

    private <T> Optional<SecurityIndexManager> tryFreezeAndCheckIndex(ActionListener<T> listener) {
        SecurityIndexManager frozenProfileIndex = this.profileIndex.freeze();
        if (!frozenProfileIndex.indexExists()) {
            logger.debug("profile index does not exist");
            listener.onResponse(null);
            return Optional.empty();
        }
        if (!frozenProfileIndex.isAvailable()) {
            listener.onFailure((Exception)frozenProfileIndex.getUnavailableReason());
            return Optional.empty();
        }
        return Optional.of(frozenProfileIndex);
    }

    private static ProfileDocument updateWithSubject(ProfileDocument doc, Subject subject) {
        User subjectUser = subject.getUser();
        return new ProfileDocument(doc.uid(), true, Instant.now().toEpochMilli(), new ProfileDocument.ProfileDocumentUser(subjectUser.principal(), Arrays.asList(subjectUser.roles()), subject.getRealm(), subjectUser.email(), subjectUser.fullName()), doc.labels(), doc.applicationData());
    }

    public record SubjectSearchResultsAndErrors<T>(List<Tuple<Subject, T>> results, Map<Subject, Exception> errors) {
    }

    record VersionedDocument(ProfileDocument doc, long primaryTerm, long seqNo) {
        Profile toProfile(Set<String> dataKeys) {
            assert (dataKeys != null) : "data keys must not be null";
            Map applicationData = dataKeys.isEmpty() ? Map.of() : (Map)XContentHelper.convertToMap((BytesReference)this.doc.applicationData(), (boolean)false, (XContentType)XContentType.JSON, dataKeys, null).v2();
            return new Profile(this.doc.uid(), this.doc.enabled(), this.doc.lastSynchronized(), this.doc.user().toProfileUser(), this.doc.labels(), applicationData, new Profile.VersionControl(this.primaryTerm, this.seqNo));
        }
    }
}

