/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetBitsetCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleKey;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceIntersection;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceResolver;
import org.elasticsearch.xpack.core.security.authz.store.RolesRetrievalResult;
import org.elasticsearch.xpack.core.security.support.CacheIteratorHelper;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.InternalUsers;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authz.restriction.WorkflowService;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;
import org.elasticsearch.xpack.security.authz.store.RoleDescriptorStore;
import org.elasticsearch.xpack.security.authz.store.RoleProviders;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class CompositeRolesStore {
    static final Setting<Integer> NEGATIVE_LOOKUP_CACHE_SIZE_SETTING = Setting.intSetting((String)"xpack.security.authz.store.roles.negative_lookup_cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)"xpack.security.authz.store.roles.cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(CompositeRolesStore.class);
    private final RoleProviders roleProviders;
    private final NativePrivilegeStore privilegeStore;
    private final FieldPermissionsCache fieldPermissionsCache;
    private final Cache<RoleKey, Role> roleCache;
    private final CacheIteratorHelper<RoleKey, Role> roleCacheHelper;
    private final Cache<String, Boolean> negativeLookupCache;
    private final DocumentSubsetBitsetCache dlsBitsetCache;
    private final AnonymousUser anonymousUser;
    private final AtomicLong numInvalidation = new AtomicLong();
    private final RoleDescriptorStore roleReferenceResolver;
    private final Role superuserRole;
    private final Map<String, Role> internalUserRoles;
    private final RestrictedIndices restrictedIndices;
    private final WorkflowService workflowService;
    private final ThreadContext threadContext;

    public CompositeRolesStore(Settings settings, RoleProviders roleProviders, NativePrivilegeStore privilegeStore, ThreadContext threadContext, XPackLicenseState licenseState, FieldPermissionsCache fieldPermissionsCache, ApiKeyService apiKeyService, ServiceAccountService serviceAccountService, DocumentSubsetBitsetCache dlsBitsetCache, RestrictedIndices restrictedIndices, Consumer<Collection<RoleDescriptor>> effectiveRoleDescriptorsConsumer, WorkflowService workflowService) {
        this.roleProviders = roleProviders;
        roleProviders.addChangeListener(new RoleProviders.ChangeListener(){

            @Override
            public void rolesChanged(Set<String> roles) {
                CompositeRolesStore.this.invalidate(roles);
            }

            @Override
            public void providersChanged() {
                CompositeRolesStore.this.invalidateAll();
            }
        });
        this.privilegeStore = Objects.requireNonNull(privilegeStore);
        this.dlsBitsetCache = Objects.requireNonNull(dlsBitsetCache);
        this.fieldPermissionsCache = Objects.requireNonNull(fieldPermissionsCache);
        CacheBuilder builder = CacheBuilder.builder();
        int cacheSize = (Integer)CACHE_SIZE_SETTING.get(settings);
        if (cacheSize >= 0) {
            builder.setMaximumWeight((long)cacheSize);
        }
        this.roleCache = builder.build();
        this.roleCacheHelper = new CacheIteratorHelper(this.roleCache);
        CacheBuilder nlcBuilder = CacheBuilder.builder();
        int nlcCacheSize = (Integer)NEGATIVE_LOOKUP_CACHE_SIZE_SETTING.get(settings);
        if (nlcCacheSize >= 0) {
            nlcBuilder.setMaximumWeight((long)nlcCacheSize);
        }
        this.negativeLookupCache = nlcBuilder.build();
        this.restrictedIndices = restrictedIndices;
        this.superuserRole = Role.buildFromRoleDescriptor((RoleDescriptor)ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR, (FieldPermissionsCache)fieldPermissionsCache, (RestrictedIndices)this.restrictedIndices);
        this.internalUserRoles = InternalUsers.get().stream().filter(u -> u.getLocalClusterRoleDescriptor().isPresent()).collect(Collectors.toMap(u -> u.principal(), u -> Role.buildFromRoleDescriptor((RoleDescriptor)((RoleDescriptor)u.getLocalClusterRoleDescriptor().get()), (FieldPermissionsCache)fieldPermissionsCache, (RestrictedIndices)this.restrictedIndices)));
        this.roleReferenceResolver = new RoleDescriptorStore(roleProviders, apiKeyService, serviceAccountService, this.negativeLookupCache, licenseState, threadContext, effectiveRoleDescriptorsConsumer);
        this.anonymousUser = new AnonymousUser(settings);
        this.workflowService = workflowService;
        this.threadContext = threadContext;
    }

    public void getRoles(Authentication authentication, ActionListener<Tuple<Role, Role>> roleActionListener) {
        this.getRole(authentication.getEffectiveSubject(), (ActionListener<Role>)roleActionListener.delegateFailureAndWrap((delegate, role) -> {
            if (authentication.isRunAs()) {
                this.getRole(authentication.getAuthenticatingSubject(), (ActionListener<Role>)delegate.delegateFailureAndWrap((l, authenticatingRole) -> l.onResponse((Object)new Tuple(role, authenticatingRole))));
            } else {
                delegate.onResponse((Object)new Tuple(role, role));
            }
        }));
    }

    public void getRole(Subject subject, ActionListener<Role> roleActionListener) {
        Role internalUserRole = this.tryGetRoleForInternalUser(subject);
        if (internalUserRole != null) {
            roleActionListener.onResponse((Object)internalUserRole);
            return;
        }
        assert (!(subject.getUser() instanceof InternalUser)) : "Internal user [" + subject.getUser() + "] should not pass here";
        RoleReferenceIntersection roleReferenceIntersection = subject.getRoleReferenceIntersection(this.anonymousUser);
        String workflow = this.workflowService.readWorkflowFromThreadContext(this.threadContext);
        roleReferenceIntersection.buildRole(this::buildRoleFromRoleReference, roleActionListener.delegateFailureAndWrap((l, role) -> l.onResponse((Object)role.forWorkflow(workflow))));
    }

    Role tryGetRoleForInternalUser(Subject subject) {
        User user = subject.getUser();
        if (user instanceof InternalUser) {
            InternalUser internal = (InternalUser)user;
            return this.getInternalUserRole(internal);
        }
        return null;
    }

    protected Role getInternalUserRole(InternalUser user) {
        String name = user.principal();
        Role role = this.internalUserRoles.get(name);
        if (role == null) {
            throw new IllegalArgumentException("the internal user [" + name + "] should never have its roles resolved");
        }
        return role;
    }

    public void buildRoleFromRoleReference(RoleReference roleReference, ActionListener<Role> roleActionListener) {
        RoleKey roleKey = roleReference.id();
        if (roleKey == RoleKey.ROLE_KEY_SUPERUSER) {
            roleActionListener.onResponse((Object)this.superuserRole);
            return;
        }
        if (roleKey == RoleKey.ROLE_KEY_EMPTY) {
            roleActionListener.onResponse((Object)Role.EMPTY);
            return;
        }
        Role existing = (Role)this.roleCache.get((Object)roleKey);
        if (existing == null) {
            long invalidationCounter = this.numInvalidation.get();
            Consumer<Exception> failureHandler = e -> {
                if (CompositeRolesStore.includesSuperuserRole(roleReference)) {
                    logger.warn(() -> Strings.format((String)"there was a failure resolving the roles [%s], falling back to the [%s] role instead", (Object[])new Object[]{roleReference.id(), org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])this.superuserRole.names())}), (Throwable)e);
                    roleActionListener.onResponse((Object)this.superuserRole);
                } else {
                    roleActionListener.onFailure(e);
                }
            };
            roleReference.resolve((RoleReferenceResolver)this.roleReferenceResolver, ActionListener.wrap(rolesRetrievalResult -> {
                if (RolesRetrievalResult.EMPTY == rolesRetrievalResult) {
                    roleActionListener.onResponse((Object)Role.EMPTY);
                } else if (RolesRetrievalResult.SUPERUSER == rolesRetrievalResult) {
                    roleActionListener.onResponse((Object)this.superuserRole);
                } else {
                    this.buildThenMaybeCacheRole(roleKey, rolesRetrievalResult.getRoleDescriptors(), rolesRetrievalResult.getMissingRoles(), rolesRetrievalResult.isSuccess(), invalidationCounter, (ActionListener<Role>)ActionListener.wrap(arg_0 -> ((ActionListener)roleActionListener).onResponse(arg_0), (Consumer)failureHandler));
                }
            }, failureHandler));
        } else {
            roleActionListener.onResponse((Object)existing);
        }
    }

    private static boolean includesSuperuserRole(RoleReference roleReference) {
        if (roleReference instanceof RoleReference.NamedRoleReference) {
            RoleReference.NamedRoleReference namedRoles = (RoleReference.NamedRoleReference)roleReference;
            return Arrays.asList(namedRoles.getRoleNames()).contains(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName());
        }
        return false;
    }

    RoleDescriptorStore getRoleReferenceResolver() {
        return this.roleReferenceResolver;
    }

    private void buildThenMaybeCacheRole(RoleKey roleKey, Collection<RoleDescriptor> roleDescriptors, Set<String> missing, boolean tryCache, long invalidationCounter, ActionListener<Role> listener) {
        logger.trace("Building role from descriptors [{}] for names [{}] from source [{}]", roleDescriptors, (Object)roleKey.getNames(), (Object)roleKey.getSource());
        CompositeRolesStore.buildRoleFromDescriptors(roleDescriptors, this.fieldPermissionsCache, this.privilegeStore, this.restrictedIndices, (ActionListener<Role>)listener.delegateFailureAndWrap((delegate, role) -> {
            if (role != null && tryCache) {
                try (ReleasableLock ignored = this.roleCacheHelper.acquireUpdateLock();){
                    if (invalidationCounter == this.numInvalidation.get()) {
                        this.roleCache.computeIfAbsent((Object)roleKey, s -> role);
                    }
                }
                for (String missingRole : missing) {
                    this.negativeLookupCache.computeIfAbsent((Object)missingRole, s -> Boolean.TRUE);
                }
            }
            delegate.onResponse(role);
        }));
    }

    public void getRoleDescriptorsList(Subject subject, ActionListener<Collection<Set<RoleDescriptor>>> listener) {
        CompositeRolesStore.tryGetRoleDescriptorForInternalUser(subject).ifPresentOrElse(roleDescriptor -> listener.onResponse(List.of(Set.of(roleDescriptor))), () -> {
            List roleReferences = subject.getRoleReferenceIntersection(this.anonymousUser).getRoleReferences();
            GroupedActionListener groupedActionListener = new GroupedActionListener(roleReferences.size(), listener);
            roleReferences.forEach(roleReference -> roleReference.resolve((RoleReferenceResolver)this.roleReferenceResolver, groupedActionListener.delegateFailureAndWrap((delegate, rolesRetrievalResult) -> {
                if (rolesRetrievalResult.isSuccess()) {
                    delegate.onResponse((Object)rolesRetrievalResult.getRoleDescriptors());
                } else {
                    delegate.onFailure((Exception)((Object)new ElasticsearchException("role retrieval had one or more failures", new Object[0])));
                }
            })));
        });
    }

    static Optional<RoleDescriptor> tryGetRoleDescriptorForInternalUser(Subject subject) {
        User user = subject.getUser();
        if (user instanceof InternalUser) {
            InternalUser internalUser = (InternalUser)user;
            Optional roleDescriptor = internalUser.getLocalClusterRoleDescriptor();
            if (roleDescriptor.isEmpty()) {
                throw new IllegalArgumentException("should never try to get the roles for internal user [" + internalUser.principal() + "]");
            }
            return roleDescriptor;
        }
        return Optional.empty();
    }

    private static IllegalArgumentException validateRoleDescriptorRestrictions(Collection<RoleDescriptor> roleDescriptors) {
        if (roleDescriptors.size() <= 1) {
            return null;
        }
        long numberOfRoleDescriptorsWithRestriction = roleDescriptors.stream().filter(RoleDescriptor::hasRestriction).count();
        if (numberOfRoleDescriptorsWithRestriction > 0L) {
            if (numberOfRoleDescriptorsWithRestriction != 1L) {
                return new IllegalArgumentException("more than one role descriptor with restriction is not allowed: " + roleDescriptors.stream().map(RoleDescriptor::getName).toList());
            }
            if (numberOfRoleDescriptorsWithRestriction != (long)roleDescriptors.size()) {
                return new IllegalArgumentException("combining role descriptors with and without restriction is not allowed: " + roleDescriptors.stream().map(RoleDescriptor::getName).toList());
            }
        }
        return null;
    }

    public static void buildRoleFromDescriptors(Collection<RoleDescriptor> roleDescriptors, FieldPermissionsCache fieldPermissionsCache, NativePrivilegeStore privilegeStore, RestrictedIndices restrictedIndices, ActionListener<Role> listener) {
        if (roleDescriptors.isEmpty()) {
            listener.onResponse((Object)Role.EMPTY);
            return;
        }
        IllegalArgumentException validationException = CompositeRolesStore.validateRoleDescriptorRestrictions(roleDescriptors);
        if (validationException != null) {
            listener.onFailure((Exception)validationException);
            return;
        }
        HashSet<String> clusterPrivileges = new HashSet<String>();
        ArrayList<ConfigurableClusterPrivilege> configurableClusterPrivileges = new ArrayList<ConfigurableClusterPrivilege>();
        HashSet<String> runAs = new HashSet<String>();
        HashMap<Set<String>, MergeableIndicesPrivilege> indicesPrivilegesMap = new HashMap<Set<String>, MergeableIndicesPrivilege>();
        HashMap<Set<String>, MergeableIndicesPrivilege> restrictedIndicesPrivilegesMap = new HashMap<Set<String>, MergeableIndicesPrivilege>();
        HashMap<Set<String>, Set<RoleDescriptor.IndicesPrivileges>> remoteIndicesPrivilegesByCluster = new HashMap<Set<String>, Set<RoleDescriptor.IndicesPrivileges>>();
        HashMap<Tuple, Set> applicationPrivilegesMap = new HashMap<Tuple, Set>();
        HashSet<String> workflows = new HashSet<String>();
        ArrayList<String> roleNames = new ArrayList<String>(roleDescriptors.size());
        for (RoleDescriptor descriptor : roleDescriptors) {
            roleNames.add(descriptor.getName());
            if (descriptor.getClusterPrivileges() != null) {
                clusterPrivileges.addAll(Arrays.asList(descriptor.getClusterPrivileges()));
            }
            if (descriptor.getConditionalClusterPrivileges() != null) {
                configurableClusterPrivileges.addAll(Arrays.asList(descriptor.getConditionalClusterPrivileges()));
            }
            if (descriptor.getRunAs() != null) {
                runAs.addAll(Arrays.asList(descriptor.getRunAs()));
            }
            MergeableIndicesPrivilege.collatePrivilegesByIndices(descriptor.getIndicesPrivileges(), true, restrictedIndicesPrivilegesMap);
            MergeableIndicesPrivilege.collatePrivilegesByIndices(descriptor.getIndicesPrivileges(), false, indicesPrivilegesMap);
            if (descriptor.hasRemoteIndicesPrivileges()) {
                CompositeRolesStore.groupIndexPrivilegesByCluster(descriptor.getRemoteIndicesPrivileges(), remoteIndicesPrivilegesByCluster);
            }
            for (RoleDescriptor.ApplicationResourcePrivileges appPrivilege : descriptor.getApplicationPrivileges()) {
                Tuple key2 = new Tuple((Object)appPrivilege.getApplication(), (Object)Sets.newHashSet((Object[])appPrivilege.getResources()));
                applicationPrivilegesMap.compute(key2, (k, v) -> {
                    if (v == null) {
                        return Sets.newHashSet((Object[])appPrivilege.getPrivileges());
                    }
                    v.addAll(Arrays.asList(appPrivilege.getPrivileges()));
                    return v;
                });
            }
            if (!descriptor.hasWorkflowsRestriction()) continue;
            workflows.addAll(List.of(descriptor.getRestriction().getWorkflows()));
        }
        Privilege runAsPrivilege = runAs.isEmpty() ? Privilege.NONE : new Privilege(runAs, runAs.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY));
        Role.Builder builder = Role.builder((RestrictedIndices)restrictedIndices, (String[])roleNames.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY)).cluster(clusterPrivileges, configurableClusterPrivileges).runAs(runAsPrivilege);
        indicesPrivilegesMap.forEach((key, privilege) -> builder.add(fieldPermissionsCache.getFieldPermissions(privilege.fieldPermissionsDefinition), privilege.query, IndexPrivilege.get(privilege.privileges), false, privilege.indices.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY)));
        restrictedIndicesPrivilegesMap.forEach((key, privilege) -> builder.add(fieldPermissionsCache.getFieldPermissions(privilege.fieldPermissionsDefinition), privilege.query, IndexPrivilege.get(privilege.privileges), true, privilege.indices.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY)));
        remoteIndicesPrivilegesByCluster.forEach((clusterAliasKey, remoteIndicesPrivilegesForCluster) -> remoteIndicesPrivilegesForCluster.forEach(privilege -> builder.addRemoteGroup(clusterAliasKey, fieldPermissionsCache.getFieldPermissions(new FieldPermissionsDefinition(privilege.getGrantedFields(), privilege.getDeniedFields())), (Set)(privilege.getQuery() == null ? null : Sets.newHashSet((Object[])new BytesReference[]{privilege.getQuery()})), IndexPrivilege.get((Set)Sets.newHashSet((Object[])Objects.requireNonNull(privilege.getPrivileges()))), privilege.allowRestrictedIndices(), Sets.newHashSet((Object[])Objects.requireNonNull(privilege.getIndices())).toArray(new String[0]))));
        if (!workflows.isEmpty()) {
            builder.workflows(workflows);
        }
        if (applicationPrivilegesMap.isEmpty()) {
            listener.onResponse((Object)builder.build());
        } else {
            Set<String> applicationNames = applicationPrivilegesMap.keySet().stream().map(Tuple::v1).collect(Collectors.toSet());
            Set<String> applicationPrivilegeNames = applicationPrivilegesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            privilegeStore.getPrivileges(applicationNames, applicationPrivilegeNames, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)listener.delegateFailureAndWrap((delegate, appPrivileges) -> {
                applicationPrivilegesMap.forEach((key, names) -> ApplicationPrivilege.get((String)((String)key.v1()), (Set)names, (Collection)appPrivileges).forEach(priv -> builder.addApplicationPrivilege(priv, (Set)key.v2())));
                delegate.onResponse((Object)builder.build());
            }));
        }
    }

    public void invalidateAll() {
        this.numInvalidation.incrementAndGet();
        this.negativeLookupCache.invalidateAll();
        try (ReleasableLock ignored = this.roleCacheHelper.acquireUpdateLock();){
            this.roleCache.invalidateAll();
        }
        this.dlsBitsetCache.clear("role store invalidation");
    }

    public void invalidate(String role) {
        this.numInvalidation.incrementAndGet();
        this.roleCacheHelper.removeKeysIf(key -> key.getNames().contains(role));
        this.negativeLookupCache.invalidate((Object)role);
    }

    public void invalidate(Set<String> roles) {
        this.numInvalidation.incrementAndGet();
        this.roleCacheHelper.removeKeysIf(key -> !Sets.haveEmptyIntersection((Set)key.getNames(), (Set)roles));
        roles.forEach(arg_0 -> this.negativeLookupCache.invalidate(arg_0));
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        HashMap<String, Map<String, Map>> usage = new HashMap<String, Map<String, Map>>();
        usage.put("dls", Map.of("bit_set_cache", this.dlsBitsetCache.usageStats()));
        this.roleProviders.usageStats((ActionListener<Map<String, Object>>)listener.map(roleUsage -> {
            usage.putAll((Map<String, Map<String, Map>>)roleUsage);
            return usage;
        }));
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || !Objects.equals(previousState.indexUUID, currentState.indexUUID) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.invalidateAll();
        }
    }

    boolean isValueInNegativeLookupCache(String key) {
        return this.negativeLookupCache.get((Object)key) != null;
    }

    private static void groupIndexPrivilegesByCluster(RoleDescriptor.RemoteIndicesPrivileges[] remoteIndicesPrivileges, Map<Set<String>, Set<RoleDescriptor.IndicesPrivileges>> remoteIndexPrivilegesByCluster) {
        boolean isExplicitDenial;
        assert (remoteIndicesPrivileges != null);
        boolean bl = isExplicitDenial = remoteIndicesPrivileges.length == 1 && "none".equalsIgnoreCase(remoteIndicesPrivileges[0].indicesPrivileges().getPrivileges()[0]);
        if (isExplicitDenial) {
            return;
        }
        for (RoleDescriptor.RemoteIndicesPrivileges remoteIndicesPrivilege : remoteIndicesPrivileges) {
            RoleDescriptor.IndicesPrivileges indicesPrivilege = remoteIndicesPrivilege.indicesPrivileges();
            HashSet clusterAliasKey = Sets.newHashSet((Object[])remoteIndicesPrivilege.remoteClusters());
            remoteIndexPrivilegesByCluster.computeIfAbsent(clusterAliasKey, k -> new HashSet()).add(indicesPrivilege);
        }
    }

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_SIZE_SETTING, NEGATIVE_LOOKUP_CACHE_SIZE_SETTING);
    }

    private static class MergeableIndicesPrivilege {
        private final Set<String> indices;
        private final Set<String> privileges;
        private FieldPermissionsDefinition fieldPermissionsDefinition;
        private Set<BytesReference> query = null;

        MergeableIndicesPrivilege(String[] indices, String[] privileges, @Nullable String[] grantedFields, @Nullable String[] deniedFields, @Nullable BytesReference query) {
            this.indices = Sets.newHashSet((Object[])Objects.requireNonNull(indices));
            this.privileges = Sets.newHashSet((Object[])Objects.requireNonNull(privileges));
            this.fieldPermissionsDefinition = new FieldPermissionsDefinition(grantedFields, deniedFields);
            if (query != null) {
                this.query = Sets.newHashSet((Object[])new BytesReference[]{query});
            }
        }

        void merge(MergeableIndicesPrivilege other) {
            assert (this.indices.equals(other.indices)) : "index names must be equivalent in order to merge";
            HashSet groups = new HashSet();
            groups.addAll(this.fieldPermissionsDefinition.getFieldGrantExcludeGroups());
            groups.addAll(other.fieldPermissionsDefinition.getFieldGrantExcludeGroups());
            this.fieldPermissionsDefinition = new FieldPermissionsDefinition(groups);
            this.privileges.addAll(other.privileges);
            if (this.query == null || other.query == null) {
                this.query = null;
            } else {
                this.query.addAll(other.query);
            }
        }

        private static void collatePrivilegesByIndices(RoleDescriptor.IndicesPrivileges[] indicesPrivileges, boolean allowsRestrictedIndices, Map<Set<String>, MergeableIndicesPrivilege> indicesPrivilegesMap) {
            boolean isExplicitDenial;
            boolean bl = isExplicitDenial = indicesPrivileges.length == 1 && "none".equalsIgnoreCase(indicesPrivileges[0].getPrivileges()[0]);
            if (isExplicitDenial) {
                return;
            }
            for (RoleDescriptor.IndicesPrivileges indicesPrivilege : indicesPrivileges) {
                if (indicesPrivilege.allowRestrictedIndices() != allowsRestrictedIndices) continue;
                HashSet key = Sets.newHashSet((Object[])indicesPrivilege.getIndices());
                indicesPrivilegesMap.compute(key, (k, value) -> {
                    if (value == null) {
                        return new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery());
                    }
                    value.merge(new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery()));
                    return value;
                });
            }
        }
    }
}

