/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.RBACEngine;

class AuthorizationDenialMessages {
    private AuthorizationDenialMessages() {
    }

    static String runAsDenied(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo, String action) {
        assert (authentication.isRunAs()) : "constructing run as denied message but authentication for action was not run as";
        String userText = AuthorizationDenialMessages.authenticatedUserDescription(authentication);
        String actionIsUnauthorizedMessage = AuthorizationDenialMessages.actionIsUnauthorizedMessage(action, userText);
        String unauthorizedToRunAsMessage = "because " + userText + " is unauthorized to run as [" + authentication.getEffectiveSubject().getUser().principal() + "]";
        return actionIsUnauthorizedMessage + AuthorizationDenialMessages.rolesDescription(authentication.getAuthenticatingSubject(), authorizationInfo.getAuthenticatedUserAuthorizationInfo()) + ", " + unauthorizedToRunAsMessage;
    }

    static String actionDenied(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo, String action, TransportRequest request, @Nullable String context) {
        Collection privileges;
        String userText = AuthorizationDenialMessages.successfulAuthenticationDescription(authentication, authorizationInfo);
        String remoteClusterText = authentication.isCrossClusterAccess() ? AuthorizationDenialMessages.remoteClusterText(null) : "";
        Object message = AuthorizationDenialMessages.actionIsUnauthorizedMessage(action, remoteClusterText, userText);
        if (context != null) {
            message = (String)message + " " + context;
        }
        if (ClusterPrivilegeResolver.isClusterAction((String)action)) {
            Collection privileges2 = ClusterPrivilegeResolver.findPrivilegesThatGrant((String)action, (TransportRequest)request, (Authentication)authentication);
            if (privileges2 != null && privileges2.size() > 0) {
                message = (String)message + ", this action is granted by the cluster privileges [" + Strings.collectionToCommaDelimitedString((Iterable)privileges2) + "]";
            }
        } else if (AuthorizationService.isIndexAction(action) && (privileges = IndexPrivilege.findPrivilegesThatGrant((String)action)) != null && privileges.size() > 0) {
            message = (String)message + ", this action is granted by the index privileges [" + Strings.collectionToCommaDelimitedString((Iterable)privileges) + "]";
        }
        return message;
    }

    static String remoteActionDenied(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo, String action, String clusterAlias) {
        assert (AuthorizationService.isIndexAction(action));
        String userText = AuthorizationDenialMessages.successfulAuthenticationDescription(authentication, authorizationInfo);
        String remoteClusterText = AuthorizationDenialMessages.remoteClusterText(clusterAlias);
        return AuthorizationDenialMessages.actionIsUnauthorizedMessage(action, remoteClusterText, userText) + " because no remote indices privileges apply for the target cluster";
    }

    private static String remoteClusterText(@Nullable String clusterAlias) {
        return Strings.format((String)"towards remote cluster%s ", (Object[])new Object[]{clusterAlias == null ? "" : " [" + clusterAlias + "]"});
    }

    private static String authenticatedUserDescription(Authentication authentication) {
        String userText = (authentication.isServiceAccount() ? "service account" : "user") + " [" + authentication.getAuthenticatingSubject().getUser().principal() + "]";
        if (authentication.isAuthenticatedAsApiKey() || authentication.isCrossClusterAccess()) {
            String apiKeyId = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
            assert (apiKeyId != null) : "api key id must be present in the metadata";
            userText = "API key id [" + apiKeyId + "] of " + userText;
            if (authentication.isCrossClusterAccess()) {
                Authentication crossClusterAccessAuthentication = (Authentication)authentication.getAuthenticatingSubject().getMetadata().get("_security_cross_cluster_access_authentication");
                assert (crossClusterAccessAuthentication != null) : "cross cluster access authentication must be present in the metadata";
                userText = AuthorizationDenialMessages.successfulAuthenticationDescription(crossClusterAccessAuthentication, null) + " authenticated by " + userText;
            }
        }
        return userText;
    }

    static String rolesDescription(Subject subject, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (subject.getType() != Subject.Type.USER) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<String> effectiveRoleNames = AuthorizationDenialMessages.extractEffectiveRoleNames(authorizationInfo);
        if (effectiveRoleNames == null) {
            sb.append(" with assigned roles [").append(Strings.arrayToCommaDelimitedString((Object[])subject.getUser().roles())).append("]");
        } else {
            sb.append(" with effective roles [").append(Strings.collectionToCommaDelimitedString(effectiveRoleNames)).append("]");
            Set<String> assignedRoleNames = Set.of(subject.getUser().roles());
            SortedSet unfoundedRoleNames = Sets.sortedDifference(assignedRoleNames, Set.copyOf(effectiveRoleNames));
            if (!unfoundedRoleNames.isEmpty()) {
                sb.append(" (assigned roles [").append(Strings.collectionToCommaDelimitedString((Iterable)unfoundedRoleNames)).append("] were not found)");
            }
        }
        return sb.toString();
    }

    static String successfulAuthenticationDescription(Authentication authentication, @Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        Object userText = AuthorizationDenialMessages.authenticatedUserDescription(authentication);
        if (authentication.isRunAs()) {
            userText = (String)userText + " run as [" + authentication.getEffectiveSubject().getUser().principal() + "]";
        }
        userText = (String)userText + AuthorizationDenialMessages.rolesDescription(authentication.getEffectiveSubject(), authorizationInfo);
        return userText;
    }

    private static List<String> extractEffectiveRoleNames(@Nullable AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (authorizationInfo == null) {
            return null;
        }
        Map info = authorizationInfo.asMap();
        Object roleNames = info.get("user.roles");
        if (!(roleNames instanceof String[])) {
            assert (!(authorizationInfo instanceof RBACEngine.RBACAuthorizationInfo)) : "unexpected user.roles field [" + roleNames + "] for RBACAuthorizationInfo";
            return null;
        }
        return Arrays.stream((String[])roleNames).sorted().toList();
    }

    private static String actionIsUnauthorizedMessage(String action, String userText) {
        return AuthorizationDenialMessages.actionIsUnauthorizedMessage(action, "", userText);
    }

    private static String actionIsUnauthorizedMessage(String action, String remoteClusterText, String userText) {
        return "action [" + action + "] " + remoteClusterText + "is unauthorized for " + userText;
    }
}

