/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;

public class JwtAuthenticationToken
implements AuthenticationToken {
    private final String principal;
    private SignedJWT signedJWT;
    private final byte[] userCredentialsHash;
    @Nullable
    private final SecureString clientAuthenticationSharedSecret;

    public JwtAuthenticationToken(String principal, SignedJWT signedJWT, byte[] userCredentialsHash, @Nullable SecureString clientAuthenticationSharedSecret) {
        this.principal = Objects.requireNonNull(principal);
        this.signedJWT = Objects.requireNonNull(signedJWT);
        this.userCredentialsHash = Objects.requireNonNull(userCredentialsHash);
        if (clientAuthenticationSharedSecret != null && clientAuthenticationSharedSecret.isEmpty()) {
            throw new IllegalArgumentException("Client shared secret must be non-empty");
        }
        this.clientAuthenticationSharedSecret = clientAuthenticationSharedSecret;
    }

    public String principal() {
        return this.principal;
    }

    public SecureString credentials() {
        return null;
    }

    public SignedJWT getSignedJWT() {
        return this.signedJWT;
    }

    public JWTClaimsSet getJWTClaimsSet() {
        try {
            return this.signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            assert (false) : "The JWT claims set should have already been successfully parsed before building the JWT authentication token";
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] getUserCredentialsHash() {
        return this.userCredentialsHash;
    }

    public SecureString getClientAuthenticationSharedSecret() {
        return this.clientAuthenticationSharedSecret;
    }

    public void clearCredentials() {
        this.signedJWT = null;
        Arrays.fill(this.userCredentialsHash, (byte)0);
        if (this.clientAuthenticationSharedSecret != null) {
            this.clientAuthenticationSharedSecret.close();
        }
    }

    public String toString() {
        return JwtAuthenticationToken.class.getSimpleName() + "=" + this.principal;
    }
}

