/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class InactiveApiKeysRemover
extends AbstractRunnable {
    private static final Logger logger = LogManager.getLogger(InactiveApiKeysRemover.class);
    private final Client client;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final TimeValue timeout;
    private final AtomicLong retentionPeriodInMs;

    InactiveApiKeysRemover(Settings settings, Client client, ClusterService clusterService) {
        this.client = client;
        this.timeout = (TimeValue)ApiKeyService.DELETE_TIMEOUT.get(settings);
        this.retentionPeriodInMs = new AtomicLong(((TimeValue)ApiKeyService.DELETE_RETENTION_PERIOD.get(settings)).getMillis());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ApiKeyService.DELETE_RETENTION_PERIOD, newRetentionPeriod -> this.retentionPeriodInMs.set(newRetentionPeriod.getMillis()));
    }

    public void doRun() {
        DeleteByQueryRequest expiredDbq = new DeleteByQueryRequest(new String[]{".security"});
        if (this.timeout != TimeValue.MINUS_ONE) {
            expiredDbq.setTimeout(this.timeout);
            expiredDbq.getSearchRequest().source().timeout(this.timeout);
        }
        Instant now = Instant.now();
        long cutoffTimestamp = now.minusMillis(this.retentionPeriodInMs.get()).toEpochMilli();
        expiredDbq.setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"api_key"})).should((QueryBuilder)QueryBuilders.rangeQuery((String)"expiration_time").lte((Object)cutoffTimestamp)).should((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"api_key_invalidated", (Object[])new Object[]{true})).should((QueryBuilder)QueryBuilders.rangeQuery((String)"invalidation_time").lte((Object)cutoffTimestamp)).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"invalidation_time"))).minimumShouldMatch(1)).minimumShouldMatch(1));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)expiredDbq, (ActionListener)ActionListener.wrap(r -> {
            InactiveApiKeysRemover.debugDbqResponse(r);
            this.markComplete();
        }, this::onFailure));
    }

    void submit(ThreadPool threadPool) {
        if (this.inProgress.compareAndSet(false, true)) {
            threadPool.executor("generic").submit((Runnable)((Object)this));
        }
    }

    private static void debugDbqResponse(BulkByScrollResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("delete by query of api keys finished with [{}] deletions, [{}] bulk failures, [{}] search failures", (Object)response.getDeleted(), (Object)response.getBulkFailures().size(), (Object)response.getSearchFailures().size());
            for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
                logger.debug(() -> Strings.format((String)"deletion failed for index [%s], id [%s]", (Object[])new Object[]{failure.getIndex(), failure.getId()}), (Throwable)failure.getCause());
            }
            for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
                logger.debug(() -> InactiveApiKeysRemover.lambda$debugDbqResponse$3((ScrollableHitSource.SearchFailure)failure), failure.getReason());
            }
        }
    }

    boolean isExpirationInProgress() {
        return this.inProgress.get();
    }

    public void onFailure(Exception e) {
        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
            logger.debug("failed to delete expired or invalidated api keys", (Throwable)e);
        } else {
            logger.error("failed to delete expired or invalidated api keys", (Throwable)e);
        }
        this.markComplete();
    }

    private void markComplete() {
        if (!this.inProgress.compareAndSet(true, false)) {
            throw new IllegalStateException("in progress was set to false but should have been true!");
        }
    }

    private static /* synthetic */ Object lambda$debugDbqResponse$3(ScrollableHitSource.SearchFailure failure) {
        return Strings.format((String)"search failed for index [%s], shard [%s] on node [%s]", (Object[])new Object[]{failure.getIndex(), failure.getShardId(), failure.getNodeId()});
    }
}

