/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportChangePasswordAction
extends HandledTransportAction<ChangePasswordRequest, ActionResponse.Empty> {
    private final Settings settings;
    private final NativeUsersStore nativeUsersStore;

    @Inject
    public TransportChangePasswordAction(Settings settings, TransportService transportService, ActionFilters actionFilters, NativeUsersStore nativeUsersStore) {
        super("cluster:admin/xpack/security/user/change_password", transportService, actionFilters, ChangePasswordRequest::new);
        this.settings = settings;
        this.nativeUsersStore = nativeUsersStore;
    }

    protected void doExecute(Task task, ChangePasswordRequest request, ActionListener<ActionResponse.Empty> listener) {
        Hasher configPwdHashAlgo;
        String username = request.username();
        if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified via the API"));
            return;
        }
        Hasher requestPwdHashAlgo = Hasher.resolveFromHash((char[])request.passwordHash());
        if (!requestPwdHashAlgo.equals((Object)(configPwdHashAlgo = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(this.settings))))) && !Hasher.getAvailableAlgoStoredHash().contains(requestPwdHashAlgo.name().toLowerCase(Locale.ROOT))) {
            listener.onFailure((Exception)new IllegalArgumentException("The provided password hash is not a hash or it could not be resolved to a supported hash algorithm. The supported password hash algorithms are " + Hasher.getAvailableAlgoStoredHash().toString()));
            return;
        }
        this.nativeUsersStore.changePassword(request, (ActionListener<Void>)listener.safeMap(v -> ActionResponse.Empty.INSTANCE));
    }
}

