/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.profile;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesRequest;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesResponse;
import org.elasticsearch.xpack.security.profile.ProfileService;

public class TransportSuggestProfilesAction
extends HandledTransportAction<SuggestProfilesRequest, SuggestProfilesResponse> {
    private final ProfileService profileService;
    private final ClusterService clusterService;

    @Inject
    public TransportSuggestProfilesAction(TransportService transportService, ActionFilters actionFilters, ProfileService profileService, ClusterService clusterService) {
        super("cluster:admin/xpack/security/profile/suggest", transportService, actionFilters, SuggestProfilesRequest::new);
        this.profileService = profileService;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, SuggestProfilesRequest request, ActionListener<SuggestProfilesResponse> listener) {
        this.profileService.suggestProfile(request, new TaskId(this.clusterService.localNode().getId(), task.getId()), listener);
    }
}

