/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.privilege;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheRequest;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheResponse;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;

public class TransportClearPrivilegesCacheAction
extends TransportNodesAction<ClearPrivilegesCacheRequest, ClearPrivilegesCacheResponse, ClearPrivilegesCacheRequest.Node, ClearPrivilegesCacheResponse.Node> {
    private final CompositeRolesStore rolesStore;
    private final CacheInvalidatorRegistry cacheInvalidatorRegistry;

    @Inject
    public TransportClearPrivilegesCacheAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CompositeRolesStore rolesStore, CacheInvalidatorRegistry cacheInvalidatorRegistry) {
        super("cluster:admin/xpack/security/privilege/cache/clear", threadPool, clusterService, transportService, actionFilters, ClearPrivilegesCacheRequest::new, ClearPrivilegesCacheRequest.Node::new, "management");
        this.rolesStore = rolesStore;
        this.cacheInvalidatorRegistry = cacheInvalidatorRegistry;
    }

    protected ClearPrivilegesCacheResponse newResponse(ClearPrivilegesCacheRequest request, List<ClearPrivilegesCacheResponse.Node> nodes, List<FailedNodeException> failures) {
        return new ClearPrivilegesCacheResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected ClearPrivilegesCacheRequest.Node newNodeRequest(ClearPrivilegesCacheRequest request) {
        return new ClearPrivilegesCacheRequest.Node(request);
    }

    protected ClearPrivilegesCacheResponse.Node newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ClearPrivilegesCacheResponse.Node(in);
    }

    protected ClearPrivilegesCacheResponse.Node nodeOperation(ClearPrivilegesCacheRequest.Node request, Task task) {
        if (request.getApplicationNames() == null || request.getApplicationNames().length == 0) {
            this.cacheInvalidatorRegistry.invalidateCache("application_privileges");
        } else {
            this.cacheInvalidatorRegistry.invalidateByKey("application_privileges", List.of(request.getApplicationNames()));
        }
        if (request.clearRolesCache()) {
            this.rolesStore.invalidateAll();
        }
        return new ClearPrivilegesCacheResponse.Node(this.clusterService.localNode());
    }
}

