/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.oidc;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutRequest;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.support.TokensInvalidationResult;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectRealm;

public class TransportOpenIdConnectLogoutAction
extends HandledTransportAction<OpenIdConnectLogoutRequest, OpenIdConnectLogoutResponse> {
    private final Realms realms;
    private final TokenService tokenService;
    private static final Logger logger = LogManager.getLogger(TransportOpenIdConnectLogoutAction.class);

    @Inject
    public TransportOpenIdConnectLogoutAction(TransportService transportService, ActionFilters actionFilters, Realms realms, TokenService tokenService) {
        super("cluster:admin/xpack/security/oidc/logout", transportService, actionFilters, OpenIdConnectLogoutRequest::new);
        this.realms = realms;
        this.tokenService = tokenService;
    }

    protected void doExecute(Task task, OpenIdConnectLogoutRequest request, ActionListener<OpenIdConnectLogoutResponse> listener) {
        this.invalidateRefreshToken(request.getRefreshToken(), (ActionListener<TokensInvalidationResult>)ActionListener.wrap(ignore -> {
            String token = request.getToken();
            this.tokenService.getAuthenticationAndMetadata(token, (ActionListener<Tuple<Authentication, Map<String, Object>>>)ActionListener.wrap(tuple -> {
                Authentication authentication = (Authentication)tuple.v1();
                assert (!authentication.isRunAs()) : "oidc realm authentication cannot have run-as";
                Map tokenMetadata = (Map)tuple.v2();
                this.validateAuthenticationAndMetadata(authentication, tokenMetadata);
                this.tokenService.invalidateAccessToken(token, (ActionListener<TokensInvalidationResult>)ActionListener.wrap(result -> {
                    if (logger.isTraceEnabled()) {
                        logger.trace("OpenID Connect Logout for user [{}] and token [{}...{}]", (Object)authentication.getEffectiveSubject().getUser().principal(), (Object)token.substring(0, 8), (Object)token.substring(token.length() - 8));
                    }
                    OpenIdConnectLogoutResponse response = this.buildResponse(authentication, tokenMetadata);
                    listener.onResponse((Object)response);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private OpenIdConnectLogoutResponse buildResponse(Authentication authentication, Map<String, Object> tokenMetadata) {
        JWT idToken;
        String idTokenHint = (String)TransportOpenIdConnectLogoutAction.getFromMetadata(tokenMetadata, "id_token_hint");
        Realm realm = this.realms.realm(authentication.getEffectiveSubject().getRealm().getName());
        try {
            idToken = JWTParser.parse((String)idTokenHint);
        }
        catch (ParseException e) {
            throw new ElasticsearchSecurityException("Token Metadata did not contain a valid IdToken", (Exception)e, new Object[0]);
        }
        return ((OpenIdConnectRealm)realm).buildLogoutResponse(idToken);
    }

    private void validateAuthenticationAndMetadata(Authentication authentication, Map<String, Object> tokenMetadata) {
        if (tokenMetadata == null) {
            throw new ElasticsearchSecurityException("Authentication did not contain metadata", new Object[0]);
        }
        if (authentication == null) {
            throw new ElasticsearchSecurityException("No active authentication", new Object[0]);
        }
        User user = authentication.getEffectiveSubject().getUser();
        if (user == null) {
            throw new ElasticsearchSecurityException("No active user", new Object[0]);
        }
        Authentication.RealmRef ref = authentication.getEffectiveSubject().getRealm();
        if (ref == null || Strings.isNullOrEmpty((String)ref.getName())) {
            throw new ElasticsearchSecurityException("Authentication {} has no authenticating realm", new Object[]{authentication});
        }
        Realm realm = this.realms.realm(authentication.getEffectiveSubject().getRealm().getName());
        if (realm == null) {
            throw new ElasticsearchSecurityException("Authenticating realm {} does not exist", new Object[]{ref.getName()});
        }
        if (!(realm instanceof OpenIdConnectRealm)) {
            throw new IllegalArgumentException("Access token is not valid for an OpenID Connect realm");
        }
    }

    private static Object getFromMetadata(Map<String, Object> metadata, String key) {
        if (!metadata.containsKey(key)) {
            throw new ElasticsearchSecurityException("Authentication token does not have OpenID Connect metadata [{}]", new Object[]{key});
        }
        Object value = metadata.get(key);
        if (null != value && !(value instanceof String)) {
            throw new ElasticsearchSecurityException("In authentication token, OpenID Connect metadata [{}] is [{}] rather than String", new Object[]{key, value.getClass()});
        }
        return value;
    }

    private void invalidateRefreshToken(String refreshToken, ActionListener<TokensInvalidationResult> listener) {
        if (refreshToken == null) {
            listener.onResponse(null);
        } else {
            this.tokenService.invalidateRefreshToken(refreshToken, listener);
        }
    }
}

