/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportGetApiKeyAction
extends HandledTransportAction<GetApiKeyRequest, GetApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;

    @Inject
    public TransportGetApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context) {
        super("cluster:admin/xpack/security/api_key/get", transportService, actionFilters, GetApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
    }

    protected void doExecute(Task task, GetApiKeyRequest request, ActionListener<GetApiKeyResponse> listener) {
        String[] stringArray;
        String[] stringArray2;
        if (Strings.hasText((String)request.getApiKeyId())) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = request.getApiKeyId();
        } else {
            stringArray2 = null;
        }
        String[] apiKeyIds = stringArray2;
        String apiKeyName = request.getApiKeyName();
        String username = request.getUserName();
        if (Strings.hasText((String)request.getRealmName())) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = request.getRealmName();
        } else {
            stringArray = null;
        }
        String[] realms = stringArray;
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        }
        if (request.ownedByAuthenticatedUser()) {
            assert (username == null);
            assert (realms == null);
            username = authentication.getEffectiveSubject().getUser().principal();
            realms = ApiKeyService.getOwnersRealmNames(authentication);
        }
        this.apiKeyService.getApiKeys(realms, username, apiKeyName, apiKeyIds, request.withLimitedBy(), request.activeOnly(), listener);
    }
}

