/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.index;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public final class VersionCompatibilityChecks {
    public static final Version INTRODUCING_UNSIGNED_LONG = Version.V_8_2_0;
    public static final TransportVersion INTRODUCING_UNSIGNED_LONG_TRANSPORT = TransportVersion.V_8_2_0;
    public static final Version INTRODUCING_VERSION_FIELD_TYPE = Version.V_8_4_0;

    private VersionCompatibilityChecks() {
    }

    public static boolean isTypeSupportedInVersion(DataType dataType, Version version) {
        if (dataType == DataTypes.UNSIGNED_LONG) {
            return VersionCompatibilityChecks.supportsUnsignedLong(version);
        }
        if (dataType == DataTypes.VERSION) {
            return VersionCompatibilityChecks.supportsVersionType(version);
        }
        return true;
    }

    public static boolean supportsUnsignedLong(Version version) {
        return INTRODUCING_UNSIGNED_LONG.compareTo((VersionId)version) <= 0;
    }

    public static boolean supportsVersionType(Version version) {
        return INTRODUCING_VERSION_FIELD_TYPE.compareTo((VersionId)version) <= 0;
    }

    @Nullable
    public static Version versionIntroducingType(DataType dataType) {
        if (dataType == DataTypes.UNSIGNED_LONG) {
            return INTRODUCING_UNSIGNED_LONG;
        }
        if (dataType == DataTypes.VERSION) {
            return INTRODUCING_VERSION_FIELD_TYPE;
        }
        return null;
    }
}

