/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.profiling.GetStatusAction;
import org.elasticsearch.xpack.profiling.IndexStateResolver;
import org.elasticsearch.xpack.profiling.ProfilingDataStreamManager;
import org.elasticsearch.xpack.profiling.ProfilingIndexManager;
import org.elasticsearch.xpack.profiling.ProfilingIndexTemplateRegistry;
import org.elasticsearch.xpack.profiling.ProfilingPlugin;

public class TransportGetStatusAction
extends TransportMasterNodeAction<GetStatusAction.Request, GetStatusAction.Response> {
    @Inject
    public TransportGetStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/profiling/status/get", transportService, clusterService, threadPool, actionFilters, GetStatusAction.Request::new, indexNameExpressionResolver, GetStatusAction.Response::new, "same");
    }

    protected void masterOperation(Task task, GetStatusAction.Request request, ClusterState state, ActionListener<GetStatusAction.Response> listener) {
        IndexStateResolver indexStateResolver = new IndexStateResolver(this.getValue(state, ProfilingPlugin.PROFILING_CHECK_OUTDATED_INDICES));
        boolean pluginEnabled = this.getValue(state, (Setting<Boolean>)XPackSettings.PROFILING_ENABLED);
        boolean resourceManagementEnabled = this.getValue(state, ProfilingPlugin.PROFILING_TEMPLATES_ENABLED);
        boolean templatesCreated = ProfilingIndexTemplateRegistry.isAllResourcesCreated(state, this.clusterService.getSettings());
        boolean indicesCreated = ProfilingIndexManager.isAllResourcesCreated(state, indexStateResolver);
        boolean dataStreamsCreated = ProfilingDataStreamManager.isAllResourcesCreated(state, indexStateResolver);
        boolean resourcesCreated = templatesCreated && indicesCreated && dataStreamsCreated;
        boolean indicesPre891 = ProfilingIndexManager.isAnyResourceTooOld(state, indexStateResolver);
        boolean dataStreamsPre891 = ProfilingDataStreamManager.isAnyResourceTooOld(state, indexStateResolver);
        boolean anyPre891Data = indicesPre891 || dataStreamsPre891;
        listener.onResponse((Object)new GetStatusAction.Response(pluginEnabled, resourceManagementEnabled, resourcesCreated, anyPre891Data));
    }

    private boolean getValue(ClusterState state, Setting<Boolean> setting) {
        Metadata metadata = state.getMetadata();
        if (metadata.settings().hasValue(setting.getKey())) {
            return (Boolean)setting.get(metadata.settings());
        }
        return (Boolean)setting.get(this.clusterService.getSettings());
    }

    protected ClusterBlockException checkBlock(GetStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

