/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xpack.profiling.EventsIndex;
import org.elasticsearch.xpack.profiling.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.KvIndexResolver;
import org.elasticsearch.xpack.profiling.StackFrame;
import org.elasticsearch.xpack.profiling.StackTrace;

public class TransportGetStackTracesAction
extends HandledTransportAction<GetStackTracesRequest, GetStackTracesResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetStackTracesAction.class);
    public static final Setting<Integer> PROFILING_MAX_STACKTRACE_QUERY_SLICES = Setting.intSetting((String)"xpack.profiling.query.stacktrace.max_slices", (int)16, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> PROFILING_MAX_DETAIL_QUERY_SLICES = Setting.intSetting((String)"xpack.profiling.query.details.max_slices", (int)16, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> PROFILING_QUERY_REALTIME = Setting.boolSetting((String)"xpack.profiling.query.realtime", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROFILING_KV_INDEX_OVERLAP = Setting.positiveTimeSetting((String)"xpack.profiling.kv_index.overlap", (TimeValue)TimeValue.timeValueHours((long)3L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final NodeClient nodeClient;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Executor responseExecutor;
    private final KvIndexResolver resolver;
    private final int desiredSlices;
    private final int desiredDetailSlices;
    private final boolean realtime;

    @Inject
    public TransportGetStackTracesAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeClient nodeClient, IndexNameExpressionResolver resolver) {
        super("indices:data/read/profiling/stack_traces", transportService, actionFilters, GetStackTracesRequest::new);
        this.nodeClient = nodeClient;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.responseExecutor = threadPool.executor("profiling");
        this.resolver = new KvIndexResolver(resolver, (TimeValue)PROFILING_KV_INDEX_OVERLAP.get(settings));
        this.desiredSlices = (Integer)PROFILING_MAX_STACKTRACE_QUERY_SLICES.get(settings);
        this.desiredDetailSlices = (Integer)PROFILING_MAX_DETAIL_QUERY_SLICES.get(settings);
        this.realtime = (Boolean)PROFILING_QUERY_REALTIME.get(settings);
    }

    protected void doExecute(Task submitTask, GetStackTracesRequest request, ActionListener<GetStackTracesResponse> submitListener) {
        long start = System.nanoTime();
        ParentTaskAssigningClient client = new ParentTaskAssigningClient((Client)this.nodeClient, this.transportService.getLocalNode(), submitTask);
        EventsIndex mediumDownsampled = EventsIndex.MEDIUM_DOWNSAMPLED;
        client.prepareSearch(new String[]{mediumDownsampled.getName()}).setSize(0).setQuery(request.getQuery()).setTrackTotalHits(true).execute(ActionListener.wrap(arg_0 -> this.lambda$doExecute$0(mediumDownsampled, request, start, (Client)client, submitListener, arg_0), arg_0 -> this.lambda$doExecute$1((Client)client, request, submitListener, arg_0)));
    }

    private void searchEventGroupByStackTrace(Client client, GetStackTracesRequest request, EventsIndex eventsIndex, ActionListener<GetStackTracesResponse> submitListener) {
        long start = System.nanoTime();
        GetStackTracesResponseBuilder responseBuilder = new GetStackTracesResponseBuilder();
        int exp = eventsIndex.getExponent();
        responseBuilder.setSampleRate(eventsIndex.getSampleRate());
        client.prepareSearch(new String[]{eventsIndex.getName()}).setTrackTotalHits(false).setSize(0).setQuery(request.getQuery()).addAggregation((AggregationBuilder)new MinAggregationBuilder("min_time").field("@timestamp")).addAggregation((AggregationBuilder)new MaxAggregationBuilder("max_time").field("@timestamp")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("group_by").size(150000).field("Stacktrace.id")).executionHint("map").subAggregation((AggregationBuilder)new SumAggregationBuilder("count").field("Stacktrace.count"))).addAggregation((AggregationBuilder)new SumAggregationBuilder("total_count").field("Stacktrace.count")).execute(ActionListener.wrap(searchResponse -> {
            Min minTimeAgg = (Min)searchResponse.getAggregations().get("min_time");
            Max maxTimeAgg = (Max)searchResponse.getAggregations().get("max_time");
            long minTime = Math.round(minTimeAgg.value());
            long maxTime = Math.round(maxTimeAgg.value());
            Sum totalCountAgg = (Sum)searchResponse.getAggregations().get("total_count");
            long totalCount = Math.round(totalCountAgg.value());
            Resampler resampler = new Resampler(request, eventsIndex.getSampleRate(), totalCount);
            StringTerms stacktraces = (StringTerms)searchResponse.getAggregations().get("group_by");
            TreeMap<String, Integer> stackTraceEvents = new TreeMap<String, Integer>();
            for (StringTerms.Bucket bucket : stacktraces.getBuckets()) {
                Sum count = (Sum)bucket.getAggregations().get("count");
                int finalCount = resampler.adjustSampleCount((int)count.value());
                if (finalCount <= 0) continue;
                stackTraceEvents.put(bucket.getKeyAsString(), finalCount);
            }
            log.debug("searchEventGroupByStackTrace took [" + (double)(System.nanoTime() - start) / 1000000.0 + " ms].");
            if (!stackTraceEvents.isEmpty()) {
                responseBuilder.setStart(Instant.ofEpochMilli(minTime));
                responseBuilder.setEnd(Instant.ofEpochMilli(maxTime));
                responseBuilder.setStackTraceEvents(stackTraceEvents);
                this.retrieveStackTraces(client, responseBuilder, submitListener);
            } else {
                submitListener.onResponse((Object)responseBuilder.build());
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                log.debug("Index [{}] does not exist. Returning empty response.", (Object)((IndexNotFoundException)e).getIndex());
                submitListener.onResponse((Object)responseBuilder.build());
            } else {
                submitListener.onFailure(e);
            }
        }));
    }

    private void retrieveStackTraces(Client client, GetStackTracesResponseBuilder responseBuilder, ActionListener<GetStackTracesResponse> submitListener) {
        ArrayList<String> eventIds = new ArrayList<String>(responseBuilder.getStackTraceEvents().keySet());
        List<List<String>> slicedEventIds = TransportGetStackTracesAction.sliced(eventIds, this.desiredSlices);
        ClusterState clusterState = this.clusterService.state();
        List<Index> indices = this.resolver.resolve(clusterState, "profiling-stacktraces", responseBuilder.getStart(), responseBuilder.getEnd());
        StackTraceHandler handler = new StackTraceHandler(clusterState, client, responseBuilder, submitListener, eventIds.size(), slicedEventIds.size() * indices.size());
        for (List<String> slice : slicedEventIds) {
            this.mget(client, indices, slice, (ActionListener<MultiGetResponse>)ActionListener.wrap(handler::onResponse, arg_0 -> submitListener.onFailure(arg_0)));
        }
    }

    static <T> List<List<T>> sliced(List<T> c, int slices) {
        if (c.size() <= slices) {
            return List.of(c);
        }
        ArrayList<List<T>> slicedList = new ArrayList<List<T>>();
        int batchSize = c.size() / slices;
        for (int slice = 0; slice < slices; ++slice) {
            int upperIndex = slice + 1 < slices ? (slice + 1) * batchSize : c.size();
            List<T> ids = c.subList(slice * batchSize, upperIndex);
            slicedList.add(ids);
        }
        return Collections.unmodifiableList(slicedList);
    }

    private void retrieveStackTraceDetails(ClusterState clusterState, Client client, GetStackTracesResponseBuilder responseBuilder, List<String> stackFrameIds, List<String> executableIds, ActionListener<GetStackTracesResponse> submitListener) {
        List<List<String>> slicedStackFrameIds = TransportGetStackTracesAction.sliced(stackFrameIds, this.desiredDetailSlices);
        List<List<String>> slicedExecutableIds = TransportGetStackTracesAction.sliced(executableIds, this.desiredDetailSlices);
        List<Index> stackFrameIndices = this.resolver.resolve(clusterState, "profiling-stackframes", responseBuilder.getStart(), responseBuilder.getEnd());
        List<Index> executableIndices = this.resolver.resolve(clusterState, "profiling-executables", responseBuilder.getStart(), responseBuilder.getEnd());
        DetailsHandler handler = new DetailsHandler(responseBuilder, submitListener, executableIds.size(), stackFrameIds.size(), slicedExecutableIds.size() * executableIndices.size(), slicedStackFrameIds.size() * stackFrameIndices.size());
        if (stackFrameIds.isEmpty()) {
            handler.onStackFramesResponse(new MultiGetResponse(new MultiGetItemResponse[0]));
        } else {
            for (List<String> slice : slicedStackFrameIds) {
                this.mget(client, stackFrameIndices, slice, (ActionListener<MultiGetResponse>)ActionListener.wrap(handler::onStackFramesResponse, arg_0 -> submitListener.onFailure(arg_0)));
            }
        }
        if (executableIds.isEmpty()) {
            handler.onExecutableDetailsResponse(new MultiGetResponse(new MultiGetItemResponse[0]));
        } else {
            for (List<String> slice : slicedExecutableIds) {
                this.mget(client, executableIndices, slice, (ActionListener<MultiGetResponse>)ActionListener.wrap(handler::onExecutableDetailsResponse, arg_0 -> submitListener.onFailure(arg_0)));
            }
        }
    }

    private void mget(Client client, List<Index> indices, List<String> slice, ActionListener<MultiGetResponse> listener) {
        for (Index index : indices) {
            client.prepareMultiGet().addIds(index.getName(), slice).setRealtime(this.realtime).execute((ActionListener)new ThreadedActionListener(this.responseExecutor, listener));
        }
    }

    private /* synthetic */ void lambda$doExecute$1(Client client, GetStackTracesRequest request, ActionListener submitListener, Exception e) {
        if (e instanceof IndexNotFoundException) {
            String missingIndex = ((IndexNotFoundException)e).getIndex().getName();
            EventsIndex fullIndex = EventsIndex.FULL_INDEX;
            log.debug("Index [{}] does not exist. Using [{}] instead.", (Object)missingIndex, (Object)fullIndex.getName());
            this.searchEventGroupByStackTrace(client, request, fullIndex, (ActionListener<GetStackTracesResponse>)submitListener);
        } else {
            submitListener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$doExecute$0(EventsIndex mediumDownsampled, GetStackTracesRequest request, long start, Client client, ActionListener submitListener, SearchResponse searchResponse) throws Exception {
        long sampleCount = searchResponse.getHits().getTotalHits().value;
        EventsIndex resampledIndex = mediumDownsampled.getResampledIndex(request.getSampleSize().intValue(), sampleCount);
        log.debug("getResampledIndex took [" + (double)(System.nanoTime() - start) / 1000000.0 + " ms].");
        this.searchEventGroupByStackTrace(client, request, resampledIndex, (ActionListener<GetStackTracesResponse>)submitListener);
    }

    private static class GetStackTracesResponseBuilder {
        private Map<String, StackTrace> stackTraces;
        private Instant start;
        private Instant end;
        private int totalFrames;
        private Map<String, StackFrame> stackFrames;
        private Map<String, String> executables;
        private Map<String, Integer> stackTraceEvents;
        private double samplingRate;

        private GetStackTracesResponseBuilder() {
        }

        public void setStackTraces(Map<String, StackTrace> stackTraces) {
            this.stackTraces = stackTraces;
        }

        public Instant getStart() {
            return this.start;
        }

        public void setStart(Instant start) {
            this.start = start;
        }

        public Instant getEnd() {
            return this.end;
        }

        public void setEnd(Instant end) {
            this.end = end;
        }

        public void setTotalFrames(int totalFrames) {
            this.totalFrames = totalFrames;
        }

        public void setStackFrames(Map<String, StackFrame> stackFrames) {
            this.stackFrames = stackFrames;
        }

        public void setExecutables(Map<String, String> executables) {
            this.executables = executables;
        }

        public void setStackTraceEvents(Map<String, Integer> stackTraceEvents) {
            this.stackTraceEvents = stackTraceEvents;
        }

        public Map<String, Integer> getStackTraceEvents() {
            return this.stackTraceEvents;
        }

        public void setSampleRate(double rate) {
            this.samplingRate = rate;
        }

        public GetStackTracesResponse build() {
            return new GetStackTracesResponse(this.stackTraces, this.stackFrames, this.executables, this.stackTraceEvents, this.totalFrames, this.samplingRate);
        }
    }

    private class StackTraceHandler {
        private final AtomicInteger remainingSlices;
        private final ClusterState clusterState;
        private final Client client;
        private final GetStackTracesResponseBuilder responseBuilder;
        private final ActionListener<GetStackTracesResponse> submitListener;
        private final Map<String, StackTrace> stackTracePerId;
        private final Set<String> stackFrameIds = new ConcurrentSkipListSet<String>();
        private final Set<String> executableIds = new ConcurrentSkipListSet<String>();
        private final AtomicInteger totalFrames = new AtomicInteger();
        private final long start = System.nanoTime();

        private StackTraceHandler(ClusterState clusterState, Client client, GetStackTracesResponseBuilder responseBuilder, ActionListener<GetStackTracesResponse> submitListener, int stackTraceCount, int slices) {
            this.clusterState = clusterState;
            this.stackTracePerId = new ConcurrentHashMap<String, StackTrace>(stackTraceCount);
            this.remainingSlices = new AtomicInteger(slices);
            this.client = client;
            this.responseBuilder = responseBuilder;
            this.submitListener = submitListener;
        }

        public void onResponse(MultiGetResponse multiGetItemResponses) {
            for (MultiGetItemResponse trace : multiGetItemResponses) {
                StackTrace stacktrace;
                String id;
                if (trace.isFailed()) {
                    this.submitListener.onFailure(trace.getFailure().getFailure());
                    return;
                }
                if (!trace.getResponse().isExists() || this.stackTracePerId.containsKey(id = trace.getId()) || this.stackTracePerId.putIfAbsent(id, stacktrace = StackTrace.fromSource(trace.getResponse().getSource())) != null) continue;
                this.totalFrames.addAndGet(stacktrace.frameIds.size());
                this.stackFrameIds.addAll(stacktrace.frameIds);
                this.executableIds.addAll(stacktrace.fileIds);
            }
            if (this.remainingSlices.decrementAndGet() == 0) {
                this.responseBuilder.setStackTraces(this.stackTracePerId);
                this.responseBuilder.setTotalFrames(this.totalFrames.get());
                log.debug("retrieveStackTraces took [" + (double)(System.nanoTime() - this.start) / 1000000.0 + " ms].");
                TransportGetStackTracesAction.this.retrieveStackTraceDetails(this.clusterState, this.client, this.responseBuilder, new ArrayList<String>(this.stackFrameIds), new ArrayList<String>(this.executableIds), this.submitListener);
            }
        }
    }

    private static class DetailsHandler {
        private final GetStackTracesResponseBuilder builder;
        private final ActionListener<GetStackTracesResponse> submitListener;
        private final Map<String, String> executables;
        private final Map<String, StackFrame> stackFrames;
        private final AtomicInteger expectedSlices;
        private final long start = System.nanoTime();

        private DetailsHandler(GetStackTracesResponseBuilder builder, ActionListener<GetStackTracesResponse> submitListener, int executableCount, int stackFrameCount, int expectedExecutableSlices, int expectedStackFrameSlices) {
            this.builder = builder;
            this.submitListener = submitListener;
            this.executables = new ConcurrentHashMap<String, String>(executableCount);
            this.stackFrames = new ConcurrentHashMap<String, StackFrame>(stackFrameCount);
            this.expectedSlices = new AtomicInteger(expectedExecutableSlices + expectedStackFrameSlices);
        }

        public void onStackFramesResponse(MultiGetResponse multiGetItemResponses) {
            for (MultiGetItemResponse frame : multiGetItemResponses) {
                if (frame.isFailed()) {
                    this.submitListener.onFailure(frame.getFailure().getFailure());
                    return;
                }
                if (!frame.getResponse().isExists() || this.stackFrames.containsKey(frame.getId())) continue;
                this.stackFrames.putIfAbsent(frame.getId(), StackFrame.fromSource(frame.getResponse().getSource()));
            }
            this.mayFinish();
        }

        public void onExecutableDetailsResponse(MultiGetResponse multiGetItemResponses) {
            for (MultiGetItemResponse executable : multiGetItemResponses) {
                if (executable.isFailed()) {
                    this.submitListener.onFailure(executable.getFailure().getFailure());
                    return;
                }
                if (!executable.getResponse().isExists() || this.executables.containsKey(executable.getId())) continue;
                String fileName = (String)ObjectPath.eval((String)"Executable.file.name", (Object)executable.getResponse().getSource());
                if (fileName != null) {
                    this.executables.putIfAbsent(executable.getId(), fileName);
                    continue;
                }
                String priorKey = this.executables.putIfAbsent(executable.getId(), "<missing>");
                if (priorKey != null) continue;
                log.trace("Executable with id [{}] has no file name.", (Object)executable.getId());
            }
            this.mayFinish();
        }

        public void mayFinish() {
            if (this.expectedSlices.decrementAndGet() == 0) {
                this.builder.setExecutables(this.executables);
                this.builder.setStackFrames(this.stackFrames);
                log.debug("retrieveStackTraceDetails took [" + (double)(System.nanoTime() - this.start) / 1000000.0 + " ms].");
                this.submitListener.onResponse((Object)this.builder.build());
            }
        }
    }

    private static class Resampler {
        private final boolean requiresResampling;
        private final Random r;
        private final double sampleRate;
        private final double p;

        Resampler(GetStackTracesRequest request, double sampleRate, long totalCount) {
            if ((double)totalCount > (double)request.getSampleSize().intValue() * 1.1) {
                this.requiresResampling = true;
                this.r = new Random(request.hashCode());
                this.sampleRate = sampleRate;
                this.p = (double)request.getSampleSize().intValue() / (double)totalCount;
            } else {
                this.requiresResampling = false;
                this.r = null;
                this.sampleRate = sampleRate;
                this.p = 1.0;
            }
        }

        public int adjustSampleCount(int originalCount) {
            if (this.requiresResampling) {
                int newCount = 0;
                for (int i = 0; i < originalCount; ++i) {
                    if (!(this.r.nextDouble() < this.p)) continue;
                    ++newCount;
                }
                if (newCount > 0) {
                    return (int)Math.floor((double)newCount / this.p);
                }
                return 0;
            }
            return originalCount;
        }
    }
}

