/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;

public class KvIndexResolver {
    private static final Logger log = LogManager.getLogger(KvIndexResolver.class);
    private final IndexNameExpressionResolver resolver;
    private final TimeValue kvIndexOverlapPeriod;

    public KvIndexResolver(IndexNameExpressionResolver resolver, TimeValue kvIndexOverlapPeriod) {
        this.resolver = resolver;
        this.kvIndexOverlapPeriod = kvIndexOverlapPeriod;
    }

    public List<Index> resolve(ClusterState clusterState, String indexPattern, Instant eventStart, Instant eventEnd) {
        Index[] indices = this.resolver.concreteIndices(clusterState, IndicesOptions.STRICT_EXPAND_OPEN, new String[]{indexPattern});
        ArrayList<Index> matchingIndices = new ArrayList<Index>();
        if (indices.length > 1) {
            ArrayList<Tuple> indicesWithTime = new ArrayList<Tuple>();
            Map indicesMetadata = clusterState.getMetadata().getIndices();
            for (Index i : indices) {
                long creationDate;
                IndexMetadata indexMetadata = (IndexMetadata)indicesMetadata.get(i.getName());
                if (indexMetadata.getSettings().hasValue("index.lifecycle.origination_date")) {
                    creationDate = (Long)IndexSettings.LIFECYCLE_ORIGINATION_DATE_SETTING.get(indexMetadata.getSettings());
                    log.trace("Using lifecycle origination date [{}] for index [{}]", (Object)creationDate, (Object)i.getName());
                } else {
                    creationDate = indexMetadata.getCreationDate();
                    log.trace("Using index creation date [{}] for index [{}]", (Object)creationDate, (Object)i.getName());
                }
                indicesWithTime.add(Tuple.tuple((Object)i, (Object)Instant.ofEpochMilli(creationDate)));
            }
            indicesWithTime.sort((i1, i2) -> ((Instant)i2.v2()).compareTo((Instant)i1.v2()));
            Instant intervalEnd = Instant.MAX;
            for (Tuple indexAndTime : indicesWithTime) {
                Instant intervalStart = (Instant)indexAndTime.v2();
                if (intervalStart.isBefore(eventEnd) && intervalEnd.isAfter(eventStart)) {
                    matchingIndices.add((Index)indexAndTime.v1());
                }
                intervalEnd = intervalStart.plusMillis(this.kvIndexOverlapPeriod.millis());
            }
        }
        if (matchingIndices.isEmpty()) {
            log.debug("Querying all indices for [" + indexPattern + "].");
            matchingIndices.addAll(Arrays.asList(indices));
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolved index pattern [" + indexPattern + "] in time range [" + eventStart.toEpochMilli() + ", " + eventEnd.toEpochMilli() + "] to indices [" + matchingIndices.stream().map(Index::getName).collect(Collectors.joining(", ")) + "].");
        }
        return Collections.unmodifiableList(matchingIndices);
    }
}

