/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetStatusAction
extends ActionType<Response> {
    public static final GetStatusAction INSTANCE = new GetStatusAction();
    public static final String NAME = "cluster:monitor/profiling/status/get";

    protected GetStatusAction() {
        super(NAME, Response::new);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request() {
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private boolean profilingEnabled;
        private boolean resourceManagementEnabled;
        private boolean resourcesCreated;
        private boolean pre891Data;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.profilingEnabled = in.readBoolean();
            this.resourceManagementEnabled = in.readBoolean();
            this.resourcesCreated = in.readBoolean();
            this.pre891Data = in.readBoolean();
        }

        public Response(boolean profilingEnabled, boolean resourceManagementEnabled, boolean resourcesCreated, boolean pre891Data) {
            this.profilingEnabled = profilingEnabled;
            this.resourceManagementEnabled = resourceManagementEnabled;
            this.resourcesCreated = resourcesCreated;
            this.pre891Data = pre891Data;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("profiling").field("enabled", this.profilingEnabled).endObject();
            builder.startObject("resource_management").field("enabled", this.resourceManagementEnabled).endObject();
            builder.startObject("resources").field("created", this.resourcesCreated).field("pre_8_9_1_data", this.pre891Data).endObject();
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.profilingEnabled);
            out.writeBoolean(this.resourceManagementEnabled);
            out.writeBoolean(this.resourcesCreated);
            out.writeBoolean(this.pre891Data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.profilingEnabled == response.profilingEnabled && this.resourceManagementEnabled == response.resourceManagementEnabled && this.resourcesCreated == response.resourcesCreated && this.pre891Data == response.pre891Data;
        }

        public int hashCode() {
            return Objects.hash(this.profilingEnabled, this.resourceManagementEnabled, this.resourcesCreated, this.pre891Data);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }
    }
}

