/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;

public final class EventsIndex {
    private static final String PREFIX = "profiling-events";
    private static final String ALL_EVENTS = "profiling-events-all";
    private static final int SAMPLING_FACTOR = 5;
    private static final int MIN_EXPONENT = 1;
    private static final int MAX_EXPONENT = 11;
    public static final EventsIndex FULL_INDEX = new EventsIndex("profiling-events-all", 1, 0);
    public static final EventsIndex MEDIUM_DOWNSAMPLED = EventsIndex.fromFactorAndExponent(5, 6);
    private final String name;
    private final int samplingFactor;
    private final int exponent;

    private EventsIndex(String name, int samplingFactor, int exponent) {
        this.name = name;
        this.samplingFactor = samplingFactor;
        this.exponent = exponent;
    }

    public String getName() {
        return this.name;
    }

    public int getExponent() {
        return this.exponent;
    }

    public double getSampleRate() {
        return Math.pow(1.0 / (double)this.samplingFactor, this.exponent);
    }

    public EventsIndex getResampledIndex(long targetSampleSize, long currentSampleSize) {
        return EventsIndex.getSampledIndex(targetSampleSize, currentSampleSize, this.getExponent());
    }

    private static EventsIndex getSampledIndex(long targetSampleSize, long sampleCountFromInitialExp, int initialExp) {
        if (sampleCountFromInitialExp == 0L) {
            return FULL_INDEX;
        }
        int exp = initialExp - (int)Math.round(Math.log((double)(targetSampleSize * 5L) / (double)sampleCountFromInitialExp) / Math.log(5.0)) + 1;
        if (exp < 1) {
            return FULL_INDEX;
        }
        if (exp > 11) {
            exp = 11;
        }
        return EventsIndex.fromFactorAndExponent(5, exp);
    }

    private static EventsIndex fromFactorAndExponent(int factor, int exp) {
        return new EventsIndex(EventsIndex.indexName(factor, exp), factor, exp);
    }

    private static String indexName(int factor, int exp) {
        return String.format(Locale.ROOT, "%s-%dpow%02d", PREFIX, factor, exp);
    }

    public static Collection<String> indexNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(ALL_EVENTS);
        for (int exp = 1; exp <= 11; ++exp) {
            names.add(EventsIndex.indexName(5, exp));
        }
        return Collections.unmodifiableSet(names);
    }
}

