/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;

public abstract class HttpResource {
    protected final String resourceOwnerName;
    protected final AtomicReference<State> state;

    protected HttpResource(String resourceOwnerName) {
        this(resourceOwnerName, true);
    }

    protected HttpResource(String resourceOwnerName, boolean dirty) {
        this.resourceOwnerName = Objects.requireNonNull(resourceOwnerName);
        this.state = new AtomicReference<State>(dirty ? State.DIRTY : State.CLEAN);
    }

    public String getResourceOwnerName() {
        return this.resourceOwnerName;
    }

    public boolean isDirty() {
        return this.state.get() != State.CLEAN;
    }

    public final void markDirty() {
        this.state.set(State.DIRTY);
    }

    public final void checkAndPublishIfDirty(RestClient client, ActionListener<Boolean> listener) {
        if (this.state.get() == State.CLEAN) {
            listener.onResponse((Object)true);
        } else {
            this.checkAndPublish(client, (ActionListener<ResourcePublishResult>)listener.map(ResourcePublishResult::isSuccess));
        }
    }

    public final void checkAndPublish(RestClient client, ActionListener<ResourcePublishResult> listener) {
        if (this.state.getAndSet(State.CHECKING) != State.CHECKING) {
            this.doCheckAndPublish(client, (ActionListener<ResourcePublishResult>)ActionListener.wrap(publishResult -> {
                this.state.compareAndSet(State.CHECKING, publishResult.success ? State.CLEAN : State.DIRTY);
                listener.onResponse(publishResult);
            }, e -> {
                this.state.compareAndSet(State.CHECKING, State.DIRTY);
                listener.onFailure(e);
            }));
        } else {
            listener.onResponse((Object)ResourcePublishResult.inProgress());
        }
    }

    protected abstract void doCheckAndPublish(RestClient var1, ActionListener<ResourcePublishResult> var2);

    static enum State {
        CLEAN,
        CHECKING,
        DIRTY;

    }

    public static class ResourcePublishResult {
        private final boolean success;
        private final String reason;
        private final State resourceState;

        public ResourcePublishResult(boolean success) {
            this(success, null, success ? State.CLEAN : State.DIRTY);
        }

        public ResourcePublishResult(boolean success, String reason, State resourceState) {
            this.success = success;
            this.reason = reason;
            this.resourceState = resourceState;
        }

        public static ResourcePublishResult ready() {
            return new ResourcePublishResult(true, null, State.CLEAN);
        }

        public static ResourcePublishResult notReady(String reason) {
            return new ResourcePublishResult(false, reason, State.DIRTY);
        }

        public static ResourcePublishResult inProgress() {
            return new ResourcePublishResult(false, null, State.CHECKING);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getReason() {
            return this.reason;
        }

        public State getResourceState() {
            return this.resourceState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourcePublishResult that = (ResourcePublishResult)o;
            return this.success == that.success && Objects.equals(this.reason, that.reason) && this.resourceState == that.resourceState;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.success, this.reason, this.resourceState});
        }

        public String toString() {
            return "ResourcePublishResult{success=" + this.success + ", reason='" + this.reason + "', resourceState=" + this.resourceState + "}";
        }
    }
}

