/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExportException
extends ElasticsearchException
implements Iterable<ExportException> {
    private final List<ExportException> exceptions = new ArrayList<ExportException>();

    public ExportException(Throwable throwable) {
        super(throwable);
    }

    public ExportException(String msg, Object ... args) {
        super(msg, args);
    }

    public ExportException(String msg, Throwable throwable, Object ... args) {
        super(msg, throwable, args);
    }

    public ExportException(StreamInput in) throws IOException {
        super(in);
        for (int i = in.readVInt(); i > 0; --i) {
            this.exceptions.add(new ExportException(in));
        }
    }

    public boolean addExportException(ExportException e) {
        return this.exceptions.add(e);
    }

    public boolean hasExportExceptions() {
        return this.exceptions.size() > 0;
    }

    @Override
    public Iterator<ExportException> iterator() {
        return this.exceptions.iterator();
    }

    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeCollection(this.exceptions);
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasExportExceptions()) {
            builder.startArray("exceptions");
            for (ExportException exception : this.exceptions) {
                builder.startObject();
                exception.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }
}

