/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.cleaner;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;

public class CleanerService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(CleanerService.class);
    private final ThreadPool threadPool;
    private final ExecutionScheduler executionScheduler;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final IndicesCleaner runnable;
    private volatile TimeValue globalRetention;

    CleanerService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, ExecutionScheduler executionScheduler) {
        this.threadPool = threadPool;
        this.executionScheduler = executionScheduler;
        this.globalRetention = (TimeValue)MonitoringField.HISTORY_DURATION.get(settings);
        this.runnable = new IndicesCleaner();
        clusterSettings.addSettingsUpdateConsumer(MonitoringField.HISTORY_DURATION, this::setGlobalRetention);
    }

    public CleanerService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this(settings, clusterSettings, threadPool, new DefaultExecutionScheduler());
    }

    protected void doStart() {
        logger.debug("starting cleaning service");
        this.threadPool.schedule((Runnable)((Object)this.runnable), this.executionScheduler.nextExecutionDelay(ZonedDateTime.now(Clock.systemDefaultZone())), this.executorName());
        logger.debug("cleaning service started");
    }

    protected void doStop() {
        logger.debug("stopping cleaning service");
        this.listeners.clear();
        logger.debug("cleaning service stopped");
    }

    protected void doClose() {
        logger.debug("closing cleaning service");
        this.runnable.cancel();
        logger.debug("cleaning service closed");
    }

    private String executorName() {
        return "generic";
    }

    public TimeValue getRetention() {
        return this.globalRetention;
    }

    public void setGlobalRetention(TimeValue globalRetention) {
        this.globalRetention = globalRetention;
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    static interface ExecutionScheduler {
        public TimeValue nextExecutionDelay(ZonedDateTime var1);
    }

    class IndicesCleaner
    extends AbstractRunnable {
        private volatile Scheduler.Cancellable cancellable;

        IndicesCleaner() {
        }

        protected void doRun() {
            if (CleanerService.this.lifecycle.stoppedOrClosed()) {
                return;
            }
            TimeValue retention = CleanerService.this.getRetention();
            logger.trace("cleaning up indices with retention [{}]", (Object)retention);
            for (Listener listener : CleanerService.this.listeners) {
                try {
                    listener.onCleanUpIndices(retention);
                }
                catch (Exception e) {
                    logger.error("listener failed to clean indices", (Throwable)e);
                }
            }
            logger.trace("done cleaning up indices");
        }

        public void onAfter() {
            if (CleanerService.this.lifecycle.stoppedOrClosed()) {
                return;
            }
            ZonedDateTime start = ZonedDateTime.now(Clock.systemUTC());
            TimeValue delay = CleanerService.this.executionScheduler.nextExecutionDelay(start);
            logger.debug("scheduling next execution in [{}] seconds", (Object)delay.seconds());
            try {
                this.cancellable = CleanerService.this.threadPool.schedule((Runnable)((Object)this), delay, CleanerService.this.executorName());
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("couldn't schedule new execution of the cleaner, executor is shutting down", (Throwable)e);
                }
                throw e;
            }
        }

        public void onFailure(Exception e) {
            logger.error("failed to clean indices", (Throwable)e);
        }

        public void cancel() {
            if (this.cancellable != null && !this.cancellable.isCancelled()) {
                this.cancellable.cancel();
            }
        }
    }

    static class DefaultExecutionScheduler
    implements ExecutionScheduler {
        DefaultExecutionScheduler() {
        }

        @Override
        public TimeValue nextExecutionDelay(ZonedDateTime now) {
            ZonedDateTime next = now.toLocalDate().atStartOfDay(now.getZone()).plusHours(1L);
            if (!next.isAfter(now)) {
                next = next.plusDays(1L);
            }
            return TimeValue.timeValueMillis((long)Duration.between(now, next).toMillis());
        }
    }

    public static interface Listener {
        public void onCleanUpIndices(TimeValue var1);
    }
}

