/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;
import org.elasticsearch.xpack.ml.utils.persistence.BatchedIterator;

public abstract class SearchAfterDocumentsIterator<T>
implements BatchedIterator<T> {
    private static final int BATCH_SIZE = 10000;
    private final OriginSettingClient client;
    private final String index;
    private final boolean trackTotalHits;
    private final AtomicLong totalHits = new AtomicLong();
    private final AtomicBoolean lastSearchReturnedResults;
    private int batchSize = 10000;

    protected SearchAfterDocumentsIterator(OriginSettingClient client, String index) {
        this(client, index, false);
    }

    protected SearchAfterDocumentsIterator(OriginSettingClient client, String index, boolean trackTotalHits) {
        this.client = Objects.requireNonNull(client);
        this.index = Objects.requireNonNull(index);
        this.trackTotalHits = trackTotalHits;
        this.lastSearchReturnedResults = new AtomicBoolean(true);
    }

    @Override
    public boolean hasNext() {
        return this.lastSearchReturnedResults.get();
    }

    @Override
    public Deque<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SearchResponse searchResponse = this.doSearch(this.searchAfterFields());
        if (this.trackTotalHits && this.totalHits.get() == 0L) {
            this.totalHits.set(searchResponse.getHits().getTotalHits().value);
        }
        return this.mapHits(searchResponse);
    }

    private SearchResponse doSearch(Object[] searchAfterValues) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(this.batchSize).query(this.getQuery()).fetchSource(this.shouldFetchSource()).sort((SortBuilder)this.sortField());
        if (this.trackTotalHits && this.totalHits.get() == 0L) {
            sourceBuilder.trackTotalHits(true);
        }
        if (searchAfterValues != null) {
            sourceBuilder.searchAfter(searchAfterValues);
        }
        for (Map.Entry<String, String> docValueFieldAndFormat : this.docValueFieldAndFormatPairs().entrySet()) {
            sourceBuilder.docValueField(docValueFieldAndFormat.getKey(), docValueFieldAndFormat.getValue());
        }
        searchRequest.source(sourceBuilder);
        return this.executeSearchRequest(searchRequest);
    }

    protected Map<String, String> docValueFieldAndFormatPairs() {
        return Collections.emptyMap();
    }

    protected SearchResponse executeSearchRequest(SearchRequest searchRequest) {
        return (SearchResponse)this.client.search(searchRequest).actionGet();
    }

    private Deque<T> mapHits(SearchResponse searchResponse) {
        SearchHit[] hits;
        ArrayDeque<T> results = new ArrayDeque<T>();
        for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
            T mapped = this.map(hit);
            if (mapped == null) continue;
            results.add(mapped);
        }
        if (hits.length < this.batchSize) {
            this.lastSearchReturnedResults.set(false);
        }
        if (hits.length > 0) {
            this.extractSearchAfterFields(hits[hits.length - 1]);
        }
        return results;
    }

    protected boolean shouldFetchSource() {
        return true;
    }

    protected abstract QueryBuilder getQuery();

    protected abstract FieldSortBuilder sortField();

    protected abstract T map(SearchHit var1);

    protected abstract Object[] searchAfterFields();

    protected abstract void extractSearchAfterFields(SearchHit var1);

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected Client client() {
        return this.client;
    }

    public long getTotalHits() {
        if (!this.trackTotalHits) {
            throw new IllegalStateException("cannot return total hits because tracking was not enabled");
        }
        return this.totalHits.get();
    }
}

