/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.List;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.xpack.core.ml.MlTasks;

public class TaskRetriever {
    public static void getDownloadTaskInfo(Client client, String modelId, boolean waitForCompletion, ActionListener<TaskInfo> listener, TimeValue timeout) {
        ((ListTasksRequestBuilder)((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"xpack/ml/model_import[n]"})).setDetailed(true).setWaitForCompletion(waitForCompletion).setDescriptions(new String[]{MlTasks.downloadModelTaskDescription((String)modelId)}).setTimeout(timeout)).execute(ActionListener.wrap(response -> {
            List tasks = response.getTasks();
            if (tasks.size() > 0) {
                listener.onResponse((Object)((TaskInfo)tasks.get(0)));
            } else {
                listener.onResponse(null);
            }
        }, e -> listener.onFailure((Exception)new ElasticsearchStatusException("Unable to retrieve task information for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId}))));
    }

    private TaskRetriever() {
    }
}

