/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutTrainedModelAliasAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID + "}/model_aliases/{model_alias}"));
    }

    public String getName() {
        return "ml_put_trained_model_alias_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String modelAlias = restRequest.param("model_alias");
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        boolean reassign = restRequest.paramAsBoolean("reassign", false);
        return channel -> client.execute((ActionType)PutTrainedModelAliasAction.INSTANCE, (ActionRequest)new PutTrainedModelAliasAction.Request(modelAlias, modelId, reassign), (ActionListener)new RestToXContentListener(channel));
    }
}

