/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class ExpiredResultsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredResultsRemover.class);
    private final AnomalyDetectionAuditor auditor;
    private final ThreadPool threadPool;

    public ExpiredResultsRemover(OriginSettingClient client, Iterator<Job> jobIterator, TaskId parentTaskId, AnomalyDetectionAuditor auditor, ThreadPool threadPool) {
        super(client, jobIterator, parentTaskId);
        this.auditor = Objects.requireNonNull(auditor);
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    @Override
    Long getRetentionDays(Job job) {
        return job.getResultsRetentionDays();
    }

    @Override
    protected void removeDataBefore(final Job job, float requestsPerSecond, long latestTimeMs, final long cutoffEpochMs, final ActionListener<Boolean> listener) {
        LOGGER.debug("Removing results of job [{}] that have a timestamp before [{}]", (Object)job.getId(), (Object)cutoffEpochMs);
        DeleteByQueryRequest request = this.createDBQRequest(job, requestsPerSecond, cutoffEpochMs);
        request.setParentTask(this.getParentTaskId());
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                try {
                    if (bulkByScrollResponse.getDeleted() > 0L) {
                        ExpiredResultsRemover.this.auditResultsWereDeleted(job.getId(), cutoffEpochMs);
                    }
                    listener.onResponse((Object)true);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Failed to remove expired results for job [" + job.getId() + "]", (Throwable)e, new Object[0])));
            }
        });
    }

    private DeleteByQueryRequest createDBQRequest(Job job, float requestsPerSec, long cutoffEpochMs) {
        TermsQueryBuilder excludeFilter = QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"model_size_stats", "model_forecast_request_stats", "model_forecast"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).lt((Object)cutoffEpochMs).format("epoch_millis")).filter((QueryBuilder)QueryBuilders.existsQuery((String)Result.RESULT_TYPE.getPreferredName())).mustNot((QueryBuilder)excludeFilter);
        DeleteByQueryRequest request = ((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId())}).setSlices(0)).setBatchSize(1000).setAbortOnVersionConflict(false)).setTimeout(DEFAULT_MAX_DURATION)).setRequestsPerSecond(requestsPerSec)).setQuery((QueryBuilder)query);
        request.getSearchRequest().source().sort("_doc");
        return request;
    }

    @Override
    void calcCutoffEpochMs(String jobId, long retentionDays, ActionListener<AbstractExpiredJobDataRemover.CutoffDetails> listener) {
        ThreadedActionListener threadedActionListener = new ThreadedActionListener((Executor)this.threadPool.executor("ml_utility"), listener);
        ExpiredResultsRemover.latestBucketTime(this.client, this.getParentTaskId(), jobId, (ActionListener<Long>)ActionListener.wrap(latestTime -> {
            if (latestTime == null) {
                threadedActionListener.onResponse(null);
            } else {
                long cutoff = latestTime - new TimeValue(retentionDays, TimeUnit.DAYS).getMillis();
                threadedActionListener.onResponse((Object)new AbstractExpiredJobDataRemover.CutoffDetails((long)latestTime, cutoff));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static void latestBucketTime(OriginSettingClient client, TaskId parentTaskId, String jobId, ActionListener<Long> listener) {
        SortBuilder sortBuilder = new FieldSortBuilder(Result.TIMESTAMP.getPreferredName()).order(SortOrder.DESC);
        TermQueryBuilder bucketType = QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"bucket");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(sortBuilder);
        searchSourceBuilder.query((QueryBuilder)bucketType);
        searchSourceBuilder.size(1);
        searchSourceBuilder.trackTotalHits(false);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(searchSourceBuilder);
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        searchRequest.setParentTask(parentTaskId);
        client.search(searchRequest, ActionListener.wrap(response -> {
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                listener.onResponse(null);
            } else {
                try (StreamInput stream = hits[0].getSourceRef().streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    Bucket bucket = (Bucket)Bucket.LENIENT_PARSER.apply(parser, null);
                    listener.onResponse((Object)bucket.getTimestamp().getTime());
                }
                catch (IOException e) {
                    listener.onFailure((Exception)new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void auditResultsWereDeleted(String jobId, long cutoffEpochMs) {
        Instant instant = Instant.ofEpochMilli(cutoffEpochMs);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneOffset.systemDefault());
        String formatted = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
        String msg = Messages.getMessage((String)"Deleted results prior to {0}", (Object[])new Object[]{formatted});
        LOGGER.debug("[{}] {}", (Object)jobId, (Object)msg);
        this.auditor.info(jobId, msg);
    }
}

