/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.security.user.InternalUsers;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredResultsRemover;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class ExpiredAnnotationsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredAnnotationsRemover.class);
    private final AnomalyDetectionAuditor auditor;
    private final ThreadPool threadPool;

    public ExpiredAnnotationsRemover(OriginSettingClient client, Iterator<Job> jobIterator, TaskId parentTaskId, AnomalyDetectionAuditor auditor, ThreadPool threadPool) {
        super(client, jobIterator, parentTaskId);
        this.auditor = Objects.requireNonNull(auditor);
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    @Override
    Long getRetentionDays(Job job) {
        return job.getResultsRetentionDays();
    }

    @Override
    protected void removeDataBefore(final Job job, float requestsPerSecond, long latestTimeMs, final long cutoffEpochMs, final ActionListener<Boolean> listener) {
        DeleteByQueryRequest request = ExpiredAnnotationsRemover.createDBQRequest(job, requestsPerSecond, cutoffEpochMs);
        request.setParentTask(this.getParentTaskId());
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                try {
                    if (bulkByScrollResponse.getDeleted() > 0L) {
                        ExpiredAnnotationsRemover.this.auditAnnotationsWereDeleted(job.getId(), cutoffEpochMs);
                    }
                    listener.onResponse((Object)true);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Failed to remove expired annotations for job [" + job.getId() + "]", (Throwable)e, new Object[0])));
            }
        });
    }

    private static DeleteByQueryRequest createDBQRequest(Job job, float requestsPerSec, long cutoffEpochMs) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Annotation.TIMESTAMP.getPreferredName()).lt((Object)cutoffEpochMs).format("epoch_millis")).filter((QueryBuilder)QueryBuilders.termQuery((String)Annotation.CREATE_USERNAME.getPreferredName(), (String)InternalUsers.XPACK_USER.principal()));
        DeleteByQueryRequest request = ((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{".ml-annotations-read"}).setSlices(0)).setBatchSize(1000).setAbortOnVersionConflict(false)).setTimeout(DEFAULT_MAX_DURATION)).setRequestsPerSecond(requestsPerSec)).setQuery((QueryBuilder)query);
        return request;
    }

    @Override
    void calcCutoffEpochMs(String jobId, long retentionDays, ActionListener<AbstractExpiredJobDataRemover.CutoffDetails> listener) {
        ThreadedActionListener threadedActionListener = new ThreadedActionListener((Executor)this.threadPool.executor("ml_utility"), listener);
        ExpiredResultsRemover.latestBucketTime(this.client, this.getParentTaskId(), jobId, (ActionListener<Long>)ActionListener.wrap(latestTime -> {
            if (latestTime == null) {
                threadedActionListener.onResponse(null);
            } else {
                long cutoff = latestTime - new TimeValue(retentionDays, TimeUnit.DAYS).getMillis();
                threadedActionListener.onResponse((Object)new AbstractExpiredJobDataRemover.CutoffDetails((long)latestTime, cutoff));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void auditAnnotationsWereDeleted(String jobId, long cutoffEpochMs) {
        Instant instant = Instant.ofEpochMilli(cutoffEpochMs);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneOffset.systemDefault());
        String formatted = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
        String msg = Messages.getMessage((String)"Deleted annotations prior to {0}", (Object[])new Object[]{formatted});
        LOGGER.debug("[{}] {}", (Object)jobId, (Object)msg);
        this.auditor.info(jobId, msg);
    }
}

