/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.inference.InferenceToXContentCompressor;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceStats;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.InferenceDefinition;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.InferenceModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.langident.LangIdentNeuralNetwork;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.TrainedModelMetadata;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.nlp.Vocabulary;
import org.elasticsearch.xpack.ml.inference.persistence.ChunkedTrainedModelRestorer;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;

public class TrainedModelProvider {
    public static final Set<String> MODELS_STORED_AS_RESOURCE = Collections.singleton("lang_ident_model_1");
    private static final ToXContent.Params FOR_INTERNAL_STORAGE_PARAMS = new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true"));
    private static final String MODEL_RESOURCE_PATH = "/org/elasticsearch/xpack/ml/inference/persistence/";
    private static final String MODEL_RESOURCE_FILE_EXT = ".json";
    private static final int COMPRESSED_MODEL_CHUNK_SIZE = 0x1000000;
    private static final int MAX_NUM_DEFINITION_DOCS = 100;
    private static final int MAX_COMPRESSED_MODEL_SIZE = 0x64000000;
    private static final Logger logger = LogManager.getLogger(TrainedModelProvider.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public TrainedModelProvider(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void storeTrainedModel(TrainedModelConfig trainedModelConfig, ActionListener<Boolean> listener) {
        this.storeTrainedModel(trainedModelConfig, listener, false);
    }

    public void storeTrainedModel(TrainedModelConfig trainedModelConfig, ActionListener<Boolean> listener, boolean allowOverwriting) {
        BytesReference definition;
        if (MODELS_STORED_AS_RESOURCE.contains(trainedModelConfig.getModelId())) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{trainedModelConfig.getModelId()}), new Object[0]));
            return;
        }
        try {
            definition = trainedModelConfig.getCompressedDefinition();
        }
        catch (IOException ex) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Unexpected IOException while serializing definition for storage for model [{}]", (Throwable)ex, (Object[])new Object[]{trainedModelConfig.getModelId()})));
            return;
        }
        TrainedModelLocation location = trainedModelConfig.getLocation();
        if (definition == null && location == null) {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Unable to store [{}]. [{}] or [{}] is required", (Object[])new Object[]{trainedModelConfig.getModelId(), TrainedModelConfig.DEFINITION.getPreferredName(), TrainedModelConfig.LOCATION.getPreferredName()}));
            return;
        }
        if (definition != null) {
            this.storeTrainedModelAndDefinition(trainedModelConfig, listener, allowOverwriting);
        } else {
            this.storeTrainedModelConfig(trainedModelConfig, listener, allowOverwriting);
        }
    }

    public void storeTrainedModelConfig(TrainedModelConfig trainedModelConfig, ActionListener<Boolean> listener) {
        this.storeTrainedModelConfig(trainedModelConfig, listener, false);
    }

    public void storeTrainedModelConfig(TrainedModelConfig trainedModelConfig, ActionListener<Boolean> listener, boolean allowOverwriting) {
        if (MODELS_STORED_AS_RESOURCE.contains(trainedModelConfig.getModelId())) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{trainedModelConfig.getModelId()}), new Object[0]));
            return;
        }
        assert (trainedModelConfig.getModelDefinition() == null);
        IndexRequest request = TrainedModelProvider.createRequest(trainedModelConfig.getModelId(), ".ml-inference-000005", (ToXContentObject)trainedModelConfig, allowOverwriting);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse((Object)true), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{trainedModelConfig.getModelId()}), new Object[0]));
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException(Messages.getMessage((String)"Failed to store trained machine learning model [{0}]", (Object[])new Object[]{trainedModelConfig.getModelId()}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            }
        }));
    }

    public void storeTrainedModelDefinitionDoc(TrainedModelDefinitionDoc trainedModelDefinitionDoc, ActionListener<Void> listener) {
        this.storeTrainedModelDefinitionDoc(trainedModelDefinitionDoc, ".ml-inference-000005", listener);
    }

    public void storeTrainedModelVocabulary(String modelId, VocabularyConfig vocabularyConfig, Vocabulary vocabulary, ActionListener<Void> listener) {
        this.storeTrainedModelVocabulary(modelId, vocabularyConfig, vocabulary, listener, false);
    }

    public void storeTrainedModelVocabulary(String modelId, VocabularyConfig vocabularyConfig, Vocabulary vocabulary, ActionListener<Void> listener, boolean allowOverwriting) {
        if (MODELS_STORED_AS_RESOURCE.contains(modelId)) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{modelId}), new Object[0]));
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)((IndexRequest)TrainedModelProvider.createRequest(VocabularyConfig.docId((String)modelId), vocabularyConfig.getIndex(), (ToXContentObject)vocabulary, allowOverwriting).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)), (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse(null), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] vocabulary already exists", (Object[])new Object[]{modelId}), new Object[0]));
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException(Messages.getMessage((String)"Failed to store trained machine learning model vocabulary [{0}]", (Object[])new Object[]{modelId}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            }
        }));
    }

    public void storeTrainedModelDefinitionDoc(TrainedModelDefinitionDoc trainedModelDefinitionDoc, String index, ActionListener<Void> listener) {
        this.storeTrainedModelDefinitionDoc(trainedModelDefinitionDoc, index, listener, false);
    }

    public void storeTrainedModelDefinitionDoc(TrainedModelDefinitionDoc trainedModelDefinitionDoc, String index, ActionListener<Void> listener, boolean allowOverwriting) {
        if (MODELS_STORED_AS_RESOURCE.contains(trainedModelDefinitionDoc.getModelId())) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{trainedModelDefinitionDoc.getModelId()}), new Object[0]));
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)TrainedModelProvider.createRequest(trainedModelDefinitionDoc.getDocId(), index, (ToXContentObject)trainedModelDefinitionDoc, allowOverwriting), (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse(null), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model chunked doc [{0}][{1}] already exists", (Object[])new Object[]{trainedModelDefinitionDoc.getModelId(), trainedModelDefinitionDoc.getDocNum()}), new Object[0]));
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException(Messages.getMessage((String)"Failed to store trained machine learning model definition [{0}][{1}]", (Object[])new Object[]{trainedModelDefinitionDoc.getModelId(), trainedModelDefinitionDoc.getDocNum()}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            }
        }));
    }

    public void storeTrainedModelMetadata(TrainedModelMetadata trainedModelMetadata, ActionListener<Void> listener) {
        this.storeTrainedModelMetadata(trainedModelMetadata, listener, false);
    }

    public void storeTrainedModelMetadata(TrainedModelMetadata trainedModelMetadata, ActionListener<Void> listener, boolean allowOverwriting) {
        if (MODELS_STORED_AS_RESOURCE.contains(trainedModelMetadata.getModelId())) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{trainedModelMetadata.getModelId()}), new Object[0]));
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)TrainedModelProvider.createRequest(trainedModelMetadata.getDocId(), ".ml-inference-000005", (ToXContentObject)trainedModelMetadata, allowOverwriting), (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse(null), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model metadata [{0}] already exists", (Object[])new Object[]{trainedModelMetadata.getModelId()}), new Object[0]));
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException(Messages.getMessage((String)"Failed to store trained machine learning model metadata [{0}]", (Object[])new Object[]{trainedModelMetadata.getModelId()}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            }
        }));
    }

    public void getTrainedModelMetadata(Collection<String> modelIds, @Nullable TaskId parentTaskId, ActionListener<Map<String, TrainedModelMetadata>> listener) {
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".ml-inference-*"}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), modelIds)).filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_metadata")))).setSize(10000).addSort("_index", SortOrder.DESC).request();
        if (parentTaskId != null) {
            searchRequest.setParentTask(parentTaskId);
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getHits().length == 0) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model metadata {0}", (Object[])new Object[]{modelIds}), new Object[0])));
                return;
            }
            HashMap<String, TrainedModelMetadata> map = new HashMap<String, TrainedModelMetadata>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String modelId = TrainedModelMetadata.modelId((String)Objects.requireNonNull(hit.getId()));
                map.putIfAbsent(modelId, this.parseMetadataLenientlyFromSource(hit.getSourceRef(), modelId));
            }
            listener.onResponse(map);
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model metadata {0}", (Object[])new Object[]{modelIds}), new Object[0])));
                return;
            }
            listener.onFailure(e);
        }));
    }

    public void refreshInferenceIndex(ActionListener<RefreshResponse> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)RefreshAction.INSTANCE, (ActionRequest)new RefreshRequest(new String[]{".ml-inference-*"}), listener);
    }

    private void storeTrainedModelAndDefinition(TrainedModelConfig trainedModelConfig, ActionListener<Boolean> listener, boolean allowOverwriting) {
        ArrayList<TrainedModelDefinitionDoc> trainedModelDefinitionDocs = new ArrayList<TrainedModelDefinitionDoc>();
        try {
            BytesReference compressedDefinition = trainedModelConfig.getCompressedDefinition();
            if (compressedDefinition.length() > 0x64000000) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Unable to store model as compressed definition of size [{}] bytes the limit is [{}] bytes", (Object[])new Object[]{compressedDefinition.length(), 0x64000000}));
                return;
            }
            List<BytesReference> chunkedDefinition = TrainedModelProvider.chunkDefinitionWithSize(compressedDefinition, 0x1000000);
            for (int i = 0; i < chunkedDefinition.size(); ++i) {
                trainedModelDefinitionDocs.add(new TrainedModelDefinitionDoc.Builder().setDocNum(i).setModelId(trainedModelConfig.getModelId()).setBinaryData(chunkedDefinition.get(i)).setCompressionVersion(1).setDefinitionLength(chunkedDefinition.get(i).length()).setEos(i == chunkedDefinition.size() - 1).build());
            }
        }
        catch (IOException ex) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Unexpected IOException while serializing definition for storage for model [{}]", (Throwable)ex, (Object[])new Object[]{trainedModelConfig.getModelId()})));
            return;
        }
        BulkRequestBuilder bulkRequest = ((BulkRequestBuilder)this.client.prepareBulk(".ml-inference-000005").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).add(TrainedModelProvider.createRequest(trainedModelConfig.getModelId(), (ToXContentObject)trainedModelConfig, allowOverwriting));
        trainedModelDefinitionDocs.forEach(defDoc -> bulkRequest.add(TrainedModelProvider.createRequest(defDoc.getDocId(), defDoc, allowOverwriting)));
        ActionListener wrappedListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                listener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"Trained machine learning model [{0}] already exists", (Object[])new Object[]{trainedModelConfig.getModelId()}), new Object[0]));
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException(Messages.getMessage((String)"Failed to store trained machine learning model [{0}]", (Object[])new Object[]{trainedModelConfig.getModelId()}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]));
            }
        });
        ActionListener bulkResponseActionListener = ActionListener.wrap(r -> {
            assert (r.getItems().length == trainedModelDefinitionDocs.size() + 1);
            if (r.getItems()[0].isFailed()) {
                logger.error(() -> "[" + trainedModelConfig.getModelId() + "] failed to store trained model config for inference", (Throwable)r.getItems()[0].getFailure().getCause());
                wrappedListener.onFailure(r.getItems()[0].getFailure().getCause());
                return;
            }
            if (r.hasFailures()) {
                Exception firstFailure = Arrays.stream(r.getItems()).filter(BulkItemResponse::isFailed).map(BulkItemResponse::getFailure).map(BulkItemResponse.Failure::getCause).findFirst().orElse(new Exception("unknown failure"));
                logger.error(() -> Strings.format((String)"[%s] failed to store trained model definition for inference", (Object[])new Object[]{trainedModelConfig.getModelId()}), (Throwable)firstFailure);
                wrappedListener.onFailure(firstFailure);
                return;
            }
            wrappedListener.onResponse((Object)true);
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkRequest.request()), (ActionListener)bulkResponseActionListener);
    }

    public void getTrainedModelForInference(String modelId, boolean unsafe, ActionListener<InferenceDefinition> listener) {
        if (MODELS_STORED_AS_RESOURCE.contains(modelId)) {
            try {
                TrainedModelConfig config = this.loadModelFromResource(modelId, false).build().ensureParsedDefinitionUnsafe(this.xContentRegistry);
                assert (config.getModelDefinition().getTrainedModel() instanceof LangIdentNeuralNetwork);
                assert (config.getModelType() == TrainedModelType.LANG_IDENT);
                listener.onResponse((Object)InferenceDefinition.builder().setPreProcessors(config.getModelDefinition().getPreProcessors()).setTrainedModel((InferenceModel)((LangIdentNeuralNetwork)config.getModelDefinition().getTrainedModel())).build());
                return;
            }
            catch (IOException | ElasticsearchException ex) {
                listener.onFailure((Exception)ex);
                return;
            }
        }
        ArrayList docs = new ArrayList();
        ChunkedTrainedModelRestorer modelRestorer = new ChunkedTrainedModelRestorer(modelId, this.client, this.client.threadPool().executor("ml_utility"), this.xContentRegistry);
        modelRestorer.restoreModelDefinition((CheckedFunction<TrainedModelDefinitionDoc, Boolean, IOException>)((CheckedFunction)docs::add), success -> {
            try {
                BytesReference compressedData = TrainedModelProvider.getDefinitionFromDocs(docs, modelId);
                InferenceDefinition inferenceDefinition = unsafe ? (InferenceDefinition)InferenceToXContentCompressor.inflateUnsafe((BytesReference)compressedData, InferenceDefinition::fromXContent, (NamedXContentRegistry)this.xContentRegistry) : (InferenceDefinition)InferenceToXContentCompressor.inflate((BytesReference)compressedData, InferenceDefinition::fromXContent, (NamedXContentRegistry)this.xContentRegistry);
                listener.onResponse((Object)inferenceDefinition);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model definition [{0}]", (Object[])new Object[]{modelId}), new Object[0])));
            }
            listener.onFailure(e);
        });
    }

    public void getTrainedModel(String modelId, GetTrainedModelsAction.Includes includes, @Nullable TaskId parentTaskId, ActionListener<TrainedModelConfig> finalListener) {
        this.getTrainedModel(modelId, Collections.emptySet(), includes, parentTaskId, finalListener);
    }

    public void getTrainedModel(String modelId, Set<String> modelAliases, GetTrainedModelsAction.Includes includes, @Nullable TaskId parentTaskId, ActionListener<TrainedModelConfig> finalListener) {
        if (MODELS_STORED_AS_RESOURCE.contains(modelId)) {
            try {
                finalListener.onResponse((Object)this.loadModelFromResource(modelId, !includes.isIncludeModelDefinition()).build());
                return;
            }
            catch (ElasticsearchException ex) {
                finalListener.onFailure((Exception)((Object)ex));
                return;
            }
        }
        ActionListener getTrainedModelListener = ActionListener.wrap(modelBuilder -> {
            modelBuilder.setModelAliases(modelAliases);
            if (!(includes.isIncludeFeatureImportanceBaseline() || includes.isIncludeTotalFeatureImportance() || includes.isIncludeHyperparameters())) {
                finalListener.onResponse((Object)modelBuilder.build());
                return;
            }
            this.getTrainedModelMetadata(Collections.singletonList(modelId), parentTaskId, (ActionListener<Map<String, TrainedModelMetadata>>)ActionListener.wrap(metadata -> {
                TrainedModelMetadata modelMetadata = (TrainedModelMetadata)metadata.get(modelId);
                if (modelMetadata != null) {
                    if (includes.isIncludeTotalFeatureImportance()) {
                        modelBuilder.setFeatureImportance(modelMetadata.getTotalFeatureImportances());
                    }
                    if (includes.isIncludeFeatureImportanceBaseline()) {
                        modelBuilder.setBaselineFeatureImportance(modelMetadata.getFeatureImportanceBaselines());
                    }
                    if (includes.isIncludeHyperparameters()) {
                        modelBuilder.setHyperparameters(modelMetadata.getHyperparameters());
                    }
                }
                finalListener.onResponse((Object)modelBuilder.build());
            }, failure -> {
                if (ExceptionsHelper.unwrapCause((Throwable)failure) instanceof ResourceNotFoundException) {
                    finalListener.onResponse((Object)modelBuilder.build());
                    return;
                }
                finalListener.onFailure(failure);
            }));
        }, arg_0 -> finalListener.onFailure(arg_0));
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{modelId}));
        SearchRequest trainedModelConfigSearch = (SearchRequest)this.client.prepareSearch(new String[]{".ml-inference-*"}).setQuery((QueryBuilder)queryBuilder).addSort("_index", SortOrder.DESC).setSize(1).request();
        if (parentTaskId != null) {
            trainedModelConfigSearch.setParentTask(parentTaskId);
        }
        ActionListener trainedModelSearchHandler = ActionListener.wrap(modelSearchResponse -> {
            TrainedModelConfig.Builder builder;
            try {
                builder = (TrainedModelConfig.Builder)TrainedModelProvider.handleHits(modelSearchResponse.getHits().getHits(), modelId, this::parseModelConfigLenientlyFromSource).get(0);
            }
            catch (ResourceNotFoundException ex) {
                getTrainedModelListener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model [{0}]", (Object[])new Object[]{modelId}), new Object[0])));
                return;
            }
            catch (Exception ex) {
                getTrainedModelListener.onFailure(ex);
                return;
            }
            if (!includes.isIncludeModelDefinition()) {
                getTrainedModelListener.onResponse((Object)builder);
                return;
            }
            if (builder.getModelType() == TrainedModelType.PYTORCH && includes.isIncludeModelDefinition()) {
                finalListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"[{}] is type [{}] and does not support retrieving the definition", (Object[])new Object[]{modelId, builder.getModelType()}));
                return;
            }
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)ChunkedTrainedModelRestorer.buildSearch(this.client, modelId, ".ml-inference-*", 100, parentTaskId), (ActionListener)ActionListener.wrap(definitionSearchResponse -> {
                try {
                    List<TrainedModelDefinitionDoc> docs = TrainedModelProvider.handleHits(definitionSearchResponse.getHits().getHits(), modelId, (bytes, resourceId) -> ChunkedTrainedModelRestorer.parseModelDefinitionDocLenientlyFromSource(bytes, resourceId, this.xContentRegistry));
                    try {
                        BytesReference compressedData = TrainedModelProvider.getDefinitionFromDocs(docs, modelId);
                        builder.setDefinitionFromBytes(compressedData);
                    }
                    catch (ElasticsearchException elasticsearchException) {
                        getTrainedModelListener.onFailure((Exception)((Object)elasticsearchException));
                        return;
                    }
                }
                catch (ResourceNotFoundException ex) {
                    getTrainedModelListener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model definition [{0}]", (Object[])new Object[]{modelId}), new Object[0])));
                    return;
                }
                catch (Exception ex) {
                    getTrainedModelListener.onFailure(ex);
                    return;
                }
                getTrainedModelListener.onResponse((Object)builder);
            }, arg_0 -> ((ActionListener)getTrainedModelListener).onFailure(arg_0)));
        }, arg_0 -> ((ActionListener)getTrainedModelListener).onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)trainedModelConfigSearch, (ActionListener)trainedModelSearchHandler);
    }

    public void getTrainedModels(Set<String> modelIds, GetTrainedModelsAction.Includes includes, boolean allowNoResources, @Nullable TaskId parentTaskId, ActionListener<List<TrainedModelConfig>> finalListener) {
        this.getTrainedModels(modelIds.stream().collect(Collectors.toMap(Function.identity(), _k -> Collections.emptySet())), includes, allowNoResources, parentTaskId, finalListener);
    }

    public void getTrainedModels(Map<String, Set<String>> modelIds, GetTrainedModelsAction.Includes includes, boolean allowNoResources, @Nullable TaskId parentTaskId, ActionListener<List<TrainedModelConfig>> finalListener) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(modelIds.keySet().toArray(new String[0])));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".ml-inference-*"}).addSort(TrainedModelConfig.MODEL_ID.getPreferredName(), SortOrder.ASC).addSort("_index", SortOrder.DESC).setQuery((QueryBuilder)queryBuilder).setSize(modelIds.size()).request();
        if (parentTaskId != null) {
            searchRequest.setParentTask(parentTaskId);
        }
        ArrayList<TrainedModelConfig.Builder> configs = new ArrayList<TrainedModelConfig.Builder>(modelIds.size());
        Set modelsInIndex = Sets.difference(modelIds.keySet(), MODELS_STORED_AS_RESOURCE);
        Set modelsAsResource = Sets.intersection(MODELS_STORED_AS_RESOURCE, modelIds.keySet());
        for (String modelId : modelsAsResource) {
            try {
                configs.add(this.loadModelFromResource(modelId, true));
            }
            catch (ElasticsearchException ex) {
                finalListener.onFailure((Exception)((Object)ex));
                return;
            }
        }
        if (modelsInIndex.isEmpty()) {
            finalListener.onResponse(configs.stream().map(TrainedModelConfig.Builder::build).sorted(Comparator.comparing(TrainedModelConfig::getModelId)).collect(Collectors.toList()));
            return;
        }
        ActionListener getTrainedModelListener = ActionListener.wrap(modelBuilders -> {
            if (!(includes.isIncludeFeatureImportanceBaseline() || includes.isIncludeTotalFeatureImportance() || includes.isIncludeHyperparameters())) {
                finalListener.onResponse(modelBuilders.stream().map(b -> b.setModelAliases((Set)modelIds.get(b.getModelId())).build()).sorted(Comparator.comparing(TrainedModelConfig::getModelId)).collect(Collectors.toList()));
                return;
            }
            this.getTrainedModelMetadata(modelIds.keySet(), parentTaskId, (ActionListener<Map<String, TrainedModelMetadata>>)ActionListener.wrap(metadata -> finalListener.onResponse(modelBuilders.stream().map(builder -> {
                TrainedModelMetadata modelMetadata = (TrainedModelMetadata)metadata.get(builder.getModelId());
                if (modelMetadata != null) {
                    if (includes.isIncludeTotalFeatureImportance()) {
                        builder.setFeatureImportance(modelMetadata.getTotalFeatureImportances());
                    }
                    if (includes.isIncludeFeatureImportanceBaseline()) {
                        builder.setBaselineFeatureImportance(modelMetadata.getFeatureImportanceBaselines());
                    }
                    if (includes.isIncludeHyperparameters()) {
                        builder.setHyperparameters(modelMetadata.getHyperparameters());
                    }
                }
                return builder.setModelAliases((Set)modelIds.get(builder.getModelId())).build();
            }).sorted(Comparator.comparing(TrainedModelConfig::getModelId)).collect(Collectors.toList())), failure -> {
                if (ExceptionsHelper.unwrapCause((Throwable)failure) instanceof ResourceNotFoundException) {
                    finalListener.onResponse(modelBuilders.stream().map(TrainedModelConfig.Builder::build).sorted(Comparator.comparing(TrainedModelConfig::getModelId)).collect(Collectors.toList()));
                    return;
                }
                finalListener.onFailure(failure);
            }));
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener configSearchHandler = ActionListener.wrap(searchResponse -> {
            HashSet<String> observedIds = new HashSet<String>(searchResponse.getHits().getHits().length + modelsAsResource.size(), 1.0f);
            observedIds.addAll(modelsAsResource);
            for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                try {
                    if (observedIds.contains(searchHit.getId())) continue;
                    configs.add(this.parseModelConfigLenientlyFromSource(searchHit.getSourceRef(), searchHit.getId()));
                    observedIds.add(searchHit.getId());
                }
                catch (IOException ex) {
                    getTrainedModelListener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Could not deserialize trained model [{0}]", (Throwable)ex, (Object[])new Object[]{searchHit.getId()})));
                    return;
                }
            }
            Set missingConfigs = Sets.difference(modelIds.keySet(), observedIds);
            if (!missingConfigs.isEmpty() && !allowNoResources) {
                getTrainedModelListener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained models {0}", (Object[])new Object[]{missingConfigs}), new Object[0])));
                return;
            }
            getTrainedModelListener.onResponse((Object)configs);
        }, arg_0 -> ((ActionListener)getTrainedModelListener).onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)configSearchHandler);
    }

    public void deleteTrainedModel(String modelId, ActionListener<Boolean> listener) {
        if (MODELS_STORED_AS_RESOURCE.contains(modelId)) {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Unable to delete model [{0}] as it is required by machine learning", (Object[])new Object[]{modelId}), (Object[])new Object[0]));
            return;
        }
        DeleteByQueryRequest request = (DeleteByQueryRequest)new DeleteByQueryRequest().setAbortOnVersionConflict(false);
        request.indices(new String[]{".ml-inference-*", MlStatsIndex.indexPattern()});
        TermQueryBuilder query = QueryBuilders.termQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), (String)modelId);
        request.setQuery((QueryBuilder)query);
        request.setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(deleteResponse -> {
            if (deleteResponse.getDeleted() == 0L) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model [{0}]", (Object[])new Object[]{modelId}), new Object[0])));
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            if (e.getClass() == IndexNotFoundException.class) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model [{0}]", (Object[])new Object[]{modelId}), new Object[0])));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    public void expandIds(String idExpression, boolean allowNoResources, PageParams pageParams, Set<String> tags, ModelAliasMetadata modelAliasMetadata, @Nullable TaskId parentTaskId, Set<String> previouslyMatchedIds, ActionListener<Tuple<Long, Map<String, Set<String>>>> idsListener) {
        Set<String> foundResourceIds;
        String[] tokens = org.elasticsearch.common.Strings.tokenizeToStringArray((String)idExpression, (String)",");
        HashSet<String> expandedIdsFromAliases = new HashSet<String>();
        if (!org.elasticsearch.common.Strings.isAllOrWildcard((String[])tokens)) {
            for (String token : tokens) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    for (String modelAlias : modelAliasMetadata.modelAliases().keySet()) {
                        if (!Regex.simpleMatch((String)token, (String)modelAlias)) continue;
                        expandedIdsFromAliases.add(modelAliasMetadata.getModelId(modelAlias));
                    }
                    continue;
                }
                if (modelAliasMetadata.getModelId(token) == null) continue;
                expandedIdsFromAliases.add(modelAliasMetadata.getModelId(token));
            }
        }
        Set<String> matchedResourceIds = this.matchedResourceIds(tokens);
        if (tags.isEmpty()) {
            foundResourceIds = matchedResourceIds;
        } else {
            foundResourceIds = new HashSet<String>();
            for (String resourceId : matchedResourceIds) {
                if (!Sets.newHashSet((Iterable)this.loadModelFromResource(resourceId, true).build().getTags()).containsAll(tags)) continue;
                foundResourceIds.add(resourceId);
            }
        }
        expandedIdsFromAliases.addAll(Arrays.asList(tokens));
        String[] tokensForQuery = expandedIdsFromAliases.toArray(new String[0]);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().sort((SortBuilder)SortBuilders.fieldSort((String)TrainedModelConfig.MODEL_ID.getPreferredName()).unmappedType("long")).query(TrainedModelProvider.buildExpandIdsQuery(tokensForQuery, tags)).from(Math.max(0, pageParams.getFrom() - foundResourceIds.size())).size(Math.min(10000, pageParams.getSize() + foundResourceIds.size()));
        sourceBuilder.trackTotalHits(true).fetchSource(TrainedModelConfig.MODEL_ID.getPreferredName(), null);
        IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)indicesOptions.allowNoIndices(), (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed(), (IndicesOptions)indicesOptions)).source(sourceBuilder);
        if (parentTaskId != null) {
            searchRequest.setParentTask(parentTaskId);
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            long totalHitCount = response.getHits().getTotalHits().value + (long)foundResourceIds.size();
            HashSet<String> foundFromDocs = new HashSet<String>();
            for (SearchHit hit : response.getHits().getHits()) {
                Object idValue;
                Map docSource = hit.getSourceAsMap();
                if (docSource == null || !((idValue = docSource.get(TrainedModelConfig.MODEL_ID.getPreferredName())) instanceof String)) continue;
                foundFromDocs.add(idValue.toString());
            }
            Map allFoundIds = TrainedModelProvider.collectIds(pageParams, foundResourceIds, foundFromDocs).stream().collect(Collectors.toMap(Function.identity(), k -> new HashSet()));
            HashSet matchedTokens = new HashSet(allFoundIds.keySet());
            modelAliasMetadata.modelAliases().forEach((alias, modelIdEntry) -> {
                String modelId = modelIdEntry.getModelId();
                if (allFoundIds.containsKey(modelId)) {
                    ((Set)allFoundIds.get(modelId)).add(alias);
                    matchedTokens.add(alias);
                }
            });
            ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, allowNoResources);
            requiredMatches.filterMatchedIds(matchedTokens);
            requiredMatches.filterMatchedIds((Collection)previouslyMatchedIds);
            if (requiredMatches.hasUnmatchedIds()) {
                idsListener.onFailure((Exception)((Object)ExceptionsHelper.missingTrainedModel((String)requiredMatches.unmatchedIdsString())));
            } else {
                idsListener.onResponse((Object)Tuple.tuple((Object)totalHitCount, allFoundIds));
            }
        }, arg_0 -> idsListener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void getInferenceStats(String[] modelIds, @Nullable TaskId parentTaskId, ActionListener<List<InferenceStats>> listener) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        Arrays.stream(modelIds).map(this::buildStatsSearchRequest).forEach(arg_0 -> ((MultiSearchRequest)multiSearchRequest).add(arg_0));
        if (multiSearchRequest.requests().isEmpty()) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        if (parentTaskId != null) {
            multiSearchRequest.setParentTask(parentTaskId);
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)multiSearchRequest, (ActionListener)ActionListener.wrap(responses -> {
            ArrayList<InferenceStats> allStats = new ArrayList<InferenceStats>(modelIds.length);
            int modelIndex = 0;
            assert (responses.getResponses().length == modelIds.length) : "mismatch between search response size and models requested";
            for (MultiSearchResponse.Item response : responses.getResponses()) {
                if (response.isFailure()) {
                    if (ExceptionsHelper.unwrapCause((Throwable)response.getFailure()) instanceof ResourceNotFoundException) {
                        ++modelIndex;
                        continue;
                    }
                    logger.error(() -> "[" + org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])modelIds) + "] search failed for models", (Throwable)response.getFailure());
                    listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Searching for stats for models [{}] failed", (Throwable)response.getFailure(), (Object[])new Object[]{org.elasticsearch.common.Strings.arrayToCommaDelimitedString((Object[])modelIds)})));
                    return;
                }
                try {
                    InferenceStats inferenceStats = this.handleMultiNodeStatsResponse(response.getResponse(), modelIds[modelIndex++]);
                    if (inferenceStats == null) continue;
                    allStats.add(inferenceStats);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return;
                }
            }
            listener.onResponse(allStats);
        }, e -> {
            Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
            if (unwrapped instanceof ResourceNotFoundException) {
                listener.onResponse(Collections.emptyList());
                return;
            }
            listener.onFailure((Exception)unwrapped);
        }), (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1));
    }

    private SearchRequest buildStatsSearchRequest(String modelId) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceStats.MODEL_ID.getPreferredName(), (String)modelId)).filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceStats.TYPE.getPreferredName(), (String)"inference_stats"));
        return new SearchRequest(new String[]{MlStatsIndex.indexPattern()}).indicesOptions(IndicesOptions.lenientExpandOpen()).allowPartialSearchResults(false).source(SearchSourceBuilder.searchSource().size(0).aggregation((AggregationBuilder)AggregationBuilders.sum((String)InferenceStats.FAILURE_COUNT.getPreferredName()).field(InferenceStats.FAILURE_COUNT.getPreferredName())).aggregation((AggregationBuilder)AggregationBuilders.sum((String)InferenceStats.MISSING_ALL_FIELDS_COUNT.getPreferredName()).field(InferenceStats.MISSING_ALL_FIELDS_COUNT.getPreferredName())).aggregation((AggregationBuilder)AggregationBuilders.sum((String)InferenceStats.INFERENCE_COUNT.getPreferredName()).field(InferenceStats.INFERENCE_COUNT.getPreferredName())).aggregation((AggregationBuilder)AggregationBuilders.sum((String)InferenceStats.CACHE_MISS_COUNT.getPreferredName()).field(InferenceStats.CACHE_MISS_COUNT.getPreferredName())).aggregation((AggregationBuilder)AggregationBuilders.max((String)InferenceStats.TIMESTAMP.getPreferredName()).field(InferenceStats.TIMESTAMP.getPreferredName())).query((QueryBuilder)queryBuilder));
    }

    private InferenceStats handleMultiNodeStatsResponse(SearchResponse response, String modelId) {
        if (response.getAggregations() == null) {
            logger.trace(() -> "[" + modelId + "] no previously stored stats found");
            return null;
        }
        Sum failures = (Sum)response.getAggregations().get(InferenceStats.FAILURE_COUNT.getPreferredName());
        Sum missing = (Sum)response.getAggregations().get(InferenceStats.MISSING_ALL_FIELDS_COUNT.getPreferredName());
        Sum cacheMiss = (Sum)response.getAggregations().get(InferenceStats.CACHE_MISS_COUNT.getPreferredName());
        Sum count = (Sum)response.getAggregations().get(InferenceStats.INFERENCE_COUNT.getPreferredName());
        Max timeStamp = (Max)response.getAggregations().get(InferenceStats.TIMESTAMP.getPreferredName());
        return new InferenceStats(missing == null ? 0L : Double.valueOf(missing.value()).longValue(), count == null ? 0L : Double.valueOf(count.value()).longValue(), failures == null ? 0L : Double.valueOf(failures.value()).longValue(), cacheMiss == null ? 0L : Double.valueOf(cacheMiss.value()).longValue(), modelId, null, timeStamp == null || !Numbers.isValidDouble((double)timeStamp.value()) ? Instant.now() : Instant.ofEpochMilli(Double.valueOf(timeStamp.value()).longValue()));
    }

    static Set<String> collectIds(PageParams pageParams, Set<String> foundFromResources, Set<String> foundFromDocs) {
        if (foundFromResources.isEmpty()) {
            return foundFromDocs;
        }
        TreeSet<String> allFoundIds = new TreeSet<String>(foundFromDocs);
        allFoundIds.addAll(foundFromResources);
        if (pageParams.getFrom() > 0) {
            int numToTrimFromFront = Math.min(foundFromResources.size(), pageParams.getFrom());
            for (int i = 0; i < numToTrimFromFront; ++i) {
                allFoundIds.remove(allFoundIds.first());
            }
        }
        while (allFoundIds.size() > pageParams.getSize()) {
            allFoundIds.remove(allFoundIds.last());
        }
        return allFoundIds;
    }

    static QueryBuilder buildExpandIdsQuery(String[] tokens, Collection<String> tags) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().filter(TrainedModelProvider.buildQueryIdExpressionQuery(tokens, TrainedModelConfig.MODEL_ID.getPreferredName()));
        for (String tag : tags) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.TAGS.getPreferredName(), (String)tag));
        }
        return QueryBuilders.constantScoreQuery((QueryBuilder)boolQueryBuilder);
    }

    TrainedModelConfig.Builder loadModelFromResource(String modelId, boolean nullOutDefinition) {
        TrainedModelConfig.Builder builder;
        block10: {
            URL resource = this.getClass().getResource(MODEL_RESOURCE_PATH + modelId + MODEL_RESOURCE_FILE_EXT);
            if (resource == null) {
                logger.error("[{}] presumed stored as a resource but not found", (Object)modelId);
                throw new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model [{0}]", (Object[])new Object[]{modelId}), new Object[0]);
            }
            XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), this.getClass().getResourceAsStream(MODEL_RESOURCE_PATH + modelId + MODEL_RESOURCE_FILE_EXT));
            try {
                TrainedModelConfig.Builder builder2 = TrainedModelConfig.fromXContent((XContentParser)parser, (boolean)true);
                if (nullOutDefinition) {
                    builder2.clearDefinition();
                }
                builder = builder2;
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioEx) {
                    logger.error(() -> "[" + modelId + "] failed to parse model definition", (Throwable)ioEx);
                    throw ExceptionsHelper.serverError((String)"Could not deserialize trained model [{0}]", (Throwable)ioEx, (Object[])new Object[]{modelId});
                }
            }
            parser.close();
        }
        return builder;
    }

    private static QueryBuilder buildQueryIdExpressionQuery(String[] tokens, String resourceIdField) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_config"));
        if (org.elasticsearch.common.Strings.isAllOrWildcard((String[])tokens)) {
            return boolQuery;
        }
        BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
        ArrayList<String> terms = new ArrayList<String>();
        for (String token : tokens) {
            if (Regex.isSimpleMatchPattern((String)token)) {
                shouldQueries.should((QueryBuilder)QueryBuilders.wildcardQuery((String)resourceIdField, (String)token));
                continue;
            }
            terms.add(token);
        }
        if (!terms.isEmpty()) {
            shouldQueries.should((QueryBuilder)QueryBuilders.termsQuery((String)resourceIdField, terms));
        }
        if (!shouldQueries.should().isEmpty()) {
            boolQuery.filter((QueryBuilder)shouldQueries);
        }
        return boolQuery;
    }

    private Set<String> matchedResourceIds(String[] tokens) {
        if (org.elasticsearch.common.Strings.isAllOrWildcard((String[])tokens)) {
            return MODELS_STORED_AS_RESOURCE;
        }
        HashSet<String> matchedModels = new HashSet<String>();
        for (String token : tokens) {
            if (Regex.isSimpleMatchPattern((String)token)) {
                for (String modelId : MODELS_STORED_AS_RESOURCE) {
                    if (!Regex.simpleMatch((String)token, (String)modelId)) continue;
                    matchedModels.add(modelId);
                }
                continue;
            }
            if (!MODELS_STORED_AS_RESOURCE.contains(token)) continue;
            matchedModels.add(token);
        }
        return Collections.unmodifiableSet(matchedModels);
    }

    private static <T> List<T> handleHits(SearchHit[] hits, String resourceId, CheckedBiFunction<BytesReference, String, T, Exception> parseLeniently) throws Exception {
        if (hits.length == 0) {
            throw new ResourceNotFoundException(resourceId, new Object[0]);
        }
        ArrayList<Object> results = new ArrayList<Object>(hits.length);
        String initialIndex = hits[0].getIndex();
        for (SearchHit hit : hits) {
            if (!hit.getIndex().equals(initialIndex)) continue;
            results.add(parseLeniently.apply((Object)hit.getSourceRef(), (Object)resourceId));
        }
        return results;
    }

    static BytesReference getDefinitionFromDocs(List<TrainedModelDefinitionDoc> docs, String modelId) throws ElasticsearchException {
        BytesArray bytes;
        Object object = bytes = docs.size() == 1 ? docs.get(0).getBinaryData() : new BytesArray(CompositeBytesReference.of((BytesReference[])((BytesReference[])docs.stream().map(TrainedModelDefinitionDoc::getBinaryData).toArray(BytesReference[]::new))).toBytesRef());
        if (docs.get(0).getTotalDefinitionLength() != null && (long)bytes.length() != docs.get(0).getTotalDefinitionLength()) {
            throw ExceptionsHelper.serverError((String)Messages.getMessage((String)"Model definition truncated. Unable to deserialize trained model definition [{0}]", (Object[])new Object[]{modelId}));
        }
        TrainedModelDefinitionDoc lastDoc = docs.get(docs.size() - 1);
        if (!lastDoc.isEos() || lastDoc.getDocNum() != docs.size() - 1) {
            throw ExceptionsHelper.serverError((String)Messages.getMessage((String)"Model definition truncated. Unable to deserialize trained model definition [{0}]", (Object[])new Object[]{modelId}));
        }
        return bytes;
    }

    public static List<BytesReference> chunkDefinitionWithSize(BytesReference definition, int chunkSize) {
        ArrayList<BytesReference> chunks = new ArrayList<BytesReference>((int)Math.ceil((double)definition.length() / (double)chunkSize));
        for (int i = 0; i < definition.length(); i += chunkSize) {
            BytesReference chunk = definition.slice(i, Math.min(chunkSize, definition.length() - i));
            chunks.add(chunk);
        }
        return chunks;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private TrainedModelConfig.Builder parseModelConfigLenientlyFromSource(BytesReference source, String modelId) throws IOException {
        try (StreamInput stream = source.streamInput();){
            TrainedModelConfig.Builder builder;
            block15: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (InputStream)stream);
                try {
                    TrainedModelConfig.Builder builder2 = TrainedModelConfig.fromXContent((XContentParser)parser, (boolean)true);
                    if (builder2.getModelType() == null) {
                        builder2.setModelType(TrainedModelType.TREE_ENSEMBLE);
                    }
                    builder = builder2;
                    if (parser == null) break block15;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return builder;
        }
        catch (IOException e) {
            logger.error(() -> "[" + modelId + "] failed to parse model", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private TrainedModelMetadata parseMetadataLenientlyFromSource(BytesReference source, String modelId) throws IOException {
        try (StreamInput stream = source.streamInput();){
            TrainedModelMetadata trainedModelMetadata;
            block14: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (InputStream)stream);
                try {
                    trainedModelMetadata = TrainedModelMetadata.fromXContent((XContentParser)parser, (boolean)true);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return trainedModelMetadata;
        }
        catch (IOException e) {
            logger.error(() -> "[" + modelId + "] failed to parse model metadata", (Throwable)e);
            throw e;
        }
    }

    private static IndexRequest createRequest(String docId, String index, ToXContentObject body, boolean allowOverwriting) {
        return TrainedModelProvider.createRequest(new IndexRequest(index), docId, body, allowOverwriting);
    }

    private static IndexRequest createRequest(String docId, ToXContentObject body, boolean allowOverwriting) {
        return TrainedModelProvider.createRequest(new IndexRequest(), docId, body, allowOverwriting);
    }

    private static IndexRequest createRequest(IndexRequest request, String docId, ToXContentObject body, boolean allowOverwriting) {
        IndexRequest indexRequest;
        block8: {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                XContentBuilder source = body.toXContent(builder, FOR_INTERNAL_STORAGE_PARAMS);
                DocWriteRequest.OpType operation = allowOverwriting ? DocWriteRequest.OpType.INDEX : DocWriteRequest.OpType.CREATE;
                indexRequest = request.opType(operation).id(docId).source(source);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.serverError((String)("Unexpected serialization exception for [" + docId + "]"), (Throwable)ex);
                }
            }
            builder.close();
        }
        return indexRequest;
    }
}

