/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.steps;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.steps.AbstractDataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class AnalysisStep
extends AbstractDataFrameAnalyticsStep {
    private final AnalyticsProcessManager processManager;

    public AnalysisStep(NodeClient client, DataFrameAnalyticsTask task, DataFrameAnalyticsAuditor auditor, DataFrameAnalyticsConfig config, AnalyticsProcessManager processManager) {
        super(client, task, auditor, config);
        this.processManager = Objects.requireNonNull(processManager);
    }

    @Override
    public DataFrameAnalyticsStep.Name name() {
        return DataFrameAnalyticsStep.Name.ANALYSIS;
    }

    @Override
    public void cancel(String reason, TimeValue timeout) {
        this.processManager.stop(this.task);
    }

    @Override
    public void updateProgress(ActionListener<Void> listener) {
        listener.onResponse(null);
    }

    @Override
    protected void doExecute(ActionListener<StepResponse> listener) {
        this.task.getStatsHolder().getDataCountsTracker().reset();
        ParentTaskAssigningClient parentTaskClient = this.parentTaskClient();
        ActionListener dataExtractorFactoryListener = ActionListener.wrap(dataExtractorFactory -> this.processManager.runJob(this.task, this.config, (DataFrameDataExtractorFactory)dataExtractorFactory, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener refreshListener = ActionListener.wrap(refreshResponse -> DataFrameDataExtractorFactory.createForDestinationIndex((Client)parentTaskClient, this.config, (ActionListener<DataFrameDataExtractorFactory>)dataExtractorFactoryListener), arg_0 -> ((ActionListener)dataExtractorFactoryListener).onFailure(arg_0));
        this.refreshDestAsync((ActionListener<RefreshResponse>)refreshListener);
    }
}

