/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsDest;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;

public final class DestinationIndex {
    private static final Logger logger = LogManager.getLogger(DestinationIndex.class);
    public static final String INCREMENTAL_ID = "ml__incremental_id";
    public static final String IS_TRAINING = "is_training";
    static final String CREATION_DATE_MILLIS = "creation_date_in_millis";
    static final String VERSION = "version";
    static final String CREATED = "created";
    static final String CREATED_BY = "created_by";
    static final String ANALYTICS = "analytics";
    private static final String PROPERTIES = "properties";
    private static final String META = "_meta";
    private static final String RUNTIME = "runtime";
    private static final String DFA_CREATOR = "data-frame-analytics";
    private static final String[] PRESERVED_SETTINGS = new String[]{"index.number_of_shards", "index.number_of_replicas", "index.analysis.*", "index.similarity.*", "index.mapping.*"};
    public static final Version MIN_COMPATIBLE_VERSION = StartDataFrameAnalyticsAction.TaskParams.VERSION_DESTINATION_INDEX_MAPPINGS_CHANGED;

    private DestinationIndex() {
    }

    public static void createDestinationIndex(Client client, Clock clock, DataFrameAnalyticsConfig analyticsConfig, ActionListener<CreateIndexResponse> listener) {
        ActionListener createIndexRequestListener = ActionListener.wrap(createIndexRequest -> ClientHelper.executeWithHeadersAsync((Map)analyticsConfig.getHeaders(), (String)"ml", (Client)client, (ActionType)CreateIndexAction.INSTANCE, (ActionRequest)createIndexRequest, (ActionListener)listener), arg_0 -> listener.onFailure(arg_0));
        DestinationIndex.prepareCreateIndexRequest(client, clock, analyticsConfig, (ActionListener<CreateIndexRequest>)createIndexRequestListener);
    }

    private static void prepareCreateIndexRequest(Client client, Clock clock, DataFrameAnalyticsConfig config, ActionListener<CreateIndexRequest> listener) {
        AtomicReference settingsHolder = new AtomicReference();
        AtomicReference mappingsHolder = new AtomicReference();
        ActionListener fieldCapabilitiesListener = ActionListener.wrap(fieldCapabilitiesResponse -> listener.onResponse((Object)DestinationIndex.createIndexRequest(clock, config, (Settings)settingsHolder.get(), (MappingMetadata)mappingsHolder.get(), fieldCapabilitiesResponse)), arg_0 -> listener.onFailure(arg_0));
        ActionListener mappingsListener = ActionListener.wrap(mappings -> {
            mappingsHolder.set(mappings);
            DestinationIndex.getFieldCapsForRequiredFields(client, config, (ActionListener<FieldCapabilitiesResponse>)fieldCapabilitiesListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener settingsListener = ActionListener.wrap(settings -> {
            settingsHolder.set(settings);
            MappingsMerger.mergeMappings(client, config.getHeaders(), config.getSource(), (ActionListener<MappingMetadata>)mappingsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getSettingsResponseListener = ActionListener.wrap(settingsResponse -> settingsListener.onResponse((Object)DestinationIndex.settings(settingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(config.getSource().getIndex()).indicesOptions(IndicesOptions.lenientExpandOpen()).names(PRESERVED_SETTINGS);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, (ActionListener)getSettingsResponseListener);
    }

    private static void getFieldCapsForRequiredFields(Client client, DataFrameAnalyticsConfig config, ActionListener<FieldCapabilitiesResponse> listener) {
        List requiredFields = config.getAnalysis().getRequiredFields();
        if (requiredFields.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest().indices(config.getSource().getIndex()).fields((String[])requiredFields.stream().map(RequiredField::getName).toArray(String[]::new)).runtimeFields(config.getSource().getRuntimeMappings());
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, listener);
    }

    private static CreateIndexRequest createIndexRequest(Clock clock, DataFrameAnalyticsConfig config, Settings settings, MappingMetadata mappings, FieldCapabilitiesResponse fieldCapabilitiesResponse) {
        String destinationIndex = config.getDest().getIndex();
        Map mappingsAsMap = mappings.sourceAsMap();
        Map properties = DestinationIndex.getOrPutDefault(mappingsAsMap, PROPERTIES, HashMap::new);
        DestinationIndex.checkResultsFieldIsNotPresentInProperties(config, properties);
        properties.putAll(DestinationIndex.createAdditionalMappings(config, fieldCapabilitiesResponse));
        Map metadata = DestinationIndex.getOrPutDefault(mappingsAsMap, META, HashMap::new);
        metadata.putAll(DestinationIndex.createMetadata(config.getId(), clock, Version.CURRENT));
        if (!config.getSource().getRuntimeMappings().isEmpty()) {
            Map runtimeMappings = DestinationIndex.getOrPutDefault(mappingsAsMap, RUNTIME, HashMap::new);
            runtimeMappings.putAll(config.getSource().getRuntimeMappings());
        }
        return new CreateIndexRequest(destinationIndex, settings).mapping(mappingsAsMap);
    }

    private static Settings settings(GetSettingsResponse settingsResponse) {
        String[] settingsIndexKeys = new String[]{"index.number_of_shards", "index.number_of_replicas", MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING.getKey(), MapperService.INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING.getKey(), MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey(), MapperService.INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING.getKey(), MapperService.INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING.getKey()};
        Settings.Builder settingsBuilder = Settings.builder();
        for (String key : settingsIndexKeys) {
            Long value = DestinationIndex.findMaxSettingValue(settingsResponse, key);
            if (value == null) continue;
            settingsBuilder.put(key, value.longValue());
        }
        HashMap<String, Tuple<String, Settings>> mergedSettings = new HashMap<String, Tuple<String, Settings>>();
        DestinationIndex.mergeSimilaritySettings(settingsResponse, mergedSettings);
        DestinationIndex.mergeAnalysisSettings(settingsResponse, mergedSettings);
        for (String settingsKey : Arrays.asList("index.similarity", "index.analysis.filter", "index.analysis.analyzer")) {
            for (Map.Entry mergedSetting : mergedSettings.entrySet()) {
                String index = (String)((Tuple)mergedSetting.getValue()).v1();
                Set settingsKeys = ((Settings)settingsResponse.getIndexToSettings().get(index)).getAsSettings(settingsKey).keySet();
                for (String key : settingsKeys) {
                    settingsBuilder = settingsBuilder.copy(settingsKey + "." + key, (Settings)settingsResponse.getIndexToSettings().get(index));
                }
            }
        }
        return settingsBuilder.build();
    }

    private static void mergeSimilaritySettings(GetSettingsResponse settingsResponse, Map<String, Tuple<String, Settings>> mergedSettings) {
        String settingsKey = "index.similarity";
        for (Map.Entry settingsEntry : settingsResponse.getIndexToSettings().entrySet()) {
            Settings settings = ((Settings)settingsEntry.getValue()).getAsSettings(settingsKey);
            if (settings.isEmpty()) continue;
            DestinationIndex.mergeSettings(settingsKey, (String)settingsEntry.getKey(), settings, mergedSettings);
        }
    }

    private static void mergeAnalysisSettings(GetSettingsResponse settingsResponse, Map<String, Tuple<String, Settings>> mergedSettings) {
        for (String settingsKey : Arrays.asList("index.analysis.filter", "index.analysis.analyzer")) {
            for (Map.Entry settingsEntry : settingsResponse.getIndexToSettings().entrySet()) {
                Settings settings = ((Settings)settingsEntry.getValue()).getAsSettings(settingsKey);
                if (settings.isEmpty()) continue;
                for (String name : settings.names()) {
                    Settings setting = settings.getAsSettings(name);
                    String fullName = settingsKey + "." + name;
                    DestinationIndex.mergeSettings(fullName, (String)settingsEntry.getKey(), setting, mergedSettings);
                }
            }
        }
    }

    private static void mergeSettings(String key, String index, Settings setting, Map<String, Tuple<String, Settings>> mergedSettings) {
        if (!mergedSettings.containsKey(key)) {
            mergedSettings.put(key, (Tuple<String, Settings>)new Tuple((Object)index, (Object)setting));
        } else {
            Settings mergedSetting = (Settings)mergedSettings.get(key).v2();
            if (!mergedSetting.equals((Object)setting)) {
                throw ExceptionsHelper.badRequestException((String)("cannot merge settings because of differences for " + key + "; specified as [{}] in index [{}]; specified as [{}] in index [{}]"), (Object[])new Object[]{mergedSettings.get(key).v2(), mergedSettings.get(key).v1(), setting.toString(), index});
            }
        }
    }

    @Nullable
    private static Long findMaxSettingValue(GetSettingsResponse settingsResponse, String settingKey) {
        Long maxValue = null;
        for (Settings settings : settingsResponse.getIndexToSettings().values()) {
            Long indexValue = settings.getAsLong(settingKey, null);
            if (indexValue == null) continue;
            maxValue = maxValue == null ? indexValue : Math.max(indexValue, maxValue);
        }
        return maxValue;
    }

    private static Map<String, Object> createAdditionalMappings(DataFrameAnalyticsConfig config, FieldCapabilitiesResponse fieldCapabilitiesResponse) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(INCREMENTAL_ID, Map.of("type", NumberFieldMapper.NumberType.LONG.typeName()));
        properties.putAll(config.getAnalysis().getResultMappings(config.getDest().getResultsField(), fieldCapabilitiesResponse));
        return properties;
    }

    static Map<String, Object> createMetadata(String analyticsId, Clock clock, Version version) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(CREATION_DATE_MILLIS, clock.millis());
        metadata.put(CREATED_BY, DFA_CREATOR);
        metadata.put(VERSION, Map.of(CREATED, version.toString()));
        metadata.put(ANALYTICS, analyticsId);
        return metadata;
    }

    private static <K, V> V getOrPutDefault(Map<K, Object> map, K key, Supplier<V> valueSupplier) {
        Object value = map.get(key);
        if (value == null) {
            value = valueSupplier.get();
            map.put(key, value);
        }
        return (V)value;
    }

    public static void updateMappingsToDestIndex(Client client, DataFrameAnalyticsConfig config, GetIndexResponse getIndexResponse, ActionListener<AcknowledgedResponse> listener) {
        assert (getIndexResponse.indices().length == 1);
        Map destMappingsAsMap = ((MappingMetadata)getIndexResponse.mappings().values().iterator().next()).sourceAsMap();
        Map<String, Object> destPropertiesAsMap = destMappingsAsMap.getOrDefault(PROPERTIES, Collections.emptyMap());
        DestinationIndex.checkResultsFieldIsNotPresentInProperties(config, destPropertiesAsMap);
        ActionListener fieldCapabilitiesListener = ActionListener.wrap(fieldCapabilitiesResponse -> {
            HashMap<String, Map> addedMappings = new HashMap<String, Map>();
            addedMappings.put(PROPERTIES, DestinationIndex.createAdditionalMappings(config, fieldCapabilitiesResponse));
            if (!config.getSource().getRuntimeMappings().isEmpty()) {
                addedMappings.put(RUNTIME, config.getSource().getRuntimeMappings());
            }
            PutMappingRequest putMappingRequest = new PutMappingRequest(getIndexResponse.indices()).source(addedMappings);
            ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)PutMappingAction.INSTANCE, (ActionRequest)putMappingRequest, (ActionListener)listener);
        }, arg_0 -> listener.onFailure(arg_0));
        DestinationIndex.getFieldCapsForRequiredFields(client, config, (ActionListener<FieldCapabilitiesResponse>)fieldCapabilitiesListener);
    }

    private static void checkResultsFieldIsNotPresentInProperties(DataFrameAnalyticsConfig config, Map<String, Object> properties) {
        String resultsField = config.getDest().getResultsField();
        if (properties.containsKey(resultsField)) {
            throw ExceptionsHelper.badRequestException((String)"A field that matches the {}.{} [{}] already exists; please set a different {}", (Object[])new Object[]{DataFrameAnalyticsConfig.DEST.getPreferredName(), DataFrameAnalyticsDest.RESULTS_FIELD.getPreferredName(), resultsField, DataFrameAnalyticsDest.RESULTS_FIELD.getPreferredName()});
        }
    }

    public static Metadata readMetadata(String jobId, MappingMetadata mappingMetadata) {
        Map mappings = mappingMetadata.getSourceAsMap();
        Map meta = (Map)mappings.get(META);
        if (meta == null || !DFA_CREATOR.equals(meta.get(CREATED_BY))) {
            return new NoMetadata();
        }
        return new DestMetadata(DestinationIndex.getVersion(jobId, meta));
    }

    private static Version getVersion(String jobId, Map<String, Object> meta) {
        try {
            Map version = (Map)meta.get(VERSION);
            String createdVersionString = (String)version.get(CREATED);
            return Version.fromString((String)createdVersionString);
        }
        catch (Exception e) {
            logger.error(() -> "[" + jobId + "] Could not retrieve destination index version", (Throwable)e);
            return null;
        }
    }

    private static class NoMetadata
    implements Metadata {
        private NoMetadata() {
        }

        @Override
        public boolean hasMetadata() {
            return false;
        }

        @Override
        public boolean isCompatible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DestMetadata
    implements Metadata {
        private final Version version;

        private DestMetadata(Version version) {
            this.version = version;
        }

        @Override
        public boolean hasMetadata() {
            return true;
        }

        @Override
        public boolean isCompatible() {
            return this.version == null ? false : this.version.onOrAfter((VersionId)MIN_COMPATIBLE_VERSION);
        }

        @Override
        public String getVersion() {
            return this.version == null ? "unknown" : this.version.toString();
        }
    }

    public static interface Metadata {
        public boolean hasMetadata();

        public boolean isCompatible();

        public String getVersion();
    }
}

