/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregatedSearchRequestBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.CompositeAggregationDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.CompositeAggregationDataExtractorContext;

public class CompositeAggregationDataExtractorFactory
implements DataExtractorFactory {
    private final Client client;
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private final String compositeAggName;
    private final Collection<AggregationBuilder> subAggs;
    private final Collection<PipelineAggregationBuilder> subPipelineAggs;
    private final String dateHistogramGroupSourceName;
    private final AggregatedSearchRequestBuilder requestBuilder;
    private final int numBuckets;
    private final List<CompositeValuesSourceBuilder<?>> compositeValuesSourceBuilders;
    private final QueryBuilder parsedQuery;

    public CompositeAggregationDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, Job job, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter, AggregatedSearchRequestBuilder requestBuilder) {
        this.client = Objects.requireNonNull(client);
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.parsedQuery = datafeedConfig.getParsedQuery(xContentRegistry);
        AggregationBuilder aggregationBuilder = ExtractorUtils.getHistogramAggregation((Collection)datafeedConfig.getParsedAggregations(xContentRegistry).getAggregatorFactories());
        if (!(aggregationBuilder instanceof CompositeAggregationBuilder)) {
            throw new IllegalArgumentException("top level aggregation must be a composite agg [" + aggregationBuilder.getName() + "] is a [" + aggregationBuilder.getType() + "]");
        }
        CompositeAggregationBuilder compositeAggregationBuilder = (CompositeAggregationBuilder)aggregationBuilder;
        this.numBuckets = compositeAggregationBuilder.size();
        this.compositeAggName = compositeAggregationBuilder.getName();
        this.subAggs = compositeAggregationBuilder.getSubAggregations();
        this.subPipelineAggs = compositeAggregationBuilder.getPipelineAggregations();
        this.compositeValuesSourceBuilders = new ArrayList(compositeAggregationBuilder.sources().size());
        ArrayList<CompositeValuesSourceBuilder> others = new ArrayList<CompositeValuesSourceBuilder>(compositeAggregationBuilder.sources().size() - 1);
        String dateHistoGroupName = null;
        for (CompositeValuesSourceBuilder sourceBuilder : compositeAggregationBuilder.sources()) {
            if (sourceBuilder instanceof DateHistogramValuesSourceBuilder) {
                this.compositeValuesSourceBuilders.add(sourceBuilder);
                dateHistoGroupName = sourceBuilder.name();
                continue;
            }
            others.add(sourceBuilder);
        }
        this.dateHistogramGroupSourceName = dateHistoGroupName;
        this.compositeValuesSourceBuilders.addAll(others);
        this.requestBuilder = requestBuilder;
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        return this.buildNewExtractor(start, end, this.parsedQuery);
    }

    @Override
    public DataExtractor newExtractor(long start, long end, QueryBuilder queryBuilder) {
        return this.buildNewExtractor(start, end, (QueryBuilder)QueryBuilders.boolQuery().filter(this.parsedQuery).filter(queryBuilder));
    }

    private DataExtractor buildNewExtractor(long start, long end, QueryBuilder queryBuilder) {
        CompositeAggregationBuilder compositeAggregationBuilder = new CompositeAggregationBuilder(this.compositeAggName, this.compositeValuesSourceBuilders);
        compositeAggregationBuilder.size(this.numBuckets);
        this.subAggs.forEach(arg_0 -> ((CompositeAggregationBuilder)compositeAggregationBuilder).subAggregation(arg_0));
        this.subPipelineAggs.forEach(arg_0 -> ((CompositeAggregationBuilder)compositeAggregationBuilder).subAggregation(arg_0));
        long histogramInterval = ExtractorUtils.getHistogramIntervalMillis((AggregationBuilder)compositeAggregationBuilder);
        CompositeAggregationDataExtractorContext dataExtractorContext = new CompositeAggregationDataExtractorContext(this.job.getId(), this.job.getDataDescription().getTimeField(), this.job.getAnalysisConfig().analysisFields(), this.datafeedConfig.getIndices(), queryBuilder, compositeAggregationBuilder, this.dateHistogramGroupSourceName, Intervals.alignToCeil((long)start, (long)histogramInterval), Intervals.alignToFloor((long)end, (long)histogramInterval), this.job.getAnalysisConfig().getSummaryCountFieldName().equals("doc_count"), this.datafeedConfig.getHeaders(), this.datafeedConfig.getIndicesOptions(), this.datafeedConfig.getRuntimeMappings());
        return new CompositeAggregationDataExtractor(compositeAggregationBuilder, this.client, dataExtractorContext, this.timingStatsReporter, this.requestBuilder);
    }
}

