/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.LongSupplier;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingDeciderService;

class ScaleTimer {
    private static final long NO_SCALE_DOWN_POSSIBLE = -1L;
    private final LongSupplier timeSupplier;
    private volatile long previousScaleTimeMs;
    private volatile long lastScaleTimeMs;
    private volatile long scaleDownDetected;

    ScaleTimer(LongSupplier timeSupplier) {
        this.timeSupplier = Objects.requireNonNull(timeSupplier);
        this.scaleDownDetected = -1L;
    }

    void markScale() {
        this.previousScaleTimeMs = this.lastScaleTimeMs;
        this.lastScaleTimeMs = this.timeSupplier.getAsLong();
    }

    OptionalLong lastScaleToScaleIntervalMillis() {
        if (this.previousScaleTimeMs > 0L && this.lastScaleTimeMs > this.previousScaleTimeMs) {
            return OptionalLong.of(this.lastScaleTimeMs - this.previousScaleTimeMs);
        }
        return OptionalLong.empty();
    }

    long markDownScaleAndGetMillisLeftFromDelay(Settings configuration) {
        assert (this.lastScaleTimeMs > 0L) : "marked downscale without ever marking scale";
        long now = this.timeSupplier.getAsLong();
        if (this.newScaleDownCheck()) {
            this.scaleDownDetected = now;
        }
        TimeValue downScaleDelay = (TimeValue)MlAutoscalingDeciderService.DOWN_SCALE_DELAY.get(configuration);
        return downScaleDelay.millis() - (now - this.scaleDownDetected);
    }

    void resetScaleDownCoolDown() {
        this.scaleDownDetected = -1L;
    }

    private boolean newScaleDownCheck() {
        return this.scaleDownDetected == -1L;
    }

    long downScaleDetectedMillis() {
        return this.scaleDownDetected;
    }
}

