/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.AbstractItemSetMapReducer;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public final class InternalItemSetMapReduceAggregation<MapContext extends Closeable, MapFinalContext extends Writeable, ReduceContext extends Closeable, Result extends ToXContent & Writeable>
extends InternalAggregation {
    private final AbstractItemSetMapReducer<MapContext, MapFinalContext, ReduceContext, Result> mapReducer;
    private final BigArrays bigArraysForMapReduce;
    private final List<ItemSetMapReduceValueSource.Field> fields;
    private final boolean profiling;
    private MapFinalContext mapFinalContext = null;
    private Result mapReduceResult = null;

    InternalItemSetMapReduceAggregation(String name, Map<String, Object> metadata, AbstractItemSetMapReducer<MapContext, MapFinalContext, ReduceContext, Result> mapReducer, MapFinalContext mapFinalContext, Result mapReduceResult, List<ItemSetMapReduceValueSource.Field> fields, boolean profiling) {
        super(name, metadata);
        this.mapReducer = Objects.requireNonNull(mapReducer);
        this.mapFinalContext = mapFinalContext;
        this.mapReduceResult = mapReduceResult;
        this.fields = Objects.requireNonNull(fields);
        this.profiling = profiling;
        this.bigArraysForMapReduce = BigArrays.NON_RECYCLING_INSTANCE;
    }

    public InternalItemSetMapReduceAggregation(StreamInput in, Writeable.Reader<AbstractItemSetMapReducer<MapContext, MapFinalContext, ReduceContext, Result>> reader) throws IOException {
        super(in);
        this.bigArraysForMapReduce = BigArrays.NON_RECYCLING_INSTANCE;
        this.mapReducer = (AbstractItemSetMapReducer)reader.read(in);
        if (in.readBoolean()) {
            this.mapFinalContext = this.mapReducer.readMapReduceContext(in, this.bigArraysForMapReduce);
        }
        if (in.readBoolean()) {
            this.mapReduceResult = this.mapReducer.readResult(in, this.bigArraysForMapReduce);
        }
        this.fields = in.readList(ItemSetMapReduceValueSource.Field::new);
        this.profiling = in.readBoolean();
    }

    public String getWriteableName() {
        return this.mapReducer.getWriteableName();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.mapReducer.writeTo(out);
        out.writeOptionalWriteable(this.mapFinalContext);
        out.writeOptionalWriteable((Writeable)this.mapReduceResult);
        out.writeList(this.fields);
        out.writeBoolean(this.profiling);
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext aggReduceContext) {
        Stream<Writeable> contexts = aggregations.stream().map(agg -> {
            assert (agg.getClass().equals(InternalItemSetMapReduceAggregation.class));
            Object context = ((InternalItemSetMapReduceAggregation)((Object)agg)).getMapFinalContext();
            return context;
        }).filter(c -> c != null);
        if (aggReduceContext.isFinalReduce()) {
            try (ReduceContext reduceContext = this.mapReducer.reduceInit(aggReduceContext.bigArrays());){
                this.mapReducer.reduce(contexts, reduceContext, aggReduceContext.isCanceled());
                this.mapReduceResult = this.mapReducer.reduceFinalize(reduceContext, this.fields, aggReduceContext.isCanceled());
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Final reduction failed", (Throwable)e);
            }
            return new InternalItemSetMapReduceAggregation<MapContext, Object, ReduceContext, Result>(this.name, this.metadata, this.mapReducer, null, this.mapReduceResult, this.fields, this.profiling);
        }
        ReduceContext newMapReduceContext = this.mapReducer.reduceInit(this.bigArraysForMapReduce);
        Writeable newMapFinalContext = this.mapReducer.combine(contexts, newMapReduceContext, aggReduceContext.isCanceled());
        return new InternalItemSetMapReduceAggregation<MapContext, Writeable, ReduceContext, Object>(this.name, this.metadata, this.mapReducer, newMapFinalContext, null, this.fields, this.profiling);
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return this.mapReducer.mustReduceOnSingleInternalAgg();
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.mapReduceResult != null) {
            return this.mapReduceResult.toXContent(builder, (ToXContent.Params)new ToXContent.DelegatingMapParams(Map.of("profile", String.valueOf(this.profiling)), params));
        }
        return builder;
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        this.mapReduceResult = this.mapReducer.finalizeSampling(samplingContext, this.mapReduceResult);
        return this;
    }

    MapFinalContext getMapFinalContext() {
        return this.mapFinalContext;
    }

    public Result getMapReduceResult() {
        return this.mapReduceResult;
    }
}

