/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.util.Arrays;
import java.util.OptionalDouble;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

class LeastSquaresOnlineRegression {
    private static final double SINGLE_VALUE_DECOMPOSITION_EPS = 1.0E15;
    private final RunningStatistics statistics;
    private final Array2DRowRealMatrix Nx;
    private final Array2DRowRealMatrix Ny;
    private final Array2DRowRealMatrix Nz;
    private final int N;

    LeastSquaresOnlineRegression(int degrees) {
        this.N = degrees + 1;
        this.statistics = new RunningStatistics(3 * this.N);
        this.Nx = new Array2DRowRealMatrix(this.N, this.N);
        this.Ny = new Array2DRowRealMatrix(this.N, 1);
        this.Nz = new Array2DRowRealMatrix(this.N, 1);
    }

    double rSquared() {
        double var;
        double result = 0.0;
        if (this.statistics.count <= 0.0) {
            return result;
        }
        double residualVariance = var = this.statistics.stats[3 * this.N - 1] - this.statistics.stats[2 * this.N - 1] * this.statistics.stats[2 * this.N - 1];
        int n = this.N + 1;
        boolean done = false;
        while (--n > 0 && !done) {
            if (n == 1) {
                return result;
            }
            if (n == this.N) {
                OptionalDouble maybeResidualVar = this.residualVariance(this.N, this.Nx, this.Ny, this.Nz);
                if (!maybeResidualVar.isPresent()) continue;
                residualVariance = maybeResidualVar.getAsDouble();
                done = true;
                continue;
            }
            Array2DRowRealMatrix x = new Array2DRowRealMatrix(n, n);
            Array2DRowRealMatrix y = new Array2DRowRealMatrix(n, 1);
            Array2DRowRealMatrix z = new Array2DRowRealMatrix(n, 1);
            OptionalDouble maybeResidualVar = this.residualVariance(this.N, this.Nx, this.Ny, this.Nz);
            if (!maybeResidualVar.isPresent()) continue;
            residualVariance = maybeResidualVar.getAsDouble();
            done = true;
        }
        return Math.min(Math.max(1.0 - residualVariance / var, 0.0), 1.0);
    }

    private double[] statisticAdj(double x, double y) {
        double[] d = new double[3 * this.N];
        double xi = 1.0;
        int i = 0;
        while (i < this.N) {
            d[i] = xi;
            d[i + 2 * this.N - 1] = xi * y;
            ++i;
            xi *= x;
        }
        i = 3;
        while (i < 2 * this.N - 1) {
            d[i] = xi;
            ++i;
            xi *= x;
        }
        d[3 * this.N - 1] = y * y;
        return d;
    }

    void add(double x, double y, double weight) {
        this.statistics.add(this.statisticAdj(x, y), weight);
    }

    void remove(double x, double y, double weight) {
        this.statistics.remove(this.statisticAdj(x, y), weight);
    }

    private OptionalDouble residualVariance(int n, Array2DRowRealMatrix x, Array2DRowRealMatrix y, Array2DRowRealMatrix z) {
        if (n == 1) {
            return OptionalDouble.of(this.statistics.stats[3 * this.N - 1] - this.statistics.stats[2 * this.N - 1] * this.statistics.stats[2 * this.N - 1]);
        }
        for (int i = 0; i < n; ++i) {
            x.setEntry(i, i, this.statistics.stats[i + i]);
            y.setEntry(i, 0, this.statistics.stats[i + 2 * this.N - 1]);
            z.setEntry(i, 0, this.statistics.stats[i]);
            for (int j = i + 1; j < n; ++j) {
                x.setEntry(i, j, this.statistics.stats[i + j]);
                x.setEntry(j, i, this.statistics.stats[i + j]);
            }
        }
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)x);
        double[] singularValues = svd.getSingularValues();
        if (singularValues[0] > 1.0E15 * singularValues[n - 1]) {
            return OptionalDouble.empty();
        }
        RealMatrix r = svd.getSolver().solve((RealMatrix)y);
        RealMatrix yr = y.transpose().multiply(r);
        RealMatrix zr = z.transpose().multiply(r);
        double t = this.statistics.stats[2 * this.N - 1] - zr.getEntry(0, 0);
        return OptionalDouble.of(this.statistics.stats[3 * this.N - 1] - yr.getEntry(0, 0) - t * t);
    }

    private static class RunningStatistics {
        private double count = 0.0;
        private final double[] stats;

        RunningStatistics(int size) {
            this.stats = new double[size];
        }

        void add(double[] values, double weight) {
            assert (values.length == this.stats.length) : "passed values for add are not of expected length; unable to update statistics for online least squares regression";
            this.count += weight;
            double alpha = weight / this.count;
            double beta = 1.0 - alpha;
            for (int i = 0; i < this.stats.length; ++i) {
                this.stats[i] = this.stats[i] * beta + alpha * values[i];
            }
        }

        void remove(double[] values, double weight) {
            assert (values.length == this.stats.length) : "passed values for removal are not of expected length; unable to update statistics for online least squares regression";
            this.count = Math.max(this.count - weight, 0.0);
            if (this.count == 0.0) {
                Arrays.fill(this.stats, 0.0);
                return;
            }
            double alpha = weight / this.count;
            double beta = 1.0 + alpha;
            for (int i = 0; i < this.stats.length; ++i) {
                this.stats[i] = this.stats[i] * beta - alpha * values[i];
            }
        }
    }
}

