/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.FastMath;
import org.elasticsearch.common.Randomness;

final class KDE {
    private static final double SQRT2 = FastMath.sqrt((double)2.0);
    private static final double ESTIMATOR_EPS = 1.0E-10;
    private final double[] orderedValues;
    private final double bandwidth;

    private static double maxLikelihoodBandwidth(double[] orderedValues) {
        int step = Math.max((int)((double)orderedValues.length / 10.0 + 0.5), 2);
        IntStream.Builder trainingIndicesBuilder = IntStream.builder();
        IntStream.Builder testIndicesBuilder = IntStream.builder();
        for (int i2 = 0; i2 < orderedValues.length; i2 += step) {
            int adjStep = Math.min(i2 + step, orderedValues.length) - i2;
            List indices = IntStream.range(i2, i2 + adjStep).boxed().collect(Collectors.toList());
            Randomness.shuffle(indices);
            int n = Math.min(adjStep / 2, 4);
            indices.stream().limit(n).forEach(trainingIndicesBuilder::add);
            indices.stream().skip(n).forEach(testIndicesBuilder::add);
        }
        int[] trainingIndices = trainingIndicesBuilder.build().toArray();
        int[] testIndices = testIndicesBuilder.build().toArray();
        Arrays.sort(trainingIndices);
        Arrays.sort(testIndices);
        double[] xTrain = IntStream.of(trainingIndices).mapToDouble(i -> orderedValues[i]).toArray();
        double maxLogLikelihood = -1.7976931348623157E308;
        double result = 0.0;
        for (int i3 = 0; i3 < 20; ++i3) {
            double bandwidth = 0.02 * (double)(i3 + 1) * (orderedValues[orderedValues.length - 1] - orderedValues[0]);
            double logBandwidth = Math.log(bandwidth);
            double logLikelihood = IntStream.of(testIndices).mapToDouble(j -> KDE.logLikelihood(xTrain, bandwidth, logBandwidth, orderedValues[j])).sum();
            if (!(logLikelihood >= maxLogLikelihood)) continue;
            maxLogLikelihood = logLikelihood;
            result = bandwidth;
        }
        return result;
    }

    private static int lowerBound(double[] xs, double x) {
        int retVal = Arrays.binarySearch(xs, x);
        if (retVal < 0) {
            retVal = -1 - retVal;
        }
        return retVal;
    }

    private static double logLikelihood(double[] xs, double bandwidth, double logBandwidth, double x) {
        int a = KDE.lowerBound(xs, x - 3.0 * bandwidth);
        int b = KDE.lowerBound(xs, x + 3.0 * bandwidth);
        double[] logPdfs = IntStream.range(Math.max(Math.min(a, b - 1), 0), Math.min(Math.max(b, a + 1), xs.length)).mapToDouble(i -> {
            double y = (x - xs[i]) / bandwidth;
            return -0.5 * y * y - logBandwidth;
        }).toArray();
        double maxLogPdf = DoubleStream.of(logPdfs).max().orElseThrow();
        double result = DoubleStream.of(logPdfs).map(logPdf -> Math.exp(logPdf - maxLogPdf)).sum();
        return Math.log(result) + maxLogPdf;
    }

    KDE(double[] values, int minIndex, int maxIndex) {
        int excluded = (int)(0.025 * (double)values.length + 0.5);
        double[] orderedValues = new double[values.length];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i >= minIndex - excluded && i <= minIndex + excluded || i >= maxIndex - excluded && i <= maxIndex + excluded) continue;
            orderedValues[j++] = values[i];
        }
        this.orderedValues = Arrays.copyOf(orderedValues, j);
        Arrays.sort(this.orderedValues);
        double var = StatUtils.variance((double[])this.orderedValues);
        this.bandwidth = var > 0.0 ? KDE.maxLikelihoodBandwidth(this.orderedValues) : 0.01 * (values[maxIndex] - values[minIndex]);
    }

    ValueAndMagnitude cdf(double x) {
        int a = KDE.lowerBound(this.orderedValues, x - 4.0 * this.bandwidth);
        int b = KDE.lowerBound(this.orderedValues, x + 4.0 * this.bandwidth);
        double cdf = 0.0;
        double diff = Double.MAX_VALUE;
        for (int i = a; i < Math.min(Math.max(b, a + 1), this.orderedValues.length); ++i) {
            cdf += new NormalDistribution(this.orderedValues[i], this.bandwidth).cumulativeProbability(x);
            diff = Math.min(Math.abs(this.orderedValues[i] - x), diff);
        }
        return new ValueAndMagnitude(cdf /= (double)this.orderedValues.length, diff);
    }

    ValueAndMagnitude sf(double x) {
        int a = KDE.lowerBound(this.orderedValues, x - 4.0 * this.bandwidth);
        int b = KDE.lowerBound(this.orderedValues, x + 4.0 * this.bandwidth);
        double sf = 0.0;
        double diff = Double.MAX_VALUE;
        for (int i = Math.max(Math.min(a, b - 1), 0); i < b; ++i) {
            sf += KDE.normSf(this.orderedValues[i], this.bandwidth, x);
            diff = Math.min(Math.abs(this.orderedValues[i] - x), diff);
        }
        return new ValueAndMagnitude(sf /= (double)this.orderedValues.length, diff);
    }

    static double normSf(double mean, double standardDeviation, double x) {
        double dev = x - mean;
        if (Math.abs(dev) > 40.0 * standardDeviation) {
            return dev > 0.0 ? 0.0 : 1.0;
        }
        return 0.5 * Erf.erfc((double)(dev / (standardDeviation * SQRT2)));
    }

    record ValueAndMagnitude(double value, double magnitude) {
        boolean isMoreSignificant(ValueAndMagnitude o, int numberOfTestedValues) {
            int c = Double.compare(this.significance(numberOfTestedValues), o.significance(numberOfTestedValues));
            if (c != 0) {
                return c < 0;
            }
            return this.magnitude > o.magnitude;
        }

        double significance(int numberOfTestedValues) {
            return this.value > 1.0E-10 ? 1.0 - Math.pow(1.0 - this.value, numberOfTestedValues) : (double)numberOfTestedValues * this.value;
        }
    }
}

