/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntToDoubleFunction;
import java.util.stream.IntStream;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointBucket;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeType;
import org.elasticsearch.xpack.ml.aggs.changepoint.InternalChangePointAggregation;
import org.elasticsearch.xpack.ml.aggs.changepoint.KDE;
import org.elasticsearch.xpack.ml.aggs.changepoint.LeastSquaresOnlineRegression;

public class ChangePointAggregator
extends SiblingPipelineAggregator {
    private static final Logger logger = LogManager.getLogger(ChangePointAggregator.class);
    static final double P_VALUE_THRESHOLD = 0.025;
    private static final int MINIMUM_BUCKETS = 10;
    private static final int MAXIMUM_CANDIDATE_CHANGE_POINTS = 1000;
    private static final KolmogorovSmirnovTest KOLMOGOROV_SMIRNOV_TEST = new KolmogorovSmirnovTest();

    static Tuple<int[], Integer> candidateChangePoints(double[] values) {
        int minValues = Math.max((int)(0.1 * (double)values.length + 0.5), 10);
        if (values.length - 2 * minValues <= 1000) {
            return Tuple.tuple((Object)IntStream.range(minValues, values.length - minValues).toArray(), (Object)1);
        }
        int step = (int)Math.ceil((double)(values.length - 2 * minValues) / 1000.0);
        return Tuple.tuple((Object)IntStream.range(minValues, values.length - minValues).filter(i -> i % step == 0).toArray(), (Object)step);
    }

    public ChangePointAggregator(String name, String bucketsPath, Map<String, Object> metadata) {
        super(name, new String[]{bucketsPath}, metadata);
    }

    public InternalAggregation doReduce(Aggregations aggregations, AggregationReduceContext context) {
        Optional<MlAggsHelper.DoubleBucketValues> maybeBucketsValue = MlAggsHelper.extractDoubleBucketedValues(this.bucketsPaths()[0], aggregations, BucketHelpers.GapPolicy.SKIP, true);
        if (maybeBucketsValue.isEmpty()) {
            return new InternalChangePointAggregation(this.name(), this.metadata(), null, new ChangeType.Indeterminable("unable to find valid bucket values in bucket path [" + this.bucketsPaths()[0] + "]"));
        }
        MlAggsHelper.DoubleBucketValues bucketValues = maybeBucketsValue.get();
        if (bucketValues.getValues().length < 22) {
            return new InternalChangePointAggregation(this.name(), this.metadata(), null, new ChangeType.Indeterminable("not enough buckets to calculate change_point. Requires at least [22]; found [" + bucketValues.getValues().length + "]"));
        }
        Tuple<int[], Integer> candidatePoints = ChangePointAggregator.candidateChangePoints(bucketValues.getValues());
        ChangeType changeType = ChangePointAggregator.changePValue(bucketValues, candidatePoints, 0.025);
        if (changeType.pValue() > 0.025) {
            try {
                changeType = ChangePointAggregator.maxDeviationKdePValue(bucketValues, 0.025);
            }
            catch (NotStrictlyPositiveException nspe) {
                logger.debug("failure calculating spikes", (Throwable)nspe);
            }
        }
        ChangePointBucket changePointBucket = null;
        if (changeType.changePoint() >= 0) {
            changePointBucket = MlAggsHelper.extractBucket(this.bucketsPaths()[0], aggregations, changeType.changePoint()).map(b -> new ChangePointBucket(b.getKey(), b.getDocCount(), (InternalAggregations)b.getAggregations())).orElse(null);
        }
        return new InternalChangePointAggregation(this.name(), this.metadata(), changePointBucket, changeType);
    }

    static ChangeType maxDeviationKdePValue(MlAggsHelper.DoubleBucketValues bucketValues, double pValueThreshold) {
        KDE.ValueAndMagnitude sf;
        double[] timeWindow = bucketValues.getValues();
        double variance = RunningStats.from(timeWindow, i -> 1.0).variance();
        if (variance == 0.0) {
            return new ChangeType.Stationary();
        }
        int minIndex = 0;
        double minValue = Double.MAX_VALUE;
        int maxIndex = 0;
        double maxValue = -1.7976931348623157E308;
        for (int i2 = 0; i2 < timeWindow.length; ++i2) {
            if (timeWindow[i2] < minValue) {
                minValue = timeWindow[i2];
                minIndex = i2;
            }
            if (timeWindow[i2] > maxValue) {
                maxValue = timeWindow[i2];
                maxIndex = i2;
                continue;
            }
            if (timeWindow[i2] != maxValue) continue;
            maxIndex = i2;
        }
        KDE dist = new KDE(timeWindow, minIndex, maxIndex);
        KDE.ValueAndMagnitude cdf = dist.cdf(minValue);
        if (cdf.isMoreSignificant(sf = dist.sf(maxValue), timeWindow.length) && cdf.significance(timeWindow.length) * 2.0 < pValueThreshold) {
            return new ChangeType.Dip(cdf.significance(timeWindow.length) * 2.0, bucketValues.getBucketIndex(minIndex));
        }
        if (sf.significance(timeWindow.length) * 2.0 < pValueThreshold) {
            return new ChangeType.Spike(sf.significance(timeWindow.length) * 2.0, bucketValues.getBucketIndex(maxIndex));
        }
        return new ChangeType.Stationary();
    }

    static ChangeType changePValue(MlAggsHelper.DoubleBucketValues bucketValues, Tuple<int[], Integer> candidateChangePointsAndStep, double pValueThreshold) {
        int i2;
        double dfAlt;
        double totalVariance;
        double[] timeWindow = bucketValues.getValues();
        double totalUnweightedVariance = RunningStats.from(timeWindow, i -> 1.0).variance();
        ChangeType changeType = new ChangeType.Stationary();
        if (totalUnweightedVariance == 0.0) {
            return changeType;
        }
        double[] timeWindowWeights = ChangePointAggregator.outlierWeights(timeWindow);
        int[] candidateChangePoints = (int[])candidateChangePointsAndStep.v1();
        int step = (Integer)candidateChangePointsAndStep.v2();
        double vNull = totalVariance = RunningStats.from(timeWindow, i -> timeWindowWeights[i]).variance();
        if (totalVariance == 0.0) {
            return changeType;
        }
        double n = timeWindow.length;
        double dfNull = n - 1.0;
        LeastSquaresOnlineRegression allLeastSquares = new LeastSquaresOnlineRegression(2);
        for (int i3 = 0; i3 < timeWindow.length; ++i3) {
            allLeastSquares.add(i3, timeWindow[i3], timeWindowWeights[i3]);
        }
        double rValue = allLeastSquares.rSquared();
        double vAlt = totalVariance * (1.0 - Math.abs(rValue));
        double pValueVsNull = ChangePointAggregator.fTestPValue(vNull, dfNull, vAlt, dfAlt = n - 3.0);
        if (pValueVsNull < pValueThreshold && Math.abs(rValue) >= 0.5) {
            double pValueVsStationary = ChangePointAggregator.fTestPValue(totalVariance, n - 1.0, vAlt, dfAlt);
            SimpleRegression regression = new SimpleRegression();
            for (int i4 = 0; i4 < timeWindow.length; ++i4) {
                regression.addData((double)i4, timeWindow[i4]);
            }
            double slope = regression.getSlope();
            changeType = new ChangeType.NonStationary(pValueVsStationary, rValue, slope < 0.0 ? "decreasing" : "increasing");
            vNull = vAlt;
            dfNull = dfAlt;
        }
        RunningStats lowerRange = new RunningStats();
        RunningStats upperRange = new RunningStats();
        upperRange.addValues(timeWindow, i -> timeWindowWeights[i], candidateChangePoints[0], timeWindow.length);
        lowerRange.addValues(timeWindow, i -> timeWindowWeights[i], 0, candidateChangePoints[0]);
        vAlt = Double.MAX_VALUE;
        HashSet<Integer> discoveredChangePoints = new HashSet<Integer>(3, 1.0f);
        int changePoint = candidateChangePoints[candidateChangePoints.length - 1] + 1;
        for (int cp : candidateChangePoints) {
            double maybeVAlt = ((double)cp * lowerRange.variance() + (n - (double)cp) * upperRange.variance()) / n;
            if (maybeVAlt < vAlt) {
                vAlt = maybeVAlt;
                changePoint = cp;
            }
            lowerRange.addValues(timeWindow, i -> timeWindowWeights[i], cp, cp + step);
            upperRange.removeValues(timeWindow, i -> timeWindowWeights[i], cp, cp + step);
        }
        discoveredChangePoints.add(changePoint);
        dfAlt = n - 2.0;
        pValueVsNull = ChangePointAggregator.independentTrialsPValue(ChangePointAggregator.fTestPValue(vNull, dfNull, vAlt, dfAlt), candidateChangePoints.length);
        if (pValueVsNull < pValueThreshold) {
            changeType = new ChangeType.StepChange(pValueVsNull, bucketValues.getBucketIndex(changePoint));
            vNull = vAlt;
            dfNull = dfAlt;
        }
        VarianceAndRValue vAndR = new VarianceAndRValue(Double.MAX_VALUE, Double.MAX_VALUE);
        changePoint = candidateChangePoints[candidateChangePoints.length - 1] + 1;
        lowerRange = new RunningStats();
        upperRange = new RunningStats();
        upperRange.addValues(timeWindow, i -> timeWindowWeights[i], candidateChangePoints[0], timeWindow.length);
        lowerRange.addValues(timeWindow, i -> timeWindowWeights[i], 0, candidateChangePoints[0]);
        LeastSquaresOnlineRegression lowerLeastSquares = new LeastSquaresOnlineRegression(2);
        LeastSquaresOnlineRegression upperLeastSquares = new LeastSquaresOnlineRegression(2);
        for (i2 = 0; i2 < candidateChangePoints[0]; ++i2) {
            lowerLeastSquares.add(i2, timeWindow[i2], timeWindowWeights[i2]);
        }
        i2 = candidateChangePoints[0];
        int x = 0;
        while (i2 < timeWindow.length) {
            upperLeastSquares.add(x, timeWindow[i2], timeWindowWeights[i2]);
            ++i2;
            ++x;
        }
        int upperMovingWindow = 0;
        for (int cp : candidateChangePoints) {
            double v2;
            double lowerRangeVar = lowerRange.variance();
            double upperRangeVar = upperRange.variance();
            double rv1 = lowerLeastSquares.rSquared();
            double rv2 = upperLeastSquares.rSquared();
            double v1 = lowerRangeVar * (1.0 - Math.abs(rv1));
            VarianceAndRValue varianceAndRValue = new VarianceAndRValue(((double)cp * v1 + (n - (double)cp) * (v2 = upperRangeVar * (1.0 - Math.abs(rv2)))) / n, ((double)cp * rv1 + (n - (double)cp) * rv2) / n);
            if (varianceAndRValue.compareTo(vAndR) < 0) {
                vAndR = varianceAndRValue;
                changePoint = cp;
            }
            for (int i5 = 0; i5 < step; ++i5) {
                lowerRange.addValue(timeWindow[i5 + cp], timeWindowWeights[i5 + cp]);
                upperRange.removeValue(timeWindow[i5 + cp], timeWindowWeights[i5 + cp]);
                lowerLeastSquares.add(i5 + cp, timeWindow[i5 + cp], timeWindowWeights[i5 + cp]);
                upperLeastSquares.remove(i5 + upperMovingWindow, timeWindow[i5 + cp], timeWindowWeights[i5 + cp]);
                ++upperMovingWindow;
            }
        }
        discoveredChangePoints.add(changePoint);
        dfAlt = n - 6.0;
        pValueVsNull = ChangePointAggregator.independentTrialsPValue(ChangePointAggregator.fTestPValue(vNull, dfNull, vAndR.variance, dfAlt), candidateChangePoints.length);
        if (pValueVsNull < pValueThreshold && Math.abs(vAndR.rValue) >= 0.5) {
            double pValueVsStationary = ChangePointAggregator.independentTrialsPValue(ChangePointAggregator.fTestPValue(totalVariance, n - 1.0, vAndR.variance, dfAlt), candidateChangePoints.length);
            changeType = new ChangeType.TrendChange(pValueVsStationary, vAndR.rValue, bucketValues.getBucketIndex(changePoint));
        }
        if (changeType.pValue() > 1.0E-5) {
            double diff = 0.0;
            changePoint = -1;
            lowerRange = new RunningStats();
            upperRange = new RunningStats();
            upperRange.addValues(timeWindow, i -> timeWindowWeights[i], candidateChangePoints[0], timeWindow.length);
            lowerRange.addValues(timeWindow, i -> timeWindowWeights[i], 0, candidateChangePoints[0]);
            for (int cp : candidateChangePoints) {
                double otherDiff = (double)Math.min(cp, timeWindow.length - cp) * (0.9 * Math.abs(lowerRange.mean() - upperRange.mean())) + 0.1 * Math.abs(lowerRange.std() - upperRange.std());
                if (otherDiff >= diff) {
                    changePoint = cp;
                    diff = otherDiff;
                }
                lowerRange.addValues(timeWindow, i -> timeWindowWeights[i], cp, cp + step);
                upperRange.removeValues(timeWindow, i -> timeWindowWeights[i], cp, cp + step);
            }
            discoveredChangePoints.add(changePoint);
            double pValue = 1.0;
            Iterator iterator = discoveredChangePoints.iterator();
            while (iterator.hasNext()) {
                int i6 = (Integer)iterator.next();
                double[] x2 = Arrays.copyOfRange(timeWindow, 0, i6);
                double[] y = Arrays.copyOfRange(timeWindow, i6, timeWindow.length);
                double statistic = KOLMOGOROV_SMIRNOV_TEST.kolmogorovSmirnovStatistic(x2, y);
                double d = x2.length > 10000 ? KOLMOGOROV_SMIRNOV_TEST.approximateP(statistic, x2.length, y.length) : KOLMOGOROV_SMIRNOV_TEST.exactP(statistic, x2.length, y.length, false);
                double ksTestPValue = d;
                if (!(ksTestPValue < pValue)) continue;
                changePoint = i6;
                pValue = ksTestPValue;
            }
            if ((pValue = ChangePointAggregator.independentTrialsPValue(pValue, candidateChangePoints.length)) < Math.min(pValueThreshold, 0.1 * changeType.pValue())) {
                changeType = new ChangeType.DistributionChange(pValue, bucketValues.getBucketIndex(changePoint));
            }
        }
        return changeType;
    }

    static double[] outlierWeights(double[] values) {
        int i = (int)Math.ceil(0.025 * (double)values.length);
        double[] weights = Arrays.copyOf(values, values.length);
        Arrays.sort(weights);
        double a = weights[i];
        double b = weights[values.length - i];
        for (int j = 0; j < values.length; ++j) {
            weights[j] = values[j] < b && values[j] >= a ? 1.0 : 0.01;
        }
        return weights;
    }

    static double independentTrialsPValue(double pValue, int nTrials) {
        return pValue > 1.0E-10 ? 1.0 - Math.pow(1.0 - pValue, nTrials) : (double)nTrials * pValue;
    }

    static double fTestPValue(double vNull, double dfNull, double varianceAlt, double dfAlt) {
        if (varianceAlt == vNull) {
            return 1.0;
        }
        if (varianceAlt == 0.0) {
            return 0.0;
        }
        double F = dfAlt / dfNull * vNull / varianceAlt;
        double sf = ChangePointAggregator.fDistribSf(dfNull, dfAlt, F);
        return Math.min(2.0 * sf, 1.0);
    }

    static double fDistribSf(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom, double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            return 0.0;
        }
        return Beta.regularizedBeta((double)(denominatorDegreesOfFreedom / (denominatorDegreesOfFreedom + numeratorDegreesOfFreedom * x)), (double)(0.5 * denominatorDegreesOfFreedom), (double)(0.5 * numeratorDegreesOfFreedom));
    }

    static class RunningStats {
        double sumOfSqrs;
        double sum;
        double count;

        static RunningStats from(double[] values, IntToDoubleFunction weightFunction) {
            return new RunningStats().addValues(values, weightFunction, 0, values.length);
        }

        RunningStats() {
        }

        double variance() {
            return Math.max((this.sumOfSqrs - this.sum * this.sum / this.count) / this.count, 0.0);
        }

        double mean() {
            return this.sum / this.count;
        }

        double std() {
            return Math.sqrt(this.variance());
        }

        RunningStats addValues(double[] value, IntToDoubleFunction weightFunction, int start, int end) {
            for (int i = start; i < value.length && i < end; ++i) {
                this.addValue(value[i], weightFunction.applyAsDouble(i));
            }
            return this;
        }

        RunningStats addValue(double value, double weight) {
            this.sumOfSqrs += value * value * weight;
            this.count += weight;
            this.sum += value * weight;
            return this;
        }

        RunningStats removeValue(double value, double weight) {
            this.sumOfSqrs = Math.max(this.sumOfSqrs - value * value * weight, 0.0);
            this.count = Math.max(this.count - weight, 0.0);
            this.sum -= value * weight;
            return this;
        }

        RunningStats removeValues(double[] value, IntToDoubleFunction weightFunction, int start, int end) {
            for (int i = start; i < value.length && i < end; ++i) {
                this.removeValue(value[i], weightFunction.applyAsDouble(i));
            }
            return this;
        }
    }

    record VarianceAndRValue(double variance, double rValue) implements Comparable<VarianceAndRValue>
    {
        @Override
        public int compareTo(VarianceAndRValue o) {
            int v = Double.compare(this.variance, o.variance);
            if (v == 0) {
                return Double.compare(this.rValue, o.rValue);
            }
            return v;
        }

        public VarianceAndRValue min(VarianceAndRValue other) {
            if (this.compareTo(other) <= 0) {
                return this;
            }
            return other;
        }
    }
}

