/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizationBytesRefHash;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.categorization.SerializableTokenListCategory;
import org.elasticsearch.xpack.ml.aggs.categorization.TokenListCategorizer;

public class InternalCategorizationAggregation
extends InternalMultiBucketAggregation<InternalCategorizationAggregation, Bucket> {
    private final List<Bucket> buckets;
    private final int similarityThreshold;
    private final int requiredSize;
    private final long minDocCount;

    protected InternalCategorizationAggregation(String name, int requiredSize, long minDocCount, int similarityThreshold, Map<String, Object> metadata) {
        this(name, requiredSize, minDocCount, similarityThreshold, metadata, new ArrayList<Bucket>());
    }

    protected InternalCategorizationAggregation(String name, int requiredSize, long minDocCount, int similarityThreshold, Map<String, Object> metadata, List<Bucket> buckets) {
        super(name, metadata);
        this.buckets = buckets;
        this.similarityThreshold = similarityThreshold;
        this.minDocCount = minDocCount;
        this.requiredSize = requiredSize;
    }

    public InternalCategorizationAggregation(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before((VersionId)CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION)) {
            throw new ElasticsearchException("[categorize_text] aggregation cannot be used in a cluster where some nodes have version [" + CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION + "] or higher and others have a version before this", new Object[0]);
        }
        this.similarityThreshold = in.readVInt();
        this.buckets = in.readList(Bucket::new);
        this.requiredSize = InternalCategorizationAggregation.readSize((StreamInput)in);
        this.minDocCount = in.readVLong();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before((VersionId)CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION)) {
            throw new ElasticsearchException("[categorize_text] aggregation cannot be used in a cluster where some nodes have version [" + CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION + "] or higher and others have a version before this", new Object[0]);
        }
        out.writeVInt(this.similarityThreshold);
        out.writeList(this.buckets);
        InternalCategorizationAggregation.writeSize((int)this.requiredSize, (StreamOutput)out);
        out.writeVLong(this.minDocCount);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public InternalCategorizationAggregation create(List<Bucket> buckets) {
        return new InternalCategorizationAggregation(this.name, this.requiredSize, this.minDocCount, this.similarityThreshold, this.metadata, buckets);
    }

    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.serializableCategory, prototype.bucketOrd, aggregations);
    }

    protected Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        throw new UnsupportedOperationException("For optimization purposes, typical bucket path is not supported");
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public String getWriteableName() {
        return "categorize_text";
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        try (CategorizationBytesRefHash hash = new CategorizationBytesRefHash(new BytesRefHash(1L, reduceContext.bigArrays()));){
            TokenListCategorizer categorizer = new TokenListCategorizer(hash, null, (float)this.similarityThreshold / 100.0f);
            block5: for (InternalAggregation aggregation : aggregations) {
                InternalCategorizationAggregation categorizationAggregation = (InternalCategorizationAggregation)aggregation;
                for (Bucket bucket : categorizationAggregation.buckets) {
                    categorizer.mergeWireCategory(bucket.serializableCategory).addSubAggs((InternalAggregations)bucket.getAggregations());
                    if (!((Boolean)reduceContext.isCanceled().get()).booleanValue()) continue;
                    continue block5;
                }
            }
            int size = reduceContext.isFinalReduce() ? Math.min(this.requiredSize, categorizer.getCategoryCount()) : categorizer.getCategoryCount();
            Bucket[] mergedBuckets = categorizer.toOrderedBuckets(size, reduceContext.isFinalReduce() ? this.minDocCount : 0L, reduceContext);
            reduceContext.consumeBucketsAndMaybeBreak(mergedBuckets.length);
            if (reduceContext.isFinalReduce()) {
                Arrays.sort(mergedBuckets, Comparator.comparing(Bucket::getDocCount).reversed().thenComparing(Bucket::getRawKey));
            }
            InternalCategorizationAggregation internalCategorizationAggregation = new InternalCategorizationAggregation(this.name, this.requiredSize, this.minDocCount, this.similarityThreshold, this.metadata, Arrays.asList(mergedBuckets));
            return internalCategorizationAggregation;
        }
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalCategorizationAggregation(this.name, this.requiredSize, this.minDocCount, this.similarityThreshold, this.metadata, this.buckets.stream().map(b -> new Bucket(new SerializableTokenListCategory(b.getSerializableCategory(), samplingContext.scaleUp(b.getDocCount())), b.getBucketOrd(), InternalAggregations.finalizeSampling((InternalAggregations)b.aggregations, (SamplingContext)samplingContext))).collect(Collectors.toList()));
    }

    public int getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public int getRequiredSize() {
        return this.requiredSize;
    }

    public long getMinDocCount() {
        return this.minDocCount;
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements MultiBucketsAggregation.Bucket,
    Comparable<Bucket> {
        private final SerializableTokenListCategory serializableCategory;
        private final BucketKey key;
        private long bucketOrd;
        private InternalAggregations aggregations;

        public Bucket(SerializableTokenListCategory serializableCategory, long bucketOrd) {
            this(serializableCategory, bucketOrd, InternalAggregations.EMPTY);
        }

        public Bucket(SerializableTokenListCategory serializableCategory, long bucketOrd, InternalAggregations aggregations) {
            this.serializableCategory = serializableCategory;
            this.key = new BucketKey(serializableCategory);
            this.bucketOrd = bucketOrd;
            this.aggregations = Objects.requireNonNull(aggregations);
        }

        public Bucket(StreamInput in) throws IOException {
            if (in.getTransportVersion().before((VersionId)CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION)) {
                throw new ElasticsearchException("[categorize_text] aggregation cannot be used in a cluster where some nodes have version [" + CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION + "] or higher and others have a version before this", new Object[0]);
            }
            this.serializableCategory = new SerializableTokenListCategory(in);
            this.key = new BucketKey(this.serializableCategory);
            this.bucketOrd = -1L;
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().before((VersionId)CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION)) {
                throw new ElasticsearchException("[categorize_text] aggregation cannot be used in a cluster where some nodes have version [" + CategorizeTextAggregationBuilder.ALGORITHM_CHANGED_VERSION + "] or higher and others have a version before this", new Object[0]);
            }
            this.serializableCategory.writeTo(out);
            this.aggregations.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.serializableCategory.getNumMatches());
            builder.field(Aggregation.CommonFields.KEY.getPreferredName());
            this.key.toXContent(builder, params);
            builder.field(CategoryDefinition.REGEX.getPreferredName(), this.serializableCategory.getRegex());
            builder.field(CategoryDefinition.MAX_MATCHING_LENGTH.getPreferredName(), this.serializableCategory.maxMatchingStringLen());
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        BucketKey getRawKey() {
            return this.key;
        }

        public Object getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.key.toString();
        }

        public long getDocCount() {
            return this.serializableCategory.getNumMatches();
        }

        public Aggregations getAggregations() {
            return this.aggregations;
        }

        void setAggregations(InternalAggregations aggregations) {
            this.aggregations = aggregations;
        }

        long getBucketOrd() {
            return this.bucketOrd;
        }

        SerializableTokenListCategory getSerializableCategory() {
            return this.serializableCategory;
        }

        public String toString() {
            return "Bucket{key=" + this.getKeyAsString() + ", docCount=" + this.serializableCategory.getNumMatches() + ", aggregations=" + this.aggregations.asMap() + "}\n";
        }

        @Override
        public int compareTo(Bucket other) {
            return Long.signum(this.serializableCategory.getNumMatches() - other.serializableCategory.getNumMatches());
        }
    }

    static class BucketKey
    implements ToXContentFragment,
    Comparable<BucketKey> {
        private final BytesRef[] key;

        BucketKey(SerializableTokenListCategory serializableCategory) {
            this.key = serializableCategory.getKeyTokens();
        }

        BucketKey(BytesRef[] key) {
            this.key = key;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.toString());
        }

        public String toString() {
            return Arrays.stream(this.key).map(BytesRef::utf8ToString).collect(Collectors.joining(" "));
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BucketKey that = (BucketKey)other;
            return Arrays.equals(this.key, that.key);
        }

        public BytesRef[] keyAsTokens() {
            return this.key;
        }

        @Override
        public int compareTo(BucketKey o) {
            return Arrays.compare((Comparable[])this.key, (Comparable[])o.key);
        }
    }
}

