/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;

public class TransportGetDatafeedsAction
extends TransportMasterNodeReadAction<GetDatafeedsAction.Request, GetDatafeedsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedsAction.class);
    private final DatafeedManager datafeedManager;

    @Inject
    public TransportGetDatafeedsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DatafeedManager datafeedManager, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/xpack/ml/datafeeds/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsAction.Request::new, indexNameExpressionResolver, GetDatafeedsAction.Response::new, "same");
        this.datafeedManager = datafeedManager;
    }

    protected void masterOperation(Task task, GetDatafeedsAction.Request request, ClusterState state, ActionListener<GetDatafeedsAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        logger.debug("Get datafeed '{}'", (Object)request.getDatafeedId());
        this.datafeedManager.getDatafeeds(request, parentTaskId, (ActionListener<QueryPage<DatafeedConfig>>)ActionListener.wrap(datafeeds -> listener.onResponse((Object)new GetDatafeedsAction.Response(datafeeds)), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(GetDatafeedsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

