/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.structure.AccessAnyD;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.structure.TransformationAnyD;

public interface MutateAnyD
extends StructureAnyD,
Mutate1D {
    @Override
    default public void set(long index, Comparable<?> value) {
        this.set(StructureAnyD.reference(index, this.shape()), value);
    }

    @Override
    default public void set(long index, double value) {
        this.set(StructureAnyD.reference(index, this.shape()), value);
    }

    @Override
    default public void set(long index, float value) {
        this.set(StructureAnyD.reference(index, this.shape()), value);
    }

    public void set(long[] var1, Comparable<?> var2);

    public void set(long[] var1, double var2);

    default public void set(long[] reference, float value) {
        this.set(reference, (double)value);
    }

    public static interface Receiver<N extends Comparable<N>>
    extends MutateAnyD,
    Fillable<N>,
    Consumer<AccessAnyD<?>> {
        @Override
        default public void accept(AccessAnyD<?> supplied) {
            if (!this.isAcceptable(supplied)) {
                throw new ProgrammingError("Not acceptable!");
            }
            supplied.loopAll((long[] ref) -> this.set(ref, (Comparable<?>)supplied.get(ref)));
        }

        default public boolean isAcceptable(StructureAnyD supplier) {
            boolean retVal = true;
            int tmpRank = MissingMath.max(this.shape().length, this.shape().length);
            for (int i = 0; i < tmpRank; ++i) {
                retVal &= this.count(i) >= supplier.count(i);
            }
            return retVal;
        }
    }

    public static interface ModifiableReceiver<N extends Comparable<N>>
    extends Modifiable<N>,
    Receiver<N>,
    AccessAnyD<N> {
        public void modifyAny(TransformationAnyD<N> var1);
    }

    public static interface Modifiable<N extends Comparable<N>>
    extends StructureAnyD,
    Mutate1D.Modifiable<N> {
        @Override
        default public void add(long index, Comparable<?> addend) {
            this.add(StructureAnyD.reference(index, this.shape()), addend);
        }

        @Override
        default public void add(long index, double addend) {
            this.add(StructureAnyD.reference(index, this.shape()), addend);
        }

        @Override
        default public void add(long index, float addend) {
            this.add(StructureAnyD.reference(index, this.shape()), addend);
        }

        public void add(long[] var1, Comparable<?> var2);

        public void add(long[] var1, double var2);

        default public void add(long[] reference, float addend) {
            this.add(reference, (double)addend);
        }

        public void modifyOne(long[] var1, UnaryFunction<N> var2);

        public void modifySet(int var1, long var2, UnaryFunction<N> var4);

        public void modifySet(long[] var1, int var2, UnaryFunction<N> var3);
    }

    public static interface Mixable<N extends Comparable<N>>
    extends StructureAnyD,
    Mutate1D.Mixable<N> {
        @Override
        default public double mix(long index, BinaryFunction<N> mixer, double addend) {
            return this.mix(StructureAnyD.reference(index, this.shape()), mixer, (N)addend);
        }

        @Override
        default public N mix(long index, BinaryFunction<N> mixer, N addend) {
            return this.mix(StructureAnyD.reference(index, this.shape()), mixer, addend);
        }

        public double mix(long[] var1, BinaryFunction<N> var2, double var3);

        public N mix(long[] var1, BinaryFunction<N> var2, N var3);
    }

    public static interface Fillable<N extends Comparable<N>>
    extends StructureAnyD,
    Mutate1D.Fillable<N> {
        public void fillOne(long[] var1, N var2);

        public void fillOne(long[] var1, NullaryFunction<?> var2);

        public void fillSet(int var1, long var2, N var4);

        public void fillSet(int var1, long var2, NullaryFunction<?> var4);

        public void fillSet(long[] var1, int var2, N var3);

        public void fillSet(long[] var1, int var2, NullaryFunction<?> var3);
    }
}

