/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.SampleSet;

public final class FrequencyMap<T> {
    private final ConcurrentHashMap<T, LongAdder> myFrequencyMap = new ConcurrentHashMap();
    private final LongAdder myPopulation = new LongAdder();

    public FrequencyMap() {
    }

    public FrequencyMap(Iterable<? extends T> initial) {
        for (T element : initial) {
            this.get(element);
        }
    }

    public void add(T element, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        this.get(element).add(count);
        this.myPopulation.add(count);
    }

    public void addAll(Map<? extends T, ? extends Number> frequencies) {
        for (Map.Entry<T, Number> entry : frequencies.entrySet()) {
            this.add(entry.getKey(), entry.getValue().longValue());
        }
    }

    public long count() {
        return this.myPopulation.longValue();
    }

    public Set<T> elements() {
        return this.myFrequencyMap.keySet();
    }

    public Set<T> elements(FrequencyPredicate<T> predicate) {
        HashSet<T> retVal = new HashSet<T>();
        SampleSet sample = this.sample();
        for (Map.Entry<T, LongAdder> entry : this.myFrequencyMap.entrySet()) {
            if (!predicate.test(entry.getKey(), sample, entry.getValue().longValue())) continue;
            retVal.add(entry.getKey());
        }
        return retVal;
    }

    public long getFrequency(T element) {
        return this.myFrequencyMap.getOrDefault(element, new LongAdder()).longValue();
    }

    public long getMaximumFrequenecy() {
        Map.Entry<T, LongAdder> entryWithHighestFrequenecy = this.getEntryWithHighestFrequenecy();
        if (entryWithHighestFrequenecy != null) {
            return entryWithHighestFrequenecy.getValue().longValue();
        }
        return 0L;
    }

    public T getMode() {
        Map.Entry<T, LongAdder> entryWithHighestFrequenecy = this.getEntryWithHighestFrequenecy();
        if (entryWithHighestFrequenecy != null) {
            return entryWithHighestFrequenecy.getKey();
        }
        return null;
    }

    public double getRelativeFrequency(T element) {
        if (this.myPopulation.sum() == 0L) {
            return PrimitiveMath.ZERO;
        }
        return (double)this.getFrequency(element) / this.myPopulation.doubleValue();
    }

    public void increment(T element) {
        this.get(element).increment();
        this.myPopulation.increment();
    }

    public void incrementAll(Iterable<? extends T> elements) {
        for (T element : elements) {
            this.increment(element);
        }
    }

    public void reset() {
        this.myFrequencyMap.clear();
        this.myPopulation.reset();
    }

    public SampleSet sample() {
        Set<Map.Entry<T, LongAdder>> entries = this.myFrequencyMap.entrySet();
        double[] frequencies = new double[entries.size()];
        int index = 0;
        for (Map.Entry<T, LongAdder> entry : entries) {
            frequencies[index++] = entry.getValue().doubleValue();
        }
        return SampleSet.wrap(frequencies);
    }

    private LongAdder get(T element) {
        return this.myFrequencyMap.computeIfAbsent(element, k -> new LongAdder());
    }

    private Map.Entry<T, LongAdder> getEntryWithHighestFrequenecy() {
        Map.Entry<T, LongAdder> retVal = null;
        long maximum = 0L;
        for (Map.Entry<T, LongAdder> entry : this.myFrequencyMap.entrySet()) {
            if (entry.getValue().longValue() <= maximum) continue;
            maximum = entry.getValue().longValue();
            retVal = entry;
        }
        return retVal;
    }

    @FunctionalInterface
    public static interface FrequencyPredicate<T> {
        public boolean test(T var1, SampleSet var2, long var3);
    }
}

