/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.GammaFunction;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.Normal;

public class ChiSquareDistribution
extends AbstractContinuous {
    private static final double _0_0001 = 1.0E-4;
    static final Normal NORMAL = new Normal();
    private final double myDegreesOfFreedom;

    public static ChiSquareDistribution of(int degreesOfFreedom) {
        if (degreesOfFreedom == 2) {
            return new Degree2();
        }
        if (degreesOfFreedom > 50) {
            return new NormalApproximation(degreesOfFreedom);
        }
        return new ChiSquareDistribution(degreesOfFreedom);
    }

    ChiSquareDistribution(double degreesOfFreedom) {
        this.myDegreesOfFreedom = degreesOfFreedom;
    }

    @Override
    public final double getDensity(double value) {
        if (value <= PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return this.calculateDensity(value);
    }

    @Override
    public double getDistribution(double value) {
        return GammaFunction.Regularized.lower(this.myDegreesOfFreedom / PrimitiveMath.TWO, value / PrimitiveMath.TWO);
    }

    @Override
    public double getExpected() {
        return this.myDegreesOfFreedom;
    }

    @Override
    public double getQuantile(double probability) {
        double retVal = this.approximateQuantile(probability);
        if (Double.isInfinite(retVal)) {
            return retVal;
        }
        double reverse = this.getDistribution(retVal);
        double lower = retVal;
        double higher = retVal;
        if (probability - reverse > 1.0E-4) {
            while (this.getDistribution(higher *= PrimitiveMath.TWO) <= probability) {
            }
        } else if (reverse - probability > 1.0E-4) {
            while (this.getDistribution(lower /= PrimitiveMath.TWO) >= probability) {
            }
        } else {
            return retVal;
        }
        do {
            if ((reverse = this.getDistribution(retVal = (lower + higher) / PrimitiveMath.TWO)) < probability) {
                lower = retVal;
                continue;
            }
            if (!(reverse > probability)) continue;
            higher = retVal;
        } while (Math.abs(reverse - probability) >= 1.0E-4);
        return retVal;
    }

    @Override
    public double getVariance() {
        return PrimitiveMath.TWO * this.myDegreesOfFreedom;
    }

    private double approximateQuantile(double probability) {
        return MissingMath.power(NORMAL.getQuantile(probability) + Math.sqrt(PrimitiveMath.TWO * this.myDegreesOfFreedom - PrimitiveMath.ONE), 2) / PrimitiveMath.TWO;
    }

    double calculateDensity(double value) {
        double halfFreedom = this.myDegreesOfFreedom / PrimitiveMath.TWO;
        return Math.pow(value, halfFreedom - PrimitiveMath.ONE) * Math.exp(-value / PrimitiveMath.TWO) / (Math.pow(PrimitiveMath.TWO, halfFreedom) * GammaFunction.gamma(halfFreedom));
    }

    static final class NormalApproximation
    extends ChiSquareDistribution {
        private final Normal myApproximation;

        NormalApproximation(double degreesOfFreedom) {
            super(degreesOfFreedom);
            this.myApproximation = new Normal(degreesOfFreedom, Math.sqrt(PrimitiveMath.TWO * degreesOfFreedom));
        }

        @Override
        public double getDistribution(double value) {
            return this.myApproximation.getDistribution(value);
        }

        @Override
        public double getExpected() {
            return this.myApproximation.getExpected();
        }

        @Override
        public double getQuantile(double probability) {
            return this.myApproximation.getQuantile(probability);
        }

        @Override
        public double getStandardDeviation() {
            return this.myApproximation.getStandardDeviation();
        }

        @Override
        public double getVariance() {
            return this.myApproximation.getVariance();
        }

        @Override
        double calculateDensity(double value) {
            return this.myApproximation.getDensity(value);
        }
    }

    static final class Degree2
    extends ChiSquareDistribution {
        Degree2() {
            super(PrimitiveMath.TWO);
        }

        @Override
        public double getDistribution(double value) {
            return -Math.expm1(-value / PrimitiveMath.TWO);
        }

        @Override
        double calculateDensity(double value) {
            return Math.exp(-value / PrimitiveMath.TWO) / PrimitiveMath.TWO;
        }
    }
}

