/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.logstash.LogstashInfoTransportAction;
import org.elasticsearch.xpack.logstash.LogstashUsageTransportAction;
import org.elasticsearch.xpack.logstash.action.DeletePipelineAction;
import org.elasticsearch.xpack.logstash.action.GetPipelineAction;
import org.elasticsearch.xpack.logstash.action.PutPipelineAction;
import org.elasticsearch.xpack.logstash.action.TransportDeletePipelineAction;
import org.elasticsearch.xpack.logstash.action.TransportGetPipelineAction;
import org.elasticsearch.xpack.logstash.action.TransportPutPipelineAction;
import org.elasticsearch.xpack.logstash.rest.RestDeletePipelineAction;
import org.elasticsearch.xpack.logstash.rest.RestGetPipelineAction;
import org.elasticsearch.xpack.logstash.rest.RestPutPipelineAction;

public class Logstash
extends Plugin
implements SystemIndexPlugin {
    public static final String LOGSTASH_CONCRETE_INDEX_NAME = ".logstash";
    public static final String LOGSTASH_INDEX_NAME_PATTERN = ".logstash*";
    static final LicensedFeature.Momentary LOGSTASH_FEATURE = LicensedFeature.momentary(null, (String)"logstash", (License.OperationMode)License.OperationMode.STANDARD);

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.LOGSTASH, LogstashUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.LOGSTASH, LogstashInfoTransportAction.class), new ActionPlugin.ActionHandler((ActionType)PutPipelineAction.INSTANCE, TransportPutPipelineAction.class), new ActionPlugin.ActionHandler((ActionType)GetPipelineAction.INSTANCE, TransportGetPipelineAction.class), new ActionPlugin.ActionHandler((ActionType)DeletePipelineAction.INSTANCE, TransportDeletePipelineAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestPutPipelineAction(), new RestGetPipelineAction(), new RestDeletePipelineAction());
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(SystemIndexDescriptor.builder().setIndexPattern(LOGSTASH_INDEX_NAME_PATTERN).setPrimaryIndex(LOGSTASH_CONCRETE_INDEX_NAME).setDescription("Contains data for Logstash Central Management").setMappings(this.getIndexMappings()).setSettings(this.getIndexSettings()).setVersionMetaKey("logstash-version").setOrigin("logstash_management").build());
    }

    private Settings getIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put(EngineConfig.INDEX_CODEC_SETTING.getKey(), "best_compression").build();
    }

    private XContentBuilder getIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_doc");
            builder.field("dynamic", "strict");
            builder.startObject("_meta");
            builder.field("logstash-version", (ToXContent)Version.CURRENT);
            builder.endObject();
            builder.startObject("properties");
            builder.startObject("description");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("last_modified");
            builder.field("type", "date");
            builder.endObject();
            builder.startObject("pipeline_metadata");
            builder.startObject("properties");
            builder.startObject("version");
            builder.field("type", "short");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("pipeline");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("pipeline_settings");
            builder.field("dynamic", false);
            builder.field("type", "object");
            builder.endObject();
            builder.startObject("username");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("metadata");
            builder.field("dynamic", false);
            builder.field("type", "object");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .logstash index mappings", e);
        }
    }

    public String getFeatureName() {
        return "logstash_management";
    }

    public String getFeatureDescription() {
        return "Enables Logstash Central Management pipeline storage";
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return templates -> {
            templates.remove("logstash-index-template");
            return templates;
        };
    }
}

