/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.idp.action.DeleteSamlServiceProviderRequest;
import org.elasticsearch.xpack.idp.action.DeleteSamlServiceProviderResponse;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderIndex;

public class TransportDeleteSamlServiceProviderAction
extends HandledTransportAction<DeleteSamlServiceProviderRequest, DeleteSamlServiceProviderResponse> {
    private final Logger logger = LogManager.getLogger(TransportDeleteSamlServiceProviderAction.class);
    private final SamlServiceProviderIndex index;

    @Inject
    public TransportDeleteSamlServiceProviderAction(TransportService transportService, ActionFilters actionFilters, SamlServiceProviderIndex index) {
        super("cluster:admin/idp/saml/sp/delete", transportService, actionFilters, DeleteSamlServiceProviderRequest::new);
        this.index = index;
    }

    protected void doExecute(Task task, DeleteSamlServiceProviderRequest request, ActionListener<DeleteSamlServiceProviderResponse> listener) {
        String entityId = request.getEntityId();
        this.index.findByEntityId(entityId, (ActionListener<Set<SamlServiceProviderIndex.DocumentSupplier>>)ActionListener.wrap(matchingDocuments -> {
            if (matchingDocuments.isEmpty()) {
                listener.onResponse((Object)new DeleteSamlServiceProviderResponse(null, entityId));
            } else if (matchingDocuments.size() == 1) {
                SamlServiceProviderIndex.DocumentSupplier docInfo = (SamlServiceProviderIndex.DocumentSupplier)Iterables.get((Iterable)matchingDocuments, (int)0);
                SamlServiceProviderDocument existingDoc = docInfo.getDocument();
                assert (existingDoc.docId != null) : "Loaded document with no doc id";
                assert (existingDoc.entityId.equals(entityId)) : "Loaded document with non-matching entity-id";
                this.logger.info("Deleting Service Provider [{}]", (Object)existingDoc);
                this.index.deleteDocument(docInfo.version, request.getRefreshPolicy(), (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> listener.onResponse((Object)new DeleteSamlServiceProviderResponse((DeleteResponse)deleteResponse, entityId)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                this.logger.warn("Found multiple existing service providers in [{}] with entity id [{}] - [{}]", (Object)this.index, (Object)entityId, (Object)matchingDocuments.stream().map(d -> d.getDocument().docId).collect(Collectors.joining(",")));
                listener.onFailure((Exception)new IllegalStateException("Multiple service providers exist with entity id [" + entityId + "]"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

