/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.eql.EqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.eql.plugin.EqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.EqlStatsRequest;
import org.elasticsearch.xpack.eql.plugin.EqlStatsResponse;

public class EqlUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public EqlUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(XPackUsageFeatureAction.EQL.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        EqlStatsRequest eqlRequest = new EqlStatsRequest();
        eqlRequest.includeStats(true);
        eqlRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute((ActionType)EqlStatsAction.INSTANCE, (ActionRequest)eqlRequest, ActionListener.wrap(r -> {
            List countersPerNode = r.getNodes().stream().map(EqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
            Counters mergedCounters = Counters.merge(countersPerNode);
            EqlFeatureSetUsage usage = new EqlFeatureSetUsage(mergedCounters.toNestedMap());
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)usage));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

