/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.action.DeleteSearchApplicationAction;

public class TransportDeleteSearchApplicationAction
extends HandledTransportAction<DeleteSearchApplicationAction.Request, AcknowledgedResponse> {
    protected final SearchApplicationIndexService systemIndexService;

    @Inject
    public TransportDeleteSearchApplicationAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, BigArrays bigArrays) {
        super("cluster:admin/xpack/application/search_application/delete", transportService, actionFilters, DeleteSearchApplicationAction.Request::new);
        this.systemIndexService = new SearchApplicationIndexService(client, clusterService, namedWriteableRegistry, bigArrays);
    }

    protected void doExecute(Task task, DeleteSearchApplicationAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String name = request.getName();
        this.systemIndexService.deleteSearchApplicationAndAlias(name, (ActionListener<DeleteResponse>)listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

