/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SearchApplicationListItem
implements Writeable,
ToXContentObject {
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField ANALYTICS_COLLECTION_NAME_FIELD = new ParseField("analytics_collection_name", new String[0]);
    public static final ParseField UPDATED_AT_MILLIS_FIELD = new ParseField("updated_at_millis", new String[0]);
    private final String name;
    private final String analyticsCollectionName;
    private final long updatedAtMillis;
    private static final ConstructingObjectParser<SearchApplicationListItem, String> PARSER = new ConstructingObjectParser("search_application_list_item`", false, params -> {
        String name = (String)params[0];
        String analyticsCollectionName = (String)params[2];
        Long updatedAtMillis = (Long)params[3];
        return new SearchApplicationListItem(name, analyticsCollectionName, updatedAtMillis);
    });

    public SearchApplicationListItem(String name, @Nullable String analyticsCollectionName, long updatedAtMillis) {
        Objects.requireNonNull(name, "Name cannot be null on a SearchApplicationListItem");
        this.name = name;
        this.analyticsCollectionName = analyticsCollectionName;
        this.updatedAtMillis = updatedAtMillis;
    }

    public SearchApplicationListItem(StreamInput in) throws IOException {
        this.name = in.readString();
        this.analyticsCollectionName = in.readOptionalString();
        this.updatedAtMillis = in.readLong();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        if (this.analyticsCollectionName != null) {
            builder.field(ANALYTICS_COLLECTION_NAME_FIELD.getPreferredName(), this.analyticsCollectionName);
        }
        builder.field(UPDATED_AT_MILLIS_FIELD.getPreferredName(), this.updatedAtMillis);
        builder.endObject();
        return builder;
    }

    public SearchApplicationListItem fromXContent(XContentParser parser) {
        return (SearchApplicationListItem)PARSER.apply(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.analyticsCollectionName);
        out.writeLong(this.updatedAtMillis);
    }

    public String name() {
        return this.name;
    }

    public String analyticsCollectionName() {
        return this.analyticsCollectionName;
    }

    public long updatedAtMillis() {
        return this.updatedAtMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchApplicationListItem item = (SearchApplicationListItem)o;
        return this.name.equals(item.name) && Objects.equals(this.analyticsCollectionName, item.analyticsCollectionName) && this.updatedAtMillis == item.updatedAtMillis;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.analyticsCollectionName, this.updatedAtMillis);
    }

    static {
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ANALYTICS_COLLECTION_NAME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), UPDATED_AT_MILLIS_FIELD);
    }
}

